/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.sub.runtime.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.exception.NotFoundException;
import org.eximeebpms.bpm.engine.rest.dto.SuspensionStateDto;
import org.eximeebpms.bpm.engine.rest.dto.batch.BatchDto;
import org.eximeebpms.bpm.engine.rest.dto.runtime.ActivityInstanceDto;
import org.eximeebpms.bpm.engine.rest.dto.runtime.ProcessInstanceDto;
import org.eximeebpms.bpm.engine.rest.dto.runtime.modification.ProcessInstanceModificationDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.sub.VariableResource;
import org.eximeebpms.bpm.engine.rest.sub.runtime.ProcessInstanceCommentResource;
import org.eximeebpms.bpm.engine.rest.sub.runtime.ProcessInstanceResource;
import org.eximeebpms.bpm.engine.rest.sub.runtime.impl.ExecutionVariablesResource;
import org.eximeebpms.bpm.engine.rest.sub.runtime.impl.ProcessInstanceCommentResourceImpl;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceModificationBuilder;

public class ProcessInstanceResourceImpl
implements ProcessInstanceResource {
    protected ProcessEngine engine;
    protected String processInstanceId;
    protected ObjectMapper objectMapper;

    public ProcessInstanceResourceImpl(ProcessEngine engine, String processInstanceId, ObjectMapper objectMapper) {
        this.engine = engine;
        this.processInstanceId = processInstanceId;
        this.objectMapper = objectMapper;
    }

    @Override
    public ProcessInstanceDto getProcessInstance() {
        RuntimeService runtimeService = this.engine.getRuntimeService();
        ProcessInstance instance = (ProcessInstance)runtimeService.createProcessInstanceQuery().processInstanceId(this.processInstanceId).singleResult();
        if (instance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Process instance with id " + this.processInstanceId + " does not exist");
        }
        ProcessInstanceDto result = ProcessInstanceDto.fromProcessInstance(instance);
        return result;
    }

    @Override
    public void deleteProcessInstance(boolean skipCustomListeners, boolean skipIoMappings, boolean skipSubprocesses, boolean failIfNotExists) {
        RuntimeService runtimeService = this.engine.getRuntimeService();
        try {
            if (failIfNotExists) {
                runtimeService.deleteProcessInstance(this.processInstanceId, null, skipCustomListeners, true, skipIoMappings, skipSubprocesses);
            } else {
                runtimeService.deleteProcessInstanceIfExists(this.processInstanceId, null, skipCustomListeners, true, skipIoMappings, skipSubprocesses);
            }
        }
        catch (NotFoundException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)e), e.getMessage());
        }
    }

    @Override
    public VariableResource getVariablesResource() {
        return new ExecutionVariablesResource(this.engine, this.processInstanceId, true, this.objectMapper);
    }

    @Override
    public ActivityInstanceDto getActivityInstanceTree() {
        RuntimeService runtimeService = this.engine.getRuntimeService();
        ActivityInstance activityInstance = null;
        try {
            activityInstance = runtimeService.getActivityInstance(this.processInstanceId);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), e.getMessage());
        }
        if (activityInstance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Process instance with id " + this.processInstanceId + " does not exist");
        }
        ActivityInstanceDto result = ActivityInstanceDto.fromActivityInstance(activityInstance);
        return result;
    }

    @Override
    public void updateSuspensionState(SuspensionStateDto dto) {
        dto.updateSuspensionState(this.engine, this.processInstanceId);
    }

    @Override
    public void modifyProcessInstance(ProcessInstanceModificationDto dto) {
        if (dto.getInstructions() != null && !dto.getInstructions().isEmpty()) {
            ProcessInstanceModificationBuilder modificationBuilder = this.engine.getRuntimeService().createProcessInstanceModification(this.processInstanceId);
            dto.applyTo(modificationBuilder, this.engine, this.objectMapper);
            if (dto.getAnnotation() != null) {
                modificationBuilder.setAnnotation(dto.getAnnotation());
            }
            modificationBuilder.cancellationSourceExternal(true);
            modificationBuilder.execute(dto.isSkipCustomListeners(), dto.isSkipIoMappings());
        }
    }

    @Override
    public BatchDto modifyProcessInstanceAsync(ProcessInstanceModificationDto dto) {
        Batch batch = null;
        if (dto.getInstructions() != null && !dto.getInstructions().isEmpty()) {
            ProcessInstanceModificationBuilder modificationBuilder = this.engine.getRuntimeService().createProcessInstanceModification(this.processInstanceId);
            dto.applyTo(modificationBuilder, this.engine, this.objectMapper);
            if (dto.getAnnotation() != null) {
                modificationBuilder.setAnnotation(dto.getAnnotation());
            }
            modificationBuilder.cancellationSourceExternal(true);
            try {
                batch = modificationBuilder.executeAsync(dto.isSkipCustomListeners(), dto.isSkipIoMappings());
            }
            catch (BadUserRequestException e) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
            }
            return BatchDto.fromBatch(batch);
        }
        throw new InvalidRequestException(Response.Status.BAD_REQUEST, "The provided instuctions are invalid.");
    }

    @Override
    public ProcessInstanceCommentResource getProcessInstanceCommentResource() {
        return new ProcessInstanceCommentResourceImpl(this.engine, this.processInstanceId);
    }
}

