/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH
 * under one or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information regarding copyright
 * ownership. Camunda licenses this file to you under the Apache License,
 * Version 2.0; you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.eximeebpms.bpm.engine.impl.migration.instance;

import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;

/**
 * Represents a instance which will be created by a migration, i.e.
 * new event subscriptions or jobs.
 */
public interface EmergingInstance {

  /**
   * Creates this instance and attachs it to the given execution.
   *
   * @param scopeExecution the execution to attach the new instance
   */
  void create(ExecutionEntity scopeExecution);

}
