/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.application.impl.context;

import java.util.concurrent.Callable;
import org.eximeebpms.bpm.application.InvocationContext;
import org.eximeebpms.bpm.application.ProcessApplicationContext;
import org.eximeebpms.bpm.application.ProcessApplicationInterface;
import org.eximeebpms.bpm.application.ProcessApplicationReference;
import org.eximeebpms.bpm.application.ProcessApplicationUnavailableException;
import org.eximeebpms.bpm.application.impl.embedded.TestApplicationWithoutEngine;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.delegate.BaseDelegateExecution;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ProcessApplicationContextTest
extends PluggableProcessEngineTest {
    protected TestApplicationWithoutEngine pa;

    @Before
    public void setUp() {
        this.pa = new TestApplicationWithoutEngine();
        this.pa.deploy();
    }

    @After
    public void tearDown() {
        this.pa.undeploy();
    }

    @Test
    public void testSetPAContextByName() throws ProcessApplicationUnavailableException {
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
        try {
            ProcessApplicationContext.setCurrentProcessApplication((String)this.pa.getName());
            Assert.assertEquals((Object)this.getCurrentContextApplication().getProcessApplication(), (Object)((Object)this.pa));
        }
        finally {
            ProcessApplicationContext.clear();
        }
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
    }

    @Test
    public void testExecutionInPAContextByName() throws Exception {
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
        ProcessApplicationReference contextPA = (ProcessApplicationReference)ProcessApplicationContext.withProcessApplicationContext((Callable)new Callable<ProcessApplicationReference>(){

            @Override
            public ProcessApplicationReference call() throws Exception {
                return ProcessApplicationContextTest.this.getCurrentContextApplication();
            }
        }, (String)this.pa.getName());
        Assert.assertEquals((Object)contextPA.getProcessApplication(), (Object)((Object)this.pa));
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
    }

    @Test
    public void testSetPAContextByReference() throws ProcessApplicationUnavailableException {
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
        try {
            ProcessApplicationContext.setCurrentProcessApplication((ProcessApplicationReference)this.pa.getReference());
            Assert.assertEquals((Object)this.getCurrentContextApplication().getProcessApplication(), (Object)((Object)this.pa));
        }
        finally {
            ProcessApplicationContext.clear();
        }
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
    }

    @Test
    public void testExecutionInPAContextByReference() throws Exception {
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
        ProcessApplicationReference contextPA = (ProcessApplicationReference)ProcessApplicationContext.withProcessApplicationContext((Callable)new Callable<ProcessApplicationReference>(){

            @Override
            public ProcessApplicationReference call() throws Exception {
                return ProcessApplicationContextTest.this.getCurrentContextApplication();
            }
        }, (ProcessApplicationReference)this.pa.getReference());
        Assert.assertEquals((Object)contextPA.getProcessApplication(), (Object)((Object)this.pa));
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
    }

    @Test
    public void testSetPAContextByRawPA() throws ProcessApplicationUnavailableException {
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
        try {
            ProcessApplicationContext.setCurrentProcessApplication((ProcessApplicationInterface)this.pa);
            Assert.assertEquals((Object)((Object)this.pa), (Object)this.getCurrentContextApplication().getProcessApplication());
        }
        finally {
            ProcessApplicationContext.clear();
        }
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
    }

    @Test
    public void testExecutionInPAContextbyRawPA() throws Exception {
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
        ProcessApplicationReference contextPA = (ProcessApplicationReference)ProcessApplicationContext.withProcessApplicationContext((Callable)new Callable<ProcessApplicationReference>(){

            @Override
            public ProcessApplicationReference call() throws Exception {
                return ProcessApplicationContextTest.this.getCurrentContextApplication();
            }
        }, (ProcessApplicationInterface)this.pa);
        Assert.assertEquals((Object)contextPA.getProcessApplication(), (Object)((Object)this.pa));
        Assert.assertNull((Object)Context.getCurrentProcessApplication());
    }

    @Test
    public void testCannotSetUnregisteredProcessApplicationName() {
        String nonExistingName = this.pa.getName() + this.pa.getName();
        try {
            ProcessApplicationContext.setCurrentProcessApplication((String)nonExistingName);
            try {
                this.getCurrentContextApplication();
                Assert.fail((String)"should not succeed");
            }
            catch (ProcessEngineException e) {
                this.testRule.assertTextPresent("A process application with name '" + nonExistingName + "' is not registered", e.getMessage());
            }
        }
        finally {
            ProcessApplicationContext.clear();
        }
    }

    @Test
    public void testCannotExecuteInUnregisteredPaContext() throws Exception {
        String nonExistingName = this.pa.getName() + this.pa.getName();
        try {
            ProcessApplicationContext.withProcessApplicationContext((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ProcessApplicationContextTest.this.getCurrentContextApplication();
                    return null;
                }
            }, (String)nonExistingName);
            Assert.fail((String)"should not succeed");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("A process application with name '" + nonExistingName + "' is not registered", e.getMessage());
        }
    }

    @Test
    public void testExecuteWithInvocationContext() throws Exception {
        TestApplicationWithoutEngine processApplication = (TestApplicationWithoutEngine)((Object)Mockito.spy((Object)((Object)this.pa)));
        ProcessApplicationReference processApplicationReference = (ProcessApplicationReference)Mockito.mock(ProcessApplicationReference.class);
        Mockito.when((Object)processApplicationReference.getProcessApplication()).thenReturn((Object)processApplication);
        InvocationContext invocationContext = new InvocationContext((BaseDelegateExecution)Mockito.mock(BaseDelegateExecution.class));
        Context.executeWithinProcessApplication((Callable)((Callable)Mockito.mock(Callable.class)), (ProcessApplicationReference)processApplicationReference, (InvocationContext)invocationContext);
        ((TestApplicationWithoutEngine)((Object)Mockito.verify((Object)((Object)processApplication)))).execute((Callable)Mockito.any(Callable.class), (InvocationContext)Mockito.eq((Object)invocationContext));
        ((TestApplicationWithoutEngine)((Object)Mockito.verify((Object)((Object)processApplication)))).execute((Callable)Mockito.any(Callable.class));
    }

    protected ProcessApplicationReference getCurrentContextApplication() {
        ProcessEngineConfigurationImpl engineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        return (ProcessApplicationReference)engineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<ProcessApplicationReference>(){

            public ProcessApplicationReference execute(CommandContext commandContext) {
                return Context.getCurrentProcessApplication();
            }
        });
    }
}

