/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.application.impl.deployment;

import java.util.Arrays;
import java.util.Collection;
import org.eximeebpms.bpm.application.ProcessApplicationReference;
import org.eximeebpms.bpm.application.impl.EmbeddedProcessApplication;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.impl.application.ProcessApplicationManager;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.eximeebpms.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.repository.ResourceDefinitionEntity;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.repository.DecisionDefinition;
import org.eximeebpms.bpm.engine.repository.DecisionRequirementsDefinition;
import org.eximeebpms.bpm.engine.repository.Deployment;
import org.eximeebpms.bpm.engine.repository.ProcessApplicationDeployment;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RedeploymentRegistrationTest {
    protected static final String DEPLOYMENT_NAME = "my-deployment";
    protected static final String BPMN_RESOURCE_1 = "org/eximeebpms/bpm/engine/test/api/repository/processOne.bpmn20.xml";
    protected static final String BPMN_RESOURCE_2 = "org/eximeebpms/bpm/engine/test/api/repository/processTwo.bpmn20.xml";
    protected static final String CMMN_RESOURCE_1 = "org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    protected static final String CMMN_RESOURCE_2 = "org/eximeebpms/bpm/engine/test/api/cmmn/twoTaskCase.cmmn";
    protected static final String DMN_RESOURCE_1 = "org/eximeebpms/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDmnDeployment.dmn11.xml";
    protected static final String DMN_RESOURCE_2 = "org/eximeebpms/bpm/engine/test/dmn/deployment/dmnScore.dmn11.xml";
    protected static final String DRD_RESOURCE_1 = "org/eximeebpms/bpm/engine/test/dmn/deployment/drdScore.dmn11.xml";
    protected static final String DRD_RESOURCE_2 = "org/eximeebpms/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected EmbeddedProcessApplication processApplication;
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RepositoryService repositoryService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    @Parameterized.Parameter(value=0)
    public String resource1;
    @Parameterized.Parameter(value=1)
    public String resource2;
    @Parameterized.Parameter(value=2)
    public String definitionKey1;
    @Parameterized.Parameter(value=3)
    public String definitionKey2;
    @Parameterized.Parameter(value=4)
    public TestProvider testProvider;

    @Parameterized.Parameters(name="scenario {index}")
    public static Collection<Object[]> scenarios() {
        return Arrays.asList({BPMN_RESOURCE_1, BPMN_RESOURCE_2, "processOne", "processTwo", RedeploymentRegistrationTest.processDefinitionTestProvider()}, {CMMN_RESOURCE_1, CMMN_RESOURCE_2, "oneTaskCase", "twoTaskCase", RedeploymentRegistrationTest.caseDefinitionTestProvider()}, {DMN_RESOURCE_1, DMN_RESOURCE_2, "decision", "score-decision", RedeploymentRegistrationTest.decisionDefinitionTestProvider()}, {DRD_RESOURCE_1, DRD_RESOURCE_2, "score", "dish", RedeploymentRegistrationTest.decisionRequirementsDefinitionTestProvider()});
    }

    @Before
    public void init() throws Exception {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.processApplication = new EmbeddedProcessApplication();
    }

    @Test
    public void registrationNotFoundByDeploymentId() {
        ProcessApplicationReference reference = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        Assert.assertEquals((Object)reference, (Object)this.getProcessApplicationForDeployment(deployment1.getId()));
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        Assert.assertNull((Object)this.getProcessApplicationForDeployment(deployment2.getId()));
    }

    @Test
    public void registrationNotFoundByDefinition() {
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String definitionId = this.getLatestDefinitionIdByKey(this.definitionKey1);
        Assert.assertNull((Object)this.getProcessApplicationForDefinition(definitionId));
    }

    @Test
    public void registrationFoundByDeploymentId() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        Assert.assertEquals((Object)reference1, (Object)this.getProcessApplicationForDeployment(deployment1.getId()));
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        Assert.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDeployment(deployment2.getId()));
    }

    @Test
    public void registrationFoundFromPreviousDefinition() {
        ProcessApplicationReference reference = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String definitionId = this.getLatestDefinitionIdByKey(this.definitionKey1);
        Assert.assertEquals((Object)reference, (Object)this.getProcessApplicationForDefinition(definitionId));
        Assert.assertNull((Object)this.getProcessApplicationForDeployment(deployment2.getId()));
    }

    @Test
    public void registrationFoundFromLatestDeployment() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String definitionId = this.getLatestDefinitionIdByKey(this.definitionKey1);
        Assert.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDefinition(definitionId));
        Assert.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDeployment(deployment2.getId()));
    }

    @Test
    public void registrationFoundOnlyForOneProcessDefinition() {
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).addClasspathResource(this.resource2).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.getLatestDefinitionIdByKey(this.definitionKey1);
        String secondDefinitionId = this.getLatestDefinitionIdByKey(this.definitionKey2);
        Assert.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDefinition(firstDefinitionId));
        Assert.assertNull((Object)this.getProcessApplicationForDefinition(secondDefinitionId));
    }

    @Test
    public void registrationFoundFromDifferentDeployment() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).addClasspathResource(this.resource2).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.getLatestDefinitionIdByKey(this.definitionKey1);
        String secondDefinitionId = this.getLatestDefinitionIdByKey(this.definitionKey2);
        Assert.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDefinition(firstDefinitionId));
        Assert.assertEquals((Object)reference1, (Object)this.getProcessApplicationForDefinition(secondDefinitionId));
    }

    @Test
    public void registrationFoundFromSameDeployment() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).addClasspathResource(this.resource2).deploy();
        this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(this.resource2).deploy();
        this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.getLatestDefinitionIdByKey(this.definitionKey1);
        String secondDefinitionId = this.getLatestDefinitionIdByKey(this.definitionKey1);
        Assert.assertEquals((Object)reference1, (Object)this.getProcessApplicationForDefinition(firstDefinitionId));
        Assert.assertEquals((Object)reference1, (Object)this.getProcessApplicationForDefinition(secondDefinitionId));
    }

    @Test
    public void registrationFoundFromDifferentDeployments() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name("my-deployment-1").addClasspathResource(this.resource1).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        this.repositoryService.createDeployment(reference2).name("my-deployment-2").addClasspathResource(this.resource2).deploy();
        this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.getLatestDefinitionIdByKey(this.definitionKey1);
        String secondDefinitionId = this.getLatestDefinitionIdByKey(this.definitionKey2);
        Assert.assertEquals((Object)reference1, (Object)this.getProcessApplicationForDefinition(firstDefinitionId));
        Assert.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDefinition(secondDefinitionId));
    }

    @Test
    public void registrationNotFoundWhenDeletingDeployment() {
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.getLatestDefinitionIdByKey(this.definitionKey1);
        Assert.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDefinition(firstDefinitionId));
        this.deleteDeployment((Deployment)deployment2);
        Assert.assertNull((Object)this.getProcessApplicationForDefinition(firstDefinitionId));
    }

    @Test
    public void registrationFoundAfterDiscardingDeploymentCache() {
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.getLatestDefinitionIdByKey(this.definitionKey1);
        Assert.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDefinition(firstDefinitionId));
        this.discardDefinitionCache();
        Assert.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDefinition(firstDefinitionId));
    }

    @After
    public void cleanUp() {
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.deleteDeployment(deployment);
        }
    }

    protected void deleteDeployment(Deployment deployment) {
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        this.engineRule.getManagementService().unregisterProcessApplication(deployment.getId(), false);
    }

    protected ProcessApplicationReference getProcessApplicationForDeployment(String deploymentId) {
        ProcessApplicationManager processApplicationManager = this.processEngineConfiguration.getProcessApplicationManager();
        return processApplicationManager.getProcessApplicationForDeployment(deploymentId);
    }

    protected void discardDefinitionCache() {
        this.processEngineConfiguration.getDeploymentCache().discardProcessDefinitionCache();
        this.processEngineConfiguration.getDeploymentCache().discardCaseDefinitionCache();
        this.processEngineConfiguration.getDeploymentCache().discardDecisionDefinitionCache();
        this.processEngineConfiguration.getDeploymentCache().discardDecisionRequirementsDefinitionCache();
    }

    protected String getLatestDefinitionIdByKey(String key) {
        return this.testProvider.getLatestDefinitionIdByKey(this.repositoryService, key);
    }

    protected ProcessApplicationReference getProcessApplicationForDefinition(String definitionId) {
        return (ProcessApplicationReference)this.processEngineConfiguration.getCommandExecutorTxRequired().execute(this.testProvider.createGetProcessApplicationCommand(definitionId));
    }

    protected static TestProvider processDefinitionTestProvider() {
        return new TestProvider(){

            @Override
            public Command<ProcessApplicationReference> createGetProcessApplicationCommand(final String definitionId) {
                return new Command<ProcessApplicationReference>(){

                    public ProcessApplicationReference execute(CommandContext commandContext) {
                        ProcessEngineConfigurationImpl configuration = commandContext.getProcessEngineConfiguration();
                        DeploymentCache deploymentCache = configuration.getDeploymentCache();
                        ProcessDefinitionEntity definition = deploymentCache.findDeployedProcessDefinitionById(definitionId);
                        return ProcessApplicationContextUtil.getTargetProcessApplication((ResourceDefinitionEntity)definition);
                    }
                };
            }

            @Override
            public String getLatestDefinitionIdByKey(RepositoryService repositoryService, String key) {
                return ((ProcessDefinition)repositoryService.createProcessDefinitionQuery().processDefinitionKey(key).latestVersion().singleResult()).getId();
            }
        };
    }

    protected static TestProvider caseDefinitionTestProvider() {
        return new TestProvider(){

            @Override
            public Command<ProcessApplicationReference> createGetProcessApplicationCommand(final String definitionId) {
                return new Command<ProcessApplicationReference>(){

                    public ProcessApplicationReference execute(CommandContext commandContext) {
                        ProcessEngineConfigurationImpl configuration = commandContext.getProcessEngineConfiguration();
                        DeploymentCache deploymentCache = configuration.getDeploymentCache();
                        CaseDefinitionEntity definition = deploymentCache.findDeployedCaseDefinitionById(definitionId);
                        return ProcessApplicationContextUtil.getTargetProcessApplication((ResourceDefinitionEntity)definition);
                    }
                };
            }

            @Override
            public String getLatestDefinitionIdByKey(RepositoryService repositoryService, String key) {
                return ((CaseDefinition)repositoryService.createCaseDefinitionQuery().caseDefinitionKey(key).latestVersion().singleResult()).getId();
            }
        };
    }

    protected static TestProvider decisionDefinitionTestProvider() {
        return new TestProvider(){

            @Override
            public Command<ProcessApplicationReference> createGetProcessApplicationCommand(final String definitionId) {
                return new Command<ProcessApplicationReference>(){

                    public ProcessApplicationReference execute(CommandContext commandContext) {
                        ProcessEngineConfigurationImpl configuration = commandContext.getProcessEngineConfiguration();
                        DeploymentCache deploymentCache = configuration.getDeploymentCache();
                        DecisionDefinitionEntity definition = deploymentCache.findDeployedDecisionDefinitionById(definitionId);
                        return ProcessApplicationContextUtil.getTargetProcessApplication((ResourceDefinitionEntity)definition);
                    }
                };
            }

            @Override
            public String getLatestDefinitionIdByKey(RepositoryService repositoryService, String key) {
                return ((DecisionDefinition)repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(key).latestVersion().singleResult()).getId();
            }
        };
    }

    protected static TestProvider decisionRequirementsDefinitionTestProvider() {
        return new TestProvider(){

            @Override
            public Command<ProcessApplicationReference> createGetProcessApplicationCommand(final String definitionId) {
                return new Command<ProcessApplicationReference>(){

                    public ProcessApplicationReference execute(CommandContext commandContext) {
                        ProcessEngineConfigurationImpl configuration = commandContext.getProcessEngineConfiguration();
                        DeploymentCache deploymentCache = configuration.getDeploymentCache();
                        DecisionRequirementsDefinitionEntity definition = deploymentCache.findDeployedDecisionRequirementsDefinitionById(definitionId);
                        return ProcessApplicationContextUtil.getTargetProcessApplication((ResourceDefinitionEntity)definition);
                    }
                };
            }

            @Override
            public String getLatestDefinitionIdByKey(RepositoryService repositoryService, String key) {
                return ((DecisionRequirementsDefinition)repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(key).latestVersion().singleResult()).getId();
            }
        };
    }

    private static interface TestProvider {
        public Command<ProcessApplicationReference> createGetProcessApplicationCommand(String var1);

        public String getLatestDefinitionIdByKey(RepositoryService var1, String var2);
    }
}

