/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.container.impl.deployment.jobexecutor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eximeebpms.bpm.container.RuntimeContainerDelegate;
import org.eximeebpms.bpm.container.impl.RuntimeContainerDelegateImpl;
import org.eximeebpms.bpm.container.impl.deployment.PlatformXmlStartProcessEnginesStep;
import org.eximeebpms.bpm.container.impl.deployment.StopProcessEnginesStep;
import org.eximeebpms.bpm.container.impl.deployment.jobexecutor.StartJobExecutorStep;
import org.eximeebpms.bpm.container.impl.deployment.jobexecutor.StartManagedThreadPoolStep;
import org.eximeebpms.bpm.container.impl.deployment.jobexecutor.StopJobExecutorStep;
import org.eximeebpms.bpm.container.impl.deployment.jobexecutor.StopManagedThreadPoolStep;
import org.eximeebpms.bpm.container.impl.metadata.BpmPlatformXmlImpl;
import org.eximeebpms.bpm.container.impl.metadata.JobAcquisitionXmlImpl;
import org.eximeebpms.bpm.container.impl.metadata.JobExecutorXmlImpl;
import org.eximeebpms.bpm.container.impl.metadata.ProcessEngineXmlImpl;
import org.eximeebpms.bpm.container.impl.metadata.spi.JobExecutorXml;
import org.eximeebpms.bpm.container.impl.spi.DeploymentOperationStep;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class PlatformJobExecutorActivateTest {
    private static final String ENGINE_NAME = "PlatformJobExecutorActivateTest-engine";
    private static final String ACQUISITION_NAME = "PlatformJobExecutorActivateTest-acquisition";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAutoActivateIfNoPropertySet() {
        JobExecutorXmlImpl jobExecutorXml = this.defineJobExecutor();
        ProcessEngineXmlImpl processEngineXml = this.defineProcessEngine();
        BpmPlatformXmlImpl bpmPlatformXml = new BpmPlatformXmlImpl((JobExecutorXml)jobExecutorXml, Collections.singletonList(processEngineXml));
        this.deployPlatform(bpmPlatformXml);
        try {
            ProcessEngine processEngine = this.getProcessEngine(ENGINE_NAME);
            ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration();
            Assert.assertEquals((Object)true, (Object)processEngineConfiguration.getJobExecutor().isActive());
        }
        finally {
            this.undeployPlatform();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotAutoActivateIfConfigured() {
        JobExecutorXmlImpl jobExecutorXml = this.defineJobExecutor();
        ProcessEngineXmlImpl processEngineXml = this.defineProcessEngine();
        processEngineXml.getProperties().put("jobExecutorActivate", "false");
        BpmPlatformXmlImpl bpmPlatformXml = new BpmPlatformXmlImpl((JobExecutorXml)jobExecutorXml, Collections.singletonList(processEngineXml));
        this.deployPlatform(bpmPlatformXml);
        try {
            ProcessEngine processEngine = this.getProcessEngine(ENGINE_NAME);
            ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration();
            Assert.assertEquals((Object)false, (Object)processEngineConfiguration.getJobExecutor().isActive());
        }
        finally {
            this.undeployPlatform();
        }
    }

    protected ProcessEngine getProcessEngine(String engineName) {
        RuntimeContainerDelegateImpl containerDelegate = (RuntimeContainerDelegateImpl)RuntimeContainerDelegate.INSTANCE.get();
        return containerDelegate.getProcessEngine(engineName);
    }

    private ProcessEngineXmlImpl defineProcessEngine() {
        ProcessEngineXmlImpl processEngineXml = new ProcessEngineXmlImpl();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("jdbcUrl", "jdbc:h2:mem:PlatformJobExecutorActivateTest-db");
        processEngineXml.setProperties(properties);
        processEngineXml.setPlugins(new ArrayList());
        processEngineXml.setName(ENGINE_NAME);
        processEngineXml.setJobAcquisitionName(ACQUISITION_NAME);
        processEngineXml.setConfigurationClass(StandaloneInMemProcessEngineConfiguration.class.getName());
        processEngineXml.setDefault(true);
        return processEngineXml;
    }

    private JobExecutorXmlImpl defineJobExecutor() {
        JobAcquisitionXmlImpl jobAcquisition = new JobAcquisitionXmlImpl();
        jobAcquisition.setProperties(new HashMap());
        jobAcquisition.setName(ACQUISITION_NAME);
        JobExecutorXmlImpl jobExecutorXml = new JobExecutorXmlImpl();
        jobExecutorXml.setProperties(new HashMap());
        jobExecutorXml.setJobAcquisitions(Collections.singletonList(jobAcquisition));
        return jobExecutorXml;
    }

    private void undeployPlatform() {
        RuntimeContainerDelegateImpl containerDelegate = (RuntimeContainerDelegateImpl)RuntimeContainerDelegate.INSTANCE.get();
        containerDelegate.getServiceContainer().createUndeploymentOperation("deploy BPM platform").addStep((DeploymentOperationStep)new StopJobExecutorStep()).addStep((DeploymentOperationStep)new StopProcessEnginesStep()).addStep((DeploymentOperationStep)new StopManagedThreadPoolStep()).execute();
    }

    private void deployPlatform(BpmPlatformXmlImpl bpmPlatformXml) {
        RuntimeContainerDelegateImpl containerDelegate = (RuntimeContainerDelegateImpl)RuntimeContainerDelegate.INSTANCE.get();
        containerDelegate.getServiceContainer().createDeploymentOperation("deploy BPM platform").addAttachment("bpmPlatformXml", (Object)bpmPlatformXml).addStep((DeploymentOperationStep)new StartManagedThreadPoolStep()).addStep((DeploymentOperationStep)new StartJobExecutorStep()).addStep((DeploymentOperationStep)new PlatformXmlStartProcessEnginesStep()).execute();
    }
}

