/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.container.impl.jmx.kernel;

import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eximeebpms.bpm.container.impl.jmx.MBeanServiceContainer;
import org.eximeebpms.bpm.container.impl.jmx.kernel.util.FailingDeploymentOperationStep;
import org.eximeebpms.bpm.container.impl.jmx.kernel.util.StartServiceDeploymentOperationStep;
import org.eximeebpms.bpm.container.impl.jmx.kernel.util.StopServiceDeploymentOperationStep;
import org.eximeebpms.bpm.container.impl.jmx.kernel.util.TestService;
import org.eximeebpms.bpm.container.impl.jmx.kernel.util.TestServiceType;
import org.eximeebpms.bpm.container.impl.spi.DeploymentOperationStep;
import org.eximeebpms.bpm.container.impl.spi.PlatformService;
import org.eximeebpms.bpm.container.impl.spi.PlatformServiceContainer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MBeanServiceContainerTest {
    private MBeanServiceContainer serviceContainer;
    private String service1Name = TestServiceType.TYPE1.getTypeName() + ":type=service1";
    private String service2Name = TestServiceType.TYPE1.getTypeName() + ":type=service2";
    private String service3Name = TestServiceType.TYPE2.getTypeName() + ":type=service3";
    private String service4Name = TestServiceType.TYPE2.getTypeName() + ":type=service4";
    private ObjectName service1ObjectName = MBeanServiceContainer.getObjectName((String)this.service1Name);
    private ObjectName service2ObjectName = MBeanServiceContainer.getObjectName((String)this.service2Name);
    private ObjectName service3ObjectName = MBeanServiceContainer.getObjectName((String)this.service3Name);
    private ObjectName service4ObjectName = MBeanServiceContainer.getObjectName((String)this.service4Name);
    private TestService service1 = new TestService();
    private TestService service2 = new TestService();
    private TestService service3 = new TestService();
    private TestService service4 = new TestService();

    @Before
    public void setUp() throws Exception {
        this.serviceContainer = new MBeanServiceContainer();
    }

    @After
    public void tearDown() throws Exception {
        MBeanServer mBeanServer = this.serviceContainer.getmBeanServer();
        if (mBeanServer.isRegistered(this.service1ObjectName)) {
            mBeanServer.unregisterMBean(this.service1ObjectName);
        }
        if (mBeanServer.isRegistered(this.service2ObjectName)) {
            mBeanServer.unregisterMBean(this.service2ObjectName);
        }
        if (mBeanServer.isRegistered(this.service3ObjectName)) {
            mBeanServer.unregisterMBean(this.service3ObjectName);
        }
        if (mBeanServer.isRegistered(this.service4ObjectName)) {
            mBeanServer.unregisterMBean(this.service4ObjectName);
        }
    }

    @Test
    public void testStartService() {
        Assert.assertNull((Object)this.serviceContainer.getService(this.service1ObjectName));
        this.serviceContainer.startService(this.service1Name, (PlatformService)this.service1);
        Assert.assertNotNull((Object)this.serviceContainer.getService(this.service1ObjectName));
        Assert.assertEquals((Object)this.service1, (Object)this.serviceContainer.getService(this.service1ObjectName));
        try {
            this.serviceContainer.startService(this.service1Name, (PlatformService)this.service1);
            Assert.fail((String)"exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("service with same name already registered"));
        }
        this.serviceContainer.startService(this.service2Name, (PlatformService)this.service2);
        Assert.assertNotNull((Object)this.serviceContainer.getService(this.service2ObjectName));
    }

    @Test
    public void testStopService() {
        this.serviceContainer.startService(this.service1Name, (PlatformService)this.service1);
        Assert.assertNotNull((Object)this.serviceContainer.getService(this.service1ObjectName));
        this.serviceContainer.stopService(this.service1Name);
        Assert.assertNull((Object)this.serviceContainer.getService(this.service1ObjectName));
        try {
            this.serviceContainer.stopService(this.service1Name);
            Assert.fail((String)"exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("no such service registered"));
        }
    }

    @Test
    public void testGetServicesByType() {
        this.serviceContainer.startService(this.service1Name, (PlatformService)this.service1);
        this.serviceContainer.startService(this.service2Name, (PlatformService)this.service2);
        List servicesByType1 = this.serviceContainer.getServicesByType((PlatformServiceContainer.ServiceType)TestServiceType.TYPE1);
        Assert.assertEquals((long)2L, (long)servicesByType1.size());
        List servicesByType2 = this.serviceContainer.getServicesByType((PlatformServiceContainer.ServiceType)TestServiceType.TYPE2);
        Assert.assertEquals((long)0L, (long)servicesByType2.size());
        this.serviceContainer.startService(this.service3Name, (PlatformService)this.service3);
        this.serviceContainer.startService(this.service4Name, (PlatformService)this.service4);
        servicesByType1 = this.serviceContainer.getServicesByType((PlatformServiceContainer.ServiceType)TestServiceType.TYPE1);
        Assert.assertEquals((long)2L, (long)servicesByType1.size());
        servicesByType2 = this.serviceContainer.getServicesByType((PlatformServiceContainer.ServiceType)TestServiceType.TYPE2);
        Assert.assertEquals((long)2L, (long)servicesByType2.size());
    }

    @Test
    public void testGetServiceValuesByType() {
        this.serviceContainer.startService(this.service1Name, (PlatformService)this.service1);
        this.serviceContainer.startService(this.service2Name, (PlatformService)this.service2);
        List servicesByType1 = this.serviceContainer.getServiceValuesByType((PlatformServiceContainer.ServiceType)TestServiceType.TYPE1);
        Assert.assertEquals((long)2L, (long)servicesByType1.size());
        Assert.assertTrue((boolean)servicesByType1.contains(this.service1));
        Assert.assertTrue((boolean)servicesByType1.contains(this.service2));
        List servicesByType2 = this.serviceContainer.getServicesByType((PlatformServiceContainer.ServiceType)TestServiceType.TYPE2);
        Assert.assertEquals((long)0L, (long)servicesByType2.size());
        this.serviceContainer.startService(this.service3Name, (PlatformService)this.service3);
        this.serviceContainer.startService(this.service4Name, (PlatformService)this.service4);
        servicesByType1 = this.serviceContainer.getServicesByType((PlatformServiceContainer.ServiceType)TestServiceType.TYPE1);
        Assert.assertEquals((long)2L, (long)servicesByType1.size());
        servicesByType2 = this.serviceContainer.getServicesByType((PlatformServiceContainer.ServiceType)TestServiceType.TYPE2);
        Assert.assertEquals((long)2L, (long)servicesByType2.size());
        Assert.assertTrue((boolean)servicesByType2.contains(this.service3));
        Assert.assertTrue((boolean)servicesByType2.contains(this.service4));
    }

    @Test
    public void testGetServiceNames() {
        this.serviceContainer.startService(this.service1Name, (PlatformService)this.service1);
        this.serviceContainer.startService(this.service2Name, (PlatformService)this.service2);
        Set serviceNames = this.serviceContainer.getServiceNames((PlatformServiceContainer.ServiceType)TestServiceType.TYPE1);
        Assert.assertEquals((long)2L, (long)serviceNames.size());
        Assert.assertTrue((boolean)serviceNames.contains(this.service1Name));
        Assert.assertTrue((boolean)serviceNames.contains(this.service2Name));
        serviceNames = this.serviceContainer.getServiceNames((PlatformServiceContainer.ServiceType)TestServiceType.TYPE2);
        Assert.assertEquals((long)0L, (long)serviceNames.size());
        this.serviceContainer.startService(this.service3Name, (PlatformService)this.service3);
        this.serviceContainer.startService(this.service4Name, (PlatformService)this.service4);
        serviceNames = this.serviceContainer.getServiceNames((PlatformServiceContainer.ServiceType)TestServiceType.TYPE1);
        Assert.assertEquals((long)2L, (long)serviceNames.size());
        Assert.assertTrue((boolean)serviceNames.contains(this.service1Name));
        Assert.assertTrue((boolean)serviceNames.contains(this.service2Name));
        serviceNames = this.serviceContainer.getServiceNames((PlatformServiceContainer.ServiceType)TestServiceType.TYPE2);
        Assert.assertEquals((long)2L, (long)serviceNames.size());
        Assert.assertTrue((boolean)serviceNames.contains(this.service3Name));
        Assert.assertTrue((boolean)serviceNames.contains(this.service4Name));
    }

    @Test
    public void testDeploymentOperation() {
        this.serviceContainer.createDeploymentOperation("test op").addStep((DeploymentOperationStep)new StartServiceDeploymentOperationStep(this.service1Name, this.service1)).addStep((DeploymentOperationStep)new StartServiceDeploymentOperationStep(this.service2Name, this.service2)).execute();
        Assert.assertEquals((Object)this.service1, (Object)this.serviceContainer.getService(this.service1ObjectName));
        Assert.assertEquals((Object)this.service2, (Object)this.serviceContainer.getService(this.service2ObjectName));
    }

    @Test
    public void testFailingDeploymentOperation() {
        try {
            this.serviceContainer.createDeploymentOperation("test failing op").addStep((DeploymentOperationStep)new StartServiceDeploymentOperationStep(this.service1Name, this.service1)).addStep((DeploymentOperationStep)new FailingDeploymentOperationStep()).addStep((DeploymentOperationStep)new StartServiceDeploymentOperationStep(this.service2Name, this.service2)).execute();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Exception while performing 'test failing op' => 'failing step'"));
        }
        Assert.assertNull((Object)this.serviceContainer.getService(this.service1ObjectName));
        Assert.assertNull((Object)this.serviceContainer.getService(this.service2ObjectName));
        try {
            this.serviceContainer.createDeploymentOperation("test failing op").addStep((DeploymentOperationStep)new StartServiceDeploymentOperationStep(this.service1Name, this.service1)).addStep((DeploymentOperationStep)new StartServiceDeploymentOperationStep(this.service2Name, this.service2)).addStep((DeploymentOperationStep)new FailingDeploymentOperationStep()).execute();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Exception while performing 'test failing op' => 'failing step'"));
        }
        Assert.assertNull((Object)this.serviceContainer.getService(this.service1ObjectName));
        Assert.assertNull((Object)this.serviceContainer.getService(this.service2ObjectName));
    }

    @Test
    public void testUndeploymentOperation() {
        this.serviceContainer.startService(this.service1Name, (PlatformService)this.service1);
        this.serviceContainer.startService(this.service2Name, (PlatformService)this.service2);
        this.serviceContainer.createUndeploymentOperation("test op").addStep((DeploymentOperationStep)new StopServiceDeploymentOperationStep(this.service1Name)).addStep((DeploymentOperationStep)new StopServiceDeploymentOperationStep(this.service2Name)).execute();
        Assert.assertNull((Object)this.serviceContainer.getService(this.service1ObjectName));
        Assert.assertNull((Object)this.serviceContainer.getService(this.service2ObjectName));
    }

    @Test
    public void testFailingUndeploymentOperation() {
        this.serviceContainer.startService(this.service1Name, (PlatformService)this.service1);
        this.serviceContainer.startService(this.service2Name, (PlatformService)this.service2);
        this.serviceContainer.createUndeploymentOperation("test failing op").addStep((DeploymentOperationStep)new StopServiceDeploymentOperationStep(this.service1Name)).addStep((DeploymentOperationStep)new FailingDeploymentOperationStep()).addStep((DeploymentOperationStep)new StopServiceDeploymentOperationStep(this.service2Name)).execute();
        Assert.assertNull((Object)this.serviceContainer.getService(this.service1ObjectName));
        Assert.assertNull((Object)this.serviceContainer.getService(this.service2ObjectName));
        this.serviceContainer.startService(this.service1Name, (PlatformService)this.service1);
        this.serviceContainer.startService(this.service2Name, (PlatformService)this.service2);
        this.serviceContainer.createUndeploymentOperation("test failing op").addStep((DeploymentOperationStep)new FailingDeploymentOperationStep()).addStep((DeploymentOperationStep)new StopServiceDeploymentOperationStep(this.service1Name)).addStep((DeploymentOperationStep)new StopServiceDeploymentOperationStep(this.service2Name)).execute();
        Assert.assertNull((Object)this.serviceContainer.getService(this.service1ObjectName));
        Assert.assertNull((Object)this.serviceContainer.getService(this.service2ObjectName));
    }
}

