/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.jobexecutor.historycleanup;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;
import org.eximeebpms.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobHandlerConfiguration;
import org.eximeebpms.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupSchedulerCmd;
import org.eximeebpms.bpm.engine.impl.metrics.reporter.DbMetricsReporter;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

public class HistoryCleanupSchedulerCmdTest {
    @Mock
    private CommandContext commandContext;
    @Mock
    private JobEntity jobEntity;
    @Mock
    private DbMetricsReporter dbMetricsReporter;
    @Mock
    private JobManager jobManager;
    @Spy
    private ProcessEngineConfigurationImpl engineConfigurationSpy;
    @Mock
    private MockedStatic<HistoryCleanupHelper> mockedHistoryCleanupHelper;
    private HistoryCleanupSchedulerCmd historyCleanupSchedulerCmd;
    private Map<String, Long> reports;
    private HistoryCleanupJobHandlerConfiguration configuration;
    private final String jobId = "testJobId";
    String METRICS_KEY = "Key";
    Long METRICS_VALUE = 123L;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.commandContext.getProcessEngineConfiguration()).thenReturn((Object)this.engineConfigurationSpy);
        Mockito.when((Object)this.commandContext.getJobManager()).thenReturn((Object)this.jobManager);
        Mockito.when((Object)this.jobManager.findJobById("testJobId")).thenReturn((Object)this.jobEntity);
        Mockito.when((Object)this.engineConfigurationSpy.getDbMetricsReporter()).thenReturn((Object)this.dbMetricsReporter);
        this.reports = new HashMap<String, Long>();
        this.reports.put(this.METRICS_KEY, this.METRICS_VALUE);
        this.configuration = new HistoryCleanupJobHandlerConfiguration();
        this.mockedHistoryCleanupHelper = Mockito.mockStatic(HistoryCleanupHelper.class);
        this.mockedHistoryCleanupHelper.when(() -> HistoryCleanupHelper.isWithinBatchWindow((Date)((Date)Mockito.any(Date.class)), (ProcessEngineConfigurationImpl)((ProcessEngineConfigurationImpl)Mockito.any(ProcessEngineConfigurationImpl.class)))).thenReturn((Object)false);
    }

    @After
    public void tearDown() {
        this.mockedHistoryCleanupHelper.close();
    }

    @Test
    public void shouldReportMetricsIfEnabled() {
        this.engineConfigurationSpy.setMetricsEnabled(true);
        this.engineConfigurationSpy.setHistoryCleanupMetricsEnabled(true);
        this.historyCleanupSchedulerCmd = new HistoryCleanupSchedulerCmd(false, this.reports, this.configuration, "testJobId");
        this.historyCleanupSchedulerCmd.execute(this.commandContext);
        ((DbMetricsReporter)Mockito.verify((Object)this.dbMetricsReporter, (VerificationMode)Mockito.times((int)this.reports.size()))).reportValueAtOnce(this.METRICS_KEY, this.METRICS_VALUE.longValue());
    }

    @Test
    public void shouldNotReportMetricsIfMetricsDisabled() {
        this.engineConfigurationSpy.setMetricsEnabled(false);
        this.engineConfigurationSpy.setHistoryCleanupMetricsEnabled(true);
        this.historyCleanupSchedulerCmd = new HistoryCleanupSchedulerCmd(false, this.reports, this.configuration, "testJobId");
        this.historyCleanupSchedulerCmd.execute(this.commandContext);
        ((ProcessEngineConfigurationImpl)Mockito.verify((Object)this.engineConfigurationSpy)).isHistoryCleanupMetricsEnabled();
        ((DbMetricsReporter)Mockito.verify((Object)this.dbMetricsReporter, (VerificationMode)Mockito.never())).reportValueAtOnce(Mockito.anyString(), Mockito.anyLong());
    }

    @Test
    public void shouldNotReportMetricsIfHistoryCleanupMetricsDisabled() {
        this.engineConfigurationSpy.setMetricsEnabled(true);
        this.engineConfigurationSpy.setHistoryCleanupMetricsEnabled(false);
        this.historyCleanupSchedulerCmd = new HistoryCleanupSchedulerCmd(false, this.reports, this.configuration, "testJobId");
        this.historyCleanupSchedulerCmd.execute(this.commandContext);
        ((ProcessEngineConfigurationImpl)Mockito.verify((Object)this.engineConfigurationSpy)).isHistoryCleanupMetricsEnabled();
        ((DbMetricsReporter)Mockito.verify((Object)this.dbMetricsReporter, (VerificationMode)Mockito.never())).reportValueAtOnce(Mockito.anyString(), Mockito.anyLong());
    }
}

