/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.util;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.util.ImmutablePair;
import org.junit.Assert;
import org.junit.Test;

public class ImmutablePairTest {
    @Test
    public void shouldReturnBasicValues() throws Exception {
        ImmutablePair pair = new ImmutablePair((Object)0, (Object)"foo");
        Assert.assertEquals((long)0L, (long)((Integer)pair.getLeft()).intValue());
        Assert.assertEquals((Object)"foo", (Object)pair.getRight());
        ImmutablePair pair2 = new ImmutablePair(null, (Object)"bar");
        Assert.assertNull((Object)pair2.getLeft());
        Assert.assertEquals((Object)"bar", (Object)pair2.getRight());
    }

    @Test
    public void shouldBeCompatibleToMapEntry() throws Exception {
        ImmutablePair pair = new ImmutablePair((Object)0, (Object)"foo");
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, "foo");
        Map.Entry entry = map.entrySet().iterator().next();
        Assert.assertEquals((Object)pair, entry);
        Assert.assertEquals((long)pair.hashCode(), (long)entry.hashCode());
    }

    @Test
    public void shouldCompareWithLeftFirst() throws Exception {
        ImmutablePair pair1 = new ImmutablePair((Object)"A", (Object)"D");
        ImmutablePair pair2 = new ImmutablePair((Object)"B", (Object)"C");
        Assert.assertTrue((pair1.compareTo(pair1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair2.compareTo(pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair2.compareTo(pair1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldCompareWithRightSecond() throws Exception {
        ImmutablePair pair1 = new ImmutablePair((Object)"A", (Object)"C");
        ImmutablePair pair2 = new ImmutablePair((Object)"A", (Object)"D");
        Assert.assertTrue((pair1.compareTo(pair1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair2.compareTo(pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair2.compareTo(pair1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldFailWithNonComparableTypes() {
        ImmutablePair pair1 = new ImmutablePair(new Object(), new Object());
        ImmutablePair pair2 = new ImmutablePair(new Object(), new Object());
        try {
            pair1.compareTo(pair2);
            Assert.fail((String)"Pairs should not be comparable");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessageContaining("Please provide comparable elements");
        }
    }

    @Test
    public void shouldFulfillEqualityRules() throws Exception {
        Assert.assertEquals((Object)new ImmutablePair(null, (Object)"foo"), (Object)new ImmutablePair(null, (Object)"foo"));
        Assert.assertFalse((boolean)new ImmutablePair((Object)"foo", (Object)0).equals((Object)new ImmutablePair((Object)"foo", null)));
        Assert.assertFalse((boolean)new ImmutablePair((Object)"foo", (Object)"bar").equals((Object)new ImmutablePair((Object)"xyz", (Object)"bar")));
        ImmutablePair p = new ImmutablePair((Object)"foo", (Object)"bar");
        Assert.assertTrue((boolean)p.equals((Object)p));
        Assert.assertFalse((boolean)p.equals(new Object()));
    }

    @Test
    public void shouldHaveSameHashCodeAsEqualObject() throws Exception {
        Assert.assertEquals((long)new ImmutablePair(null, (Object)"foo").hashCode(), (long)new ImmutablePair(null, (Object)"foo").hashCode());
    }
}

