/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.AuthorizationService;
import org.eximeebpms.bpm.engine.authorization.Authorization;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.commons.testing.ProcessEngineLoggingRule;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class AuthorizationLoggingTest {
    protected static final String CONTEXT_LOGGER = "org.eximeebpms.bpm.engine.context";
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule);
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch(new String[]{"org.eximeebpms.bpm.engine.context"}).level(Level.DEBUG);

    @After
    public void tearDown() {
        this.engineRule.getProcessEngineConfiguration().setAuthorizationEnabled(false);
        AuthorizationService authorizationService = this.engineRule.getAuthorizationService();
        for (Authorization authorization : authorizationService.createAuthorizationQuery().list()) {
            authorizationService.deleteAuthorization(authorization.getId());
        }
    }

    @Test
    public void shouldLogOnDebugLevel() {
        AuthorizationScenario scenario = new AuthorizationScenario().withoutAuthorizations();
        this.authRule.init(scenario).withUser("userId").start();
        this.engineRule.getManagementService().getTelemetryData();
        String message = "ENGINE-03110 Required admin authenticated group or user or any of the following permissions:";
        List filteredLog = this.loggingRule.getFilteredLog(CONTEXT_LOGGER, message);
        Assertions.assertThat((int)filteredLog.size()).isEqualTo(1);
        Assertions.assertThat((Object)((ILoggingEvent)filteredLog.get(0)).getLevel()).isEqualTo((Object)Level.DEBUG);
    }
}

