/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.test.api.authorization.AuthorizationTest;
import org.eximeebpms.commons.testing.ProcessEngineLoggingRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class AuthorizationRevokeModeAlwaysTest
extends AuthorizationTest {
    protected static final String LOGGING_CONTEXT = "org.eximeebpms.bpm.engine.impl.persistence.entity.TaskEntity";
    protected String defaultRevokeMode;
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch("org.eximeebpms.bpm.engine.impl.persistence.entity.TaskEntity", Level.DEBUG);

    @Before
    public void storeRevokeMode() {
        this.defaultRevokeMode = this.processEngineConfiguration.getAuthorizationCheckRevokes();
    }

    @After
    public void resetRevokeMode() {
        this.processEngineConfiguration.setAuthorizationCheckRevokes(this.defaultRevokeMode);
    }

    @Test
    public void shouldCreateEqualQueriesForModesAlwaysAndAutoWhenRevokeExists() {
        this.disableAuthorization();
        this.testRule.deploy("org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.createRevokeAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.enableAuthorization();
        this.processEngineConfiguration.setAuthorizationCheckRevokes("always");
        int taskLogOffset = this.loggingRule.getLog(LOGGING_CONTEXT).size();
        this.taskService.createTaskQuery().list();
        List taskLog = this.loggingRule.getLog(LOGGING_CONTEXT);
        String modeAlwaysQuery = ((ILoggingEvent)taskLog.get(taskLogOffset)).getFormattedMessage();
        taskLogOffset = taskLog.size();
        this.processEngineConfiguration.setAuthorizationCheckRevokes("auto");
        this.taskService.createTaskQuery().list();
        String modeAutoQuery = ((ILoggingEvent)this.loggingRule.getLog(LOGGING_CONTEXT).get(taskLogOffset)).getFormattedMessage();
        Assertions.assertThat((String)modeAutoQuery).containsIgnoringCase((CharSequence)"Preparing: select").isEqualTo((Object)modeAlwaysQuery);
    }

    @Test
    public void shouldCreateUnequalQueriesForModesAlwaysAndAutoWhenNoRevokeExists() {
        this.disableAuthorization();
        this.testRule.deploy("org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.enableAuthorization();
        this.processEngineConfiguration.setAuthorizationCheckRevokes("always");
        int taskLogOffset = this.loggingRule.getLog(LOGGING_CONTEXT).size();
        this.taskService.createTaskQuery().list();
        List taskLog = this.loggingRule.getLog(LOGGING_CONTEXT);
        String modeAlwaysQuery = ((ILoggingEvent)taskLog.get(taskLogOffset)).getFormattedMessage();
        taskLogOffset = taskLog.size();
        this.processEngineConfiguration.setAuthorizationCheckRevokes("auto");
        this.taskService.createTaskQuery().list();
        String modeAutoQuery = ((ILoggingEvent)this.loggingRule.getLog(LOGGING_CONTEXT).get(taskLogOffset)).getFormattedMessage();
        Assertions.assertThat((String)modeAutoQuery).containsIgnoringCase((CharSequence)"Preparing: select").isNotEqualTo((Object)modeAlwaysQuery);
    }
}

