/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.authorization.Authorization;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.identity.Authentication;
import org.eximeebpms.bpm.engine.query.Query;
import org.eximeebpms.bpm.engine.repository.DecisionDefinition;
import org.eximeebpms.bpm.engine.repository.Deployment;
import org.eximeebpms.bpm.engine.repository.DeploymentBuilder;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Comment;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AuthorizationTest
extends PluggableProcessEngineTest {
    protected String userId = "test";
    protected String groupId = "accounting";
    protected User user;
    protected Group group;
    protected static final String VARIABLE_NAME = "aVariableName";
    protected static final String VARIABLE_VALUE = "aVariableValue";
    protected static final String TASK_ID = "myTask";
    protected List<String> deploymentIds = new ArrayList<String>();

    @Before
    public void setUp() throws Exception {
        this.user = this.createUser(this.userId);
        this.group = this.createGroup(this.groupId);
        this.identityService.createMembership(this.userId, this.groupId);
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.processEngineConfiguration.setAuthorizationEnabled(true);
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
        for (String deploymentId : this.deploymentIds) {
            this.deleteDeployment(deploymentId);
        }
    }

    protected <T> T runWithoutAuthorization(Callable<T> runnable) {
        boolean authorizationEnabled = this.processEngineConfiguration.isAuthorizationEnabled();
        try {
            this.disableAuthorization();
            T t = runnable.call();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (authorizationEnabled) {
                this.enableAuthorization();
            }
        }
    }

    protected String permissionException(Resource resource, Permission permission) {
        return "ENGINE-03110 Required admin authenticated group or user or any of the following permissions: '" + permission.getName() + "' permission on resource '" + resource.resourceName() + "'";
    }

    protected User createUser(String userId) {
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
        Authorization authorization = this.createGrantAuthorization((Resource)Resources.AUTHORIZATION, "*");
        authorization.setUserId(userId);
        authorization.addPermission((Permission)Permissions.ALL);
        this.saveAuthorization(authorization);
        authorization = this.createGrantAuthorization((Resource)Resources.USER, "*");
        authorization.setUserId(userId);
        authorization.addPermission((Permission)Permissions.ALL);
        this.saveAuthorization(authorization);
        return user;
    }

    protected Group createGroup(String groupId) {
        return this.runWithoutAuthorization(() -> {
            Group group = this.identityService.newGroup(groupId);
            this.identityService.saveGroup(group);
            return group;
        });
    }

    protected Authorization createGrantAuthorization(Resource resource, String resourceId, String userId, Permission ... permissions) {
        Authorization authorization = this.createGrantAuthorization(resource, resourceId);
        authorization.setUserId(userId);
        for (Permission permission : permissions) {
            authorization.addPermission(permission);
        }
        this.saveAuthorization(authorization);
        return authorization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Authorization createGrantAuthorizationWithoutAuthentication(Resource resource, String resourceId, String userId, Permission ... permissions) {
        Authentication currentAuthentication = this.identityService.getCurrentAuthentication();
        this.identityService.clearAuthentication();
        try {
            Authorization authorization = this.createGrantAuthorization(resource, resourceId, userId, permissions);
            return authorization;
        }
        finally {
            this.identityService.setAuthentication(currentAuthentication);
        }
    }

    protected void createGrantAuthorizationGroup(Resource resource, String resourceId, String groupId, Permission ... permissions) {
        Authorization authorization = this.createGrantAuthorization(resource, resourceId);
        authorization.setGroupId(groupId);
        for (Permission permission : permissions) {
            authorization.addPermission(permission);
        }
        this.saveAuthorization(authorization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createRevokeAuthorizationWithoutAuthentication(Resource resource, String resourceId, String userId, Permission ... permissions) {
        Authentication currentAuthentication = this.identityService.getCurrentAuthentication();
        this.identityService.clearAuthentication();
        try {
            this.createRevokeAuthorization(resource, resourceId, userId, permissions);
        }
        finally {
            this.identityService.setAuthentication(currentAuthentication);
        }
    }

    protected void createRevokeAuthorization(Resource resource, String resourceId, String userId, Permission ... permissions) {
        Authorization authorization = this.createRevokeAuthorization(resource, resourceId);
        authorization.setUserId(userId);
        for (Permission permission : permissions) {
            authorization.removePermission(permission);
        }
        this.saveAuthorization(authorization);
    }

    protected Authorization createGlobalAuthorization(Resource resource, String resourceId) {
        Authorization authorization = this.createAuthorization(0, resource, resourceId);
        return authorization;
    }

    protected Authorization createGrantAuthorization(Resource resource, String resourceId) {
        Authorization authorization = this.createAuthorization(1, resource, resourceId);
        return authorization;
    }

    protected Authorization createRevokeAuthorization(Resource resource, String resourceId) {
        Authorization authorization = this.createAuthorization(2, resource, resourceId);
        return authorization;
    }

    protected Authorization createAuthorization(int type, Resource resource, String resourceId) {
        Authorization authorization = this.authorizationService.createNewAuthorization(type);
        authorization.setResource(resource);
        if (resourceId != null) {
            authorization.setResourceId(resourceId);
        }
        return authorization;
    }

    protected void saveAuthorization(Authorization authorization) {
        this.authorizationService.saveAuthorization(authorization);
    }

    protected void enableAuthorization() {
        this.processEngineConfiguration.setAuthorizationEnabled(true);
    }

    protected void disableAuthorization() {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
    }

    protected ProcessInstance startProcessInstanceByKey(String key) {
        return this.startProcessInstanceByKey(key, null);
    }

    protected ProcessInstance startProcessInstanceByKey(String key, Map<String, Object> variables) {
        return this.runWithoutAuthorization(() -> this.runtimeService.startProcessInstanceByKey(key, variables));
    }

    public void executeAvailableJobs() {
        this.runWithoutAuthorization(() -> {
            this.testRule.executeAvailableJobs();
            return null;
        });
    }

    protected CaseInstance createCaseInstanceByKey(String key, Map<String, Object> variables) {
        return this.runWithoutAuthorization(() -> this.caseService.createCaseInstanceByKey(key, variables));
    }

    protected void createTask(String taskId) {
        this.runWithoutAuthorization(() -> {
            Task task = this.taskService.newTask(taskId);
            this.taskService.saveTask(task);
            return null;
        });
    }

    protected void deleteTask(String taskId, boolean cascade) {
        this.runWithoutAuthorization(() -> {
            this.taskService.deleteTask(taskId, cascade);
            return null;
        });
    }

    protected Comment createComment(String taskId, String processInstanceId, String message) {
        return this.runWithoutAuthorization(() -> this.taskService.createComment(taskId, processInstanceId, message));
    }

    protected void addCandidateUser(String taskId, String user) {
        this.runWithoutAuthorization(() -> {
            this.taskService.addCandidateUser(taskId, user);
            return null;
        });
    }

    protected void addCandidateGroup(String taskId, String group) {
        this.runWithoutAuthorization(() -> {
            this.taskService.addCandidateGroup(taskId, group);
            return null;
        });
    }

    protected void setAssignee(String taskId, String userId) {
        this.runWithoutAuthorization(() -> {
            this.taskService.setAssignee(taskId, userId);
            return null;
        });
    }

    protected void delegateTask(String taskId, String userId) {
        this.runWithoutAuthorization(() -> {
            this.taskService.delegateTask(taskId, userId);
            return null;
        });
    }

    protected Task selectSingleTask() {
        return this.runWithoutAuthorization(() -> (Task)this.taskService.createTaskQuery().singleResult());
    }

    protected void setTaskVariables(String taskId, Map<String, ? extends Object> variables) {
        this.runWithoutAuthorization(() -> {
            this.taskService.setVariables(taskId, variables);
            return null;
        });
    }

    protected void setTaskVariablesLocal(String taskId, Map<String, ? extends Object> variables) {
        this.runWithoutAuthorization(() -> {
            this.taskService.setVariablesLocal(taskId, variables);
            return null;
        });
    }

    protected void setTaskVariable(String taskId, String name, Object value) {
        this.runWithoutAuthorization(() -> {
            this.taskService.setVariable(taskId, name, value);
            return null;
        });
    }

    protected void setTaskVariableLocal(String taskId, String name, Object value) {
        this.runWithoutAuthorization(() -> {
            this.taskService.setVariableLocal(taskId, name, value);
            return null;
        });
    }

    protected void setExecutionVariable(String executionId, String name, Object value) {
        this.runWithoutAuthorization(() -> {
            this.runtimeService.setVariable(executionId, name, value);
            return null;
        });
    }

    protected void setExecutionVariableLocal(String executionId, String name, Object value) {
        this.runWithoutAuthorization(() -> {
            this.runtimeService.setVariableLocal(executionId, name, value);
            return null;
        });
    }

    protected void setCaseVariable(String caseExecution, String name, Object value) {
        this.runWithoutAuthorization(() -> {
            this.caseService.setVariable(caseExecution, name, value);
            return null;
        });
    }

    protected void setCaseVariableLocal(String caseExecution, String name, Object value) {
        this.runWithoutAuthorization(() -> {
            this.caseService.setVariableLocal(caseExecution, name, value);
            return null;
        });
    }

    protected ProcessDefinition selectProcessDefinitionByKey(String processDefinitionKey) {
        return this.runWithoutAuthorization(() -> (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).singleResult());
    }

    protected ProcessInstance selectSingleProcessInstance() {
        return this.runWithoutAuthorization(() -> (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult());
    }

    protected void suspendProcessDefinitionByKey(String processDefinitionKey) {
        this.runWithoutAuthorization(() -> {
            this.repositoryService.suspendProcessDefinitionByKey(processDefinitionKey);
            return null;
        });
    }

    protected void suspendProcessDefinitionById(String processDefinitionId) {
        this.runWithoutAuthorization(() -> {
            this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
            return null;
        });
    }

    protected void suspendProcessInstanceById(String processInstanceId) {
        this.runWithoutAuthorization(() -> {
            this.runtimeService.suspendProcessInstanceById(processInstanceId);
            return null;
        });
    }

    protected void suspendJobById(String jobId) {
        this.runWithoutAuthorization(() -> {
            this.managementService.suspendJobById(jobId);
            return null;
        });
    }

    protected void suspendJobByProcessInstanceId(String processInstanceId) {
        this.runWithoutAuthorization(() -> {
            this.managementService.suspendJobByProcessInstanceId(processInstanceId);
            return null;
        });
    }

    protected void suspendJobByJobDefinitionId(String jobDefinitionId) {
        this.runWithoutAuthorization(() -> {
            this.managementService.suspendJobByJobDefinitionId(jobDefinitionId);
            return null;
        });
    }

    protected void suspendJobByProcessDefinitionId(String processDefinitionId) {
        this.runWithoutAuthorization(() -> {
            this.managementService.suspendJobByProcessDefinitionId(processDefinitionId);
            return null;
        });
    }

    protected void suspendJobByProcessDefinitionKey(String processDefinitionKey) {
        this.runWithoutAuthorization(() -> {
            this.managementService.suspendJobByProcessDefinitionKey(processDefinitionKey);
            return null;
        });
    }

    protected void suspendJobDefinitionById(String jobDefinitionId) {
        this.runWithoutAuthorization(() -> {
            this.managementService.suspendJobDefinitionById(jobDefinitionId);
            return null;
        });
    }

    protected void suspendJobDefinitionByProcessDefinitionId(String processDefinitionId) {
        this.runWithoutAuthorization(() -> {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId);
            return null;
        });
    }

    protected void suspendJobDefinitionByProcessDefinitionKey(String processDefinitionKey) {
        this.runWithoutAuthorization(() -> {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(processDefinitionKey);
            return null;
        });
    }

    protected void suspendJobDefinitionIncludingJobsById(String jobDefinitionId) {
        this.runWithoutAuthorization(() -> {
            this.managementService.suspendJobDefinitionById(jobDefinitionId, true);
            return null;
        });
    }

    protected void suspendJobDefinitionIncludingJobsByProcessDefinitionId(String processDefinitionId) {
        this.runWithoutAuthorization(() -> {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId, true);
            return null;
        });
    }

    protected void suspendJobDefinitionIncludingJobsByProcessDefinitionKey(String processDefinitionKey) {
        this.runWithoutAuthorization(() -> {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(processDefinitionKey, true);
            return null;
        });
    }

    protected Deployment createDeployment(String name, String ... resources) {
        return this.runWithoutAuthorization(() -> {
            DeploymentBuilder builder = this.repositoryService.createDeployment();
            for (String resource : resources) {
                builder.addClasspathResource(resource);
            }
            Deployment deployment = builder.deploy();
            this.deploymentIds.add(deployment.getId());
            return deployment;
        });
    }

    protected void deleteDeployment(String deploymentId) {
        this.deleteDeployment(deploymentId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteDeployment(String deploymentId, boolean cascade) {
        Authentication authentication = this.identityService.getCurrentAuthentication();
        try {
            this.identityService.clearAuthentication();
            this.runWithoutAuthorization(() -> {
                this.repositoryService.deleteDeployment(deploymentId, cascade);
                return null;
            });
        }
        finally {
            if (authentication != null) {
                this.identityService.setAuthentication(authentication);
            }
        }
    }

    protected ProcessInstance startProcessAndExecuteJob(String key) {
        return this.runWithoutAuthorization(() -> {
            ProcessInstance processInstance = this.startProcessInstanceByKey(key);
            this.executeAvailableJobs(key);
            return processInstance;
        });
    }

    protected void executeAvailableJobs(String key) {
        this.runWithoutAuthorization(() -> {
            List jobs = this.managementService.createJobQuery().processDefinitionKey(key).withRetriesLeft().list();
            if (jobs.isEmpty()) {
                this.enableAuthorization();
                return null;
            }
            for (Job job : jobs) {
                try {
                    this.managementService.executeJob(job.getId());
                }
                catch (Exception exception) {}
            }
            this.executeAvailableJobs(key);
            return null;
        });
    }

    protected DecisionDefinition selectDecisionDefinitionByKey(String decisionDefinitionKey) {
        return this.runWithoutAuthorization(() -> (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(decisionDefinitionKey).singleResult());
    }

    protected void verifyQueryResults(Query<?, ?> query, int countExpected) {
        Assert.assertEquals((long)countExpected, (long)query.list().size());
        Assert.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            Assert.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            Assert.assertNull((Object)query.singleResult());
        }
    }

    protected void verifySingleResultFails(Query<?, ?> query) {
        try {
            query.singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public Permission getDefaultTaskPermissionForUser() {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        return processEngineConfiguration.getDefaultUserPermissionForTask();
    }

    protected VariableMap getVariables() {
        return Variables.createVariables().putValue(VARIABLE_NAME, (Object)VARIABLE_VALUE);
    }

    protected String getMissingPermissionMessageRegex(Permission permission, Resource resource) {
        return ".*'" + permission.getName() + "' permission .* type '" + resource.resourceName() + "'.*";
    }
}

