/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization;

import java.util.List;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.Assert;
import org.junit.Test;

public class ConditionStartEventAuthorizationTest
extends AuthorizationTest {
    private static final String SINGLE_CONDITIONAL_XML = "org/eximeebpms/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent1.bpmn20.xml";
    private static final String TRUE_CONDITIONAL_XML = "org/eximeebpms/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testStartInstanceWithTrueConditionalStartEvent.bpmn20.xml";
    protected static final String PROCESS_KEY = "conditionalEventProcess";
    protected static final String PROCESS_KEY_TWO = "trueConditionProcess";

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent1.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testStartInstanceWithTrueConditionalStartEvent.bpmn20.xml"})
    @Test
    public void testWithAllPermissions() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY_TWO, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        List instances = this.runtimeService.createConditionEvaluation().setVariable("foo", (Object)42).evaluateStartConditions();
        Assert.assertEquals((long)1L, (long)instances.size());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent1.bpmn20.xml"})
    @Test
    public void testWithoutProcessDefinitionPermissions() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.createConditionEvaluation().setVariable("foo", (Object)42).evaluateStartConditions();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("No subscriptions were found during evaluation of the conditional start events."));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent1.bpmn20.xml"})
    @Test
    public void testWithoutCreateInstancePermissions() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.createConditionEvaluation().setVariable("foo", (Object)42).evaluateStartConditions();
            Assert.fail((String)"expected exception");
        }
        catch (AuthorizationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'conditionalEventProcess' of type 'ProcessDefinition'."));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent1.bpmn20.xml"})
    @Test
    public void testWithoutProcessInstanccePermission() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.createConditionEvaluation().setVariable("foo", (Object)42).evaluateStartConditions();
            Assert.fail((String)"expected exception");
        }
        catch (AuthorizationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'."));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/conditional/ConditionalStartEventTest.testSingleConditionalStartEvent1.bpmn20.xml"})
    @Test
    public void testWithRevokeAuthorizations() {
        this.createRevokeAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.createConditionEvaluation().setVariable("foo", (Object)42).evaluateStartConditions();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("No subscriptions were found during evaluation of the conditional start events."));
        }
    }
}

