/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.history.HistoryLevel;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DeleteProcessDefinitionAuthorizationTest {
    public static final String PROCESS_DEFINITION_KEY = "one";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, PROCESS_DEFINITION_KEY, "userId", new Permission[]{Permissions.DELETE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, PROCESS_DEFINITION_KEY, "userId", new Permission[]{Permissions.DELETE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "*", "userId", new Permission[]{Permissions.DELETE})).succeeds());
    }

    @Before
    public void setUp() {
        this.authRule.createUserAndGroup("userId", "groupId");
        this.repositoryService = this.engineRule.getRepositoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
        this.repositoryService = null;
        this.runtimeService = null;
        this.processEngineConfiguration = null;
    }

    @Test
    public void testDeleteProcessDefinition() {
        this.testHelper.deploy("org/eximeebpms/bpm/engine/test/repository/twoProcesses.bpmn20.xml");
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        this.authRule.init(this.scenario).withUser("userId").start();
        this.repositoryService.deleteProcessDefinition(((ProcessDefinition)processDefinitions.get(0)).getId());
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        }
    }

    @Test
    public void testDeleteProcessDefinitionCascade() {
        BpmnModelInstance bpmnModel = Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().endEvent().done();
        this.testHelper.deploy(bpmnModel);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult();
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).executeWithVariablesInReturn();
        this.authRule.init(this.scenario).withUser("userId").start();
        this.repositoryService.deleteProcessDefinition(processDefinition.getId(), true);
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
            Assert.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().count());
            if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_ACTIVITY.getId()) {
                Assert.assertEquals((long)0L, (long)this.engineRule.getHistoryService().createHistoricActivityInstanceQuery().count());
            }
        }
    }

    @Test
    public void testDeleteProcessDefinitionsByKey() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinition();
        }
        this.authRule.init(this.scenario).withUser("userId").start();
        this.repositoryService.deleteProcessDefinitions().byKey(PROCESS_DEFINITION_KEY).withoutTenantId().delete();
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        }
    }

    @Test
    public void testDeleteProcessDefinitionsByKeyCascade() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinition();
        }
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        this.authRule.init(this.scenario).withUser("userId").start();
        this.repositoryService.deleteProcessDefinitions().byKey(PROCESS_DEFINITION_KEY).withoutTenantId().cascade().delete();
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
            Assert.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().count());
            if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_ACTIVITY.getId()) {
                Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
            }
        }
    }

    @Test
    public void testDeleteProcessDefinitionsByIds() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinition();
        }
        String[] processDefinitionIds = this.findProcessDefinitionIdsByKey(PROCESS_DEFINITION_KEY);
        this.authRule.init(this.scenario).withUser("userId").start();
        this.repositoryService.deleteProcessDefinitions().byIds(processDefinitionIds).delete();
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        }
    }

    @Test
    public void testDeleteProcessDefinitionsByIdsCascade() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinition();
        }
        String[] processDefinitionIds = this.findProcessDefinitionIdsByKey(PROCESS_DEFINITION_KEY);
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        this.authRule.init(this.scenario).withUser("userId").start();
        this.repositoryService.deleteProcessDefinitions().byIds(processDefinitionIds).cascade().delete();
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
            Assert.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().count());
            if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_ACTIVITY.getId()) {
                Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
            }
        }
    }

    private void deployProcessDefinition() {
        this.testHelper.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().endEvent().done());
    }

    private String[] findProcessDefinitionIdsByKey(String processDefinitionKey) {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).list();
        ArrayList<String> processDefinitionIds = new ArrayList<String>();
        for (ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionIds.add(processDefinition.getId());
        }
        return processDefinitionIds.toArray(new String[0]);
    }
}

