/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization;

import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.query.Query;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.ExecutionQuery;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExecutionAuthorizationTest
extends AuthorizationTest {
    protected static final String ONE_TASK_PROCESS_KEY = "oneTaskProcess";
    protected static final String MESSAGE_BOUNDARY_PROCESS_KEY = "messageBoundaryProcess";

    @Override
    @Before
    public void setUp() throws Exception {
        this.testRule.deploy("org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/authorization/messageBoundaryEventProcess.bpmn20.xml");
        super.setUp();
    }

    @Test
    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testSimpleQueryWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Execution execution = (Execution)query.singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstanceId, (Object)execution.getProcessInstanceId());
    }

    @Test
    public void testSimpleQueryWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Execution execution = (Execution)query.singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstanceId, (Object)execution.getProcessInstanceId());
    }

    @Test
    public void testSimpleQueryWithMultiple() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void shouldNotFindExecutionWithRevokedReadPermissionOnProcess() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", "*", new Permission[]{Permissions.READ});
        this.createRevokeAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testSimpleQueryWithReadInstancesPermissionOnOneTaskProcess() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Execution execution = (Execution)query.singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstanceId, (Object)execution.getProcessInstanceId());
    }

    @Test
    public void testSimpleQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Execution execution = (Execution)query.singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstanceId, (Object)execution.getProcessInstanceId());
    }

    @Test
    public void testQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryWithReadPermissionOnProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Execution execution = (Execution)query.singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)processInstanceId, (Object)execution.getProcessInstanceId());
    }

    @Test
    public void testQueryWithReadPermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 11);
    }

    @Test
    public void testQueryWithReadInstancesPermissionOnOneTaskProcess() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 3);
    }

    @Test
    public void testQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 11);
    }

    @Test
    public void testQueryShouldReturnAllExecutions() {
        ProcessInstance processInstance = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstance.getId(), this.userId, new Permission[]{Permissions.READ});
        ExecutionQuery query = this.runtimeService.createExecutionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }
}

