/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization;

import java.io.InputStream;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.authorization.TaskPermissions;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.form.StartFormData;
import org.eximeebpms.bpm.engine.form.TaskFormData;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.api.authorization.AuthorizationTest;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FormAuthorizationTest
extends AuthorizationTest {
    protected static final String FORM_PROCESS_KEY = "FormsProcess";
    protected static final String RENDERED_FORM_PROCESS_KEY = "renderedFormProcess";
    protected static final String CASE_KEY = "oneTaskCase";
    protected String deploymentId;
    protected boolean ensureSpecificVariablePermission;

    @Override
    @Before
    public void setUp() throws Exception {
        this.deploymentId = this.testRule.deploy("org/eximeebpms/bpm/engine/test/api/form/DeployedFormsProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/form/start.html", "org/eximeebpms/bpm/engine/test/api/form/task.html", "org/eximeebpms/bpm/engine/test/api/authorization/renderedFormProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/authorization/oneTaskCase.cmmn").getId();
        this.ensureSpecificVariablePermission = this.processEngineConfiguration.isEnforceSpecificVariablePermission();
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(this.ensureSpecificVariablePermission);
    }

    @Test
    public void testGetStartFormDataWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        try {
            this.formService.getStartFormData(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to get start form data");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(FORM_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetStartFormData() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        StartFormData startFormData = this.formService.getStartFormData(processDefinitionId);
        Assert.assertNotNull((Object)startFormData);
        Assert.assertEquals((Object)"deployment:org/eximeebpms/bpm/engine/test/api/form/start.html", (Object)startFormData.getFormKey());
    }

    @Test
    public void testGetRenderedStartFormWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(RENDERED_FORM_PROCESS_KEY).getId();
        try {
            this.formService.getRenderedStartForm(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to get start form data");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(RENDERED_FORM_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetRenderedStartForm() {
        String processDefinitionId = this.selectProcessDefinitionByKey(RENDERED_FORM_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, RENDERED_FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        Object renderedStartForm = this.formService.getRenderedStartForm(processDefinitionId);
        Assert.assertNotNull((Object)renderedStartForm);
    }

    @Test
    public void testGetStartFormVariablesWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(RENDERED_FORM_PROCESS_KEY).getId();
        try {
            this.formService.getStartFormVariables(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to get start form data");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(RENDERED_FORM_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetStartFormVariables() {
        String processDefinitionId = this.selectProcessDefinitionByKey(RENDERED_FORM_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, RENDERED_FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.formService.getStartFormVariables(processDefinitionId);
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((long)1L, (long)variables.size());
    }

    @Test
    public void testSubmitStartFormWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        try {
            this.formService.submitStartForm(processDefinitionId, null);
            Assert.fail((String)"Exception expected: It should not possible to submit a start form");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.CREATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
        }
    }

    @Test
    public void testSubmitStartFormWithCreatePermissionOnProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.formService.submitStartForm(processDefinitionId, null);
            Assert.fail((String)"Exception expected: It should not possible to submit a start form");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.CREATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(FORM_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSubmitStartFormWithCreateInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.formService.submitStartForm(processDefinitionId, null);
            Assert.fail((String)"Exception expected: It should not possible to submit a start form");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.CREATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
        }
    }

    @Test
    public void testSubmitStartForm() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        ProcessInstance instance = this.formService.submitStartForm(processDefinitionId, null);
        Assert.assertNotNull((Object)instance);
    }

    @Test
    public void testStandaloneTaskGetTaskFormDataWithoutAuthorization() {
        String message;
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.formService.getTaskFormData(taskId);
            Assert.fail((String)"Exception expected: It should not possible to get task form data");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.formService.getTaskFormData(taskId);
            Assert.fail((String)"Exception expected: It should not possible to get task form data");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(TaskPermissions.READ_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskGetTaskFormData() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        Assert.assertNull((Object)taskFormData);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskGetTaskFormDataWithReadVariablePermission() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.READ_VARIABLE});
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        Assert.assertNull((Object)taskFormData);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskGetTaskFormDataWithoutAuthorization() {
        String message;
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.formService.getTaskFormData(taskId);
            Assert.fail((String)"Exception expected: It should not possible to get task form data");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.testRule.assertTextPresent(FORM_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.formService.getTaskFormData(taskId);
            Assert.fail((String)"Exception expected: It should not possible to get task form data");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(TaskPermissions.READ_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.READ_TASK_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(FORM_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskGetTaskFormDataWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        Assert.assertNotNull((Object)taskFormData);
    }

    @Test
    public void testProcessTaskGetTaskFormDataWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        Assert.assertNotNull((Object)taskFormData);
    }

    @Test
    public void testProcessTaskGetTaskFormDataWithReadVariablePermissionOnTask() {
        this.setReadVariableAsDefaultReadVariablePermission();
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.READ_VARIABLE});
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        Assert.assertNotNull((Object)taskFormData);
    }

    @Test
    public void testProcessTaskGetTaskFormDataWithReadTaskVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_TASK_VARIABLE});
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        Assert.assertNotNull((Object)taskFormData);
    }

    @Test
    public void testProcessTaskGetTaskFormData() {
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        Assert.assertNotNull((Object)taskFormData);
    }

    @Test
    public void testCaseTaskGetTaskFormData() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        Assert.assertNotNull((Object)taskFormData);
    }

    @Test
    public void testStandaloneTaskGetTaskRenderedFormWithoutAuthorization() {
        String message;
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.formService.getRenderedTaskForm(taskId);
            Assert.fail((String)"Exception expected: It should not possible to get rendered task form");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.formService.getRenderedTaskForm(taskId);
            Assert.fail((String)"Exception expected: It should not possible to get rendered task form");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(TaskPermissions.READ_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskGetTaskRenderedForm() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        try {
            this.formService.getRenderedTaskForm(taskId);
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskGetTaskRenderedFormWithReadVariablePermission() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.READ_VARIABLE});
        try {
            this.formService.getRenderedTaskForm(taskId);
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskGetRenderedTaskFormWithoutAuthorization() {
        String message;
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.formService.getRenderedTaskForm(taskId);
            Assert.fail((String)"Exception expected: It should not possible to get rendered task form");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.testRule.assertTextPresent(RENDERED_FORM_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.formService.getRenderedTaskForm(taskId);
            Assert.fail((String)"Exception expected: It should not possible to get rendered task form");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(TaskPermissions.READ_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.READ_TASK_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(RENDERED_FORM_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskGetRenderedTaskFormWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        Object taskForm = this.formService.getRenderedTaskForm(taskId);
        Assert.assertNotNull((Object)taskForm);
    }

    @Test
    public void testProcessTaskGetRenderedTaskFormWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, RENDERED_FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        Object taskForm = this.formService.getRenderedTaskForm(taskId);
        Assert.assertNotNull((Object)taskForm);
    }

    @Test
    public void testProcessTaskGetRenderedTaskFormWithReadTaskVariablesPermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, RENDERED_FORM_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_TASK_VARIABLE});
        Object taskForm = this.formService.getRenderedTaskForm(taskId);
        Assert.assertNotNull((Object)taskForm);
    }

    @Test
    public void testProcessTaskGetRenderedTaskFormWithReadVariablePermissionOnTask() {
        this.setReadVariableAsDefaultReadVariablePermission();
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.READ_VARIABLE});
        Object taskForm = this.formService.getRenderedTaskForm(taskId);
        Assert.assertNotNull((Object)taskForm);
    }

    @Test
    public void testProcessTaskGetRenderedTaskForm() {
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, RENDERED_FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        Object taskForm = this.formService.getRenderedTaskForm(taskId);
        Assert.assertNotNull((Object)taskForm);
    }

    @Test
    public void testCaseTaskGetRenderedTaskForm() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        Object taskForm = this.formService.getRenderedTaskForm(taskId);
        Assert.assertNull((Object)taskForm);
    }

    @Test
    public void testStandaloneTaskGetTaskFormVariablesWithoutAuthorization() {
        String message;
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.formService.getTaskFormVariables(taskId);
            Assert.fail((String)"Exception expected: It should not possible to get task form variables");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.formService.getTaskFormVariables(taskId);
            Assert.fail((String)"Exception expected: It should not possible to get task form variables");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(TaskPermissions.READ_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskGetTaskFormVariables() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.formService.getTaskFormVariables(taskId);
        Assert.assertNotNull((Object)variables);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskGetTaskFormVariablesWithReadVariablePermission() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.READ_VARIABLE});
        VariableMap variables = this.formService.getTaskFormVariables(taskId);
        Assert.assertNotNull((Object)variables);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskGetTaskFormVariablesWithoutAuthorization() {
        String message;
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.formService.getTaskFormVariables(taskId);
            Assert.fail((String)"Exception expected: It should not possible to get task form variables");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.testRule.assertTextPresent(RENDERED_FORM_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        try {
            this.formService.getTaskFormVariables(taskId);
            Assert.fail((String)"Exception expected: It should not possible to get task form variables");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(TaskPermissions.READ_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.READ_TASK_VARIABLE.getName(), message);
            this.testRule.assertTextPresent(RENDERED_FORM_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskGetTaskFormVariablesWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.formService.getTaskFormVariables(taskId);
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((long)1L, (long)variables.size());
    }

    @Test
    public void testProcessTaskGetTaskFormVariablesWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, RENDERED_FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        VariableMap variables = this.formService.getTaskFormVariables(taskId);
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((long)1L, (long)variables.size());
    }

    @Test
    public void testProcessTaskGetTaskFormVariables() {
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, RENDERED_FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        VariableMap variables = this.formService.getTaskFormVariables(taskId);
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((long)1L, (long)variables.size());
    }

    @Test
    public void testProcessTaskGetTaskFormVariablesWithReadVariablePermissionOnTask() {
        this.setReadVariableAsDefaultReadVariablePermission();
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.READ_VARIABLE});
        VariableMap variables = this.formService.getTaskFormVariables(taskId);
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((long)1L, (long)variables.size());
    }

    @Test
    public void testProcessTaskGetTaskFormVariablesWithReadTaskVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, RENDERED_FORM_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_TASK_VARIABLE});
        VariableMap variables = this.formService.getTaskFormVariables(taskId);
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((long)1L, (long)variables.size());
    }

    @Test
    public void testCaseTaskGetTaskFormVariables() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        VariableMap variables = this.formService.getTaskFormVariables(taskId);
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((long)0L, (long)variables.size());
    }

    @Test
    public void testStandaloneTaskSubmitTaskFormWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.formService.submitTaskForm(taskId, null);
            Assert.fail((String)"Exception expected: It should not possible to submit a task form");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskSubmitTaskForm() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.formService.submitTaskForm(taskId, null);
        Task task = this.selectSingleTask();
        Assert.assertNull((Object)task);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskSubmitTaskFormWithoutAuthorization() {
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.formService.submitTaskForm(taskId, null);
            Assert.fail((String)"Exception expected: It should not possible to submit a task form");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.testRule.assertTextPresent(FORM_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskSubmitTaskFormWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.formService.submitTaskForm(taskId, null);
        Task task = this.selectSingleTask();
        Assert.assertNull((Object)task);
    }

    @Test
    public void testProcessTaskSubmitTaskFormWithUpdateTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.formService.submitTaskForm(taskId, null);
        Task task = this.selectSingleTask();
        Assert.assertNull((Object)task);
    }

    @Test
    public void testProcessTaskSubmitTaskForm() {
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.formService.submitTaskForm(taskId, null);
        Task task = this.selectSingleTask();
        Assert.assertNull((Object)task);
    }

    @Test
    public void testCaseTaskSubmitTaskForm() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.formService.submitTaskForm(taskId, null);
        Task task = this.selectSingleTask();
        Assert.assertNull((Object)task);
    }

    @Test
    public void testGetStartFormKeyWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        try {
            this.formService.getStartFormKey(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not possible to get a start form key");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(FORM_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetStartFormKey() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        String formKey = this.formService.getStartFormKey(processDefinitionId);
        Assert.assertEquals((Object)"deployment:org/eximeebpms/bpm/engine/test/api/form/start.html", (Object)formKey);
    }

    @Test
    public void testGetTaskFormKeyWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        try {
            this.formService.getTaskFormKey(processDefinitionId, "task");
            Assert.fail((String)"Exception expected: It should not possible to get a task form key");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(FORM_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetTaskFormKey() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        String formKey = this.formService.getTaskFormKey(processDefinitionId, "task");
        Assert.assertEquals((Object)"deployment:org/eximeebpms/bpm/engine/test/api/form/task.html", (Object)formKey);
    }

    @Test
    public void testGetDeployedStartForm() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        InputStream inputStream = this.formService.getDeployedStartForm(processDefinitionId);
        Assert.assertNotNull((Object)inputStream);
    }

    @Test
    public void testGetDeployedStartFormWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        try {
            this.formService.getDeployedStartForm(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not possible to get a deployed start form");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(FORM_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetDeployedTaskForm() {
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        InputStream inputStream = this.formService.getDeployedTaskForm(taskId);
        Assert.assertNotNull((Object)inputStream);
    }

    @Test
    public void testGetDeployedTaskFormWithoutAuthorization() {
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.formService.getDeployedTaskForm(taskId);
            Assert.fail((String)"Exception expected: It should not possible to get a deployed task form");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(FORM_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
        }
    }

    protected void setReadVariableAsDefaultReadVariablePermission() {
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
    }
}

