/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization;

import org.eximeebpms.bpm.engine.AuthorizationService;
import org.eximeebpms.bpm.engine.authorization.OptimizePermissions;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationTestBaseRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class OptimizeAuthorizationTest {
    protected static final String USER_ID = "user";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestBaseRule authRule = new AuthorizationTestBaseRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule);
    ProcessEngineConfigurationImpl processEngineConfiguration;
    AuthorizationService authorizationService;

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.authorizationService = this.engineRule.getAuthorizationService();
    }

    @Test
    public void testOptimizePermissionExists() {
        this.authRule.createGrantAuthorization((Resource)Resources.OPTIMIZE, "*", USER_ID, new Permission[]{OptimizePermissions.ALL});
        this.authRule.enableAuthorization(USER_ID);
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized(USER_ID, null, (Permission)OptimizePermissions.EDIT, (Resource)Resources.OPTIMIZE));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized(USER_ID, null, (Permission)OptimizePermissions.SHARE, (Resource)Resources.OPTIMIZE));
    }

    @After
    public void tearDown() {
        this.authRule.disableAuthorization();
        this.authRule.deleteUsersAndGroups();
    }
}

