/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization;

import java.util.Collections;
import java.util.List;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.task.Comment;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.Assert;
import org.junit.Test;

public class ProcessInstanceCommentAuthorizationTest
extends AuthorizationTest {
    protected static final String ONE_TASK_PROCESS_KEY = "oneTaskProcess";

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstanceTaskCommentWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createTask("myTask");
        Comment createdComment = this.createComment("myTask", processInstanceId, "aComment");
        try {
            this.taskService.deleteProcessInstanceComment(processInstanceId, createdComment.getId());
            Assert.fail((String)"Exception expected: It should not be possible to delete a task.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'UPDATE'", e.getMessage());
        }
        this.deleteTask("myTask", true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstanceTaskComment() {
        this.createTask("myTask");
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        Comment createdComment = this.taskService.createComment("myTask", processInstanceId, "aComment");
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteProcessInstanceComment(processInstanceId, createdComment.getId());
        List deletedCommentLst = this.taskService.getProcessInstanceComments(processInstanceId);
        Assert.assertEquals((String)"The comments list should be empty", Collections.emptyList(), (Object)deletedCommentLst);
        this.deleteTask("myTask", true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstanceTaskCommentsWithoutAuthorization() {
        this.createTask("myTask");
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createComment("myTask", processInstanceId, "aComment");
        try {
            this.taskService.deleteProcessInstanceComments(processInstanceId);
            Assert.fail((String)"Exception expected: It should not be possible to delete a comment.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'UPDATE'", e.getMessage());
        }
        this.deleteTask("myTask", true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstanceTaskComments() {
        this.createTask("myTask");
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.taskService.createComment("myTask", processInstanceId, "aCommentOne");
        this.taskService.createComment("myTask", processInstanceId, "aCommentTwo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteProcessInstanceComments(processInstanceId);
        List comments = this.taskService.getProcessInstanceComments(processInstanceId);
        Assert.assertEquals((String)"The comments list should be empty", Collections.emptyList(), (Object)comments);
        this.deleteTask("myTask", true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testUpdateProcessInstanceTaskCommentWithoutAuthorization() {
        this.createTask("myTask");
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        Comment createdComment = this.createComment("myTask", processInstanceId, "originalComment");
        try {
            this.taskService.updateProcessInstanceComment(processInstanceId, createdComment.getId(), "updateMessage");
            Assert.fail((String)"Exception expected: It should not be possible to delete a task.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'UPDATE'", e.getMessage());
        }
        this.deleteTask("myTask", true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testUpdateProcessInstanceTaskComment() {
        String taskId = "myTask";
        this.createTask(taskId);
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        String commentMessage = "OriginalCommentMessage";
        String updatedMessage = "UpdatedCommentMessage";
        Comment comment = this.taskService.createComment(taskId, processInstanceId, commentMessage);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.updateProcessInstanceComment(processInstanceId, comment.getId(), updatedMessage);
        List comments = this.taskService.getProcessInstanceComments(processInstanceId);
        Assert.assertFalse((String)"The comments list should not be empty", (boolean)comments.isEmpty());
        Assert.assertEquals((Object)updatedMessage, (Object)((Comment)comments.get(0)).getFullMessage());
        this.deleteTask(taskId, true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstanceCommentWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        Comment createdComment = this.createComment(null, processInstanceId, "aComment");
        try {
            this.taskService.deleteProcessInstanceComment(processInstanceId, createdComment.getId());
            Assert.fail((String)"Exception expected: It should not be possible to delete a task.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'UPDATE'", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstanceComment() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        Comment createdComment = this.taskService.createComment(null, processInstanceId, "aComment");
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteProcessInstanceComment(processInstanceId, createdComment.getId());
        List deletedCommentLst = this.taskService.getProcessInstanceComments(processInstanceId);
        Assert.assertEquals((String)"The comments list should be empty", Collections.emptyList(), (Object)deletedCommentLst);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstanceCommentsWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createComment(null, processInstanceId, "aComment");
        try {
            this.taskService.deleteProcessInstanceComments(processInstanceId);
            Assert.fail((String)"Exception expected: It should not be possible to delete a comment.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'UPDATE'", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstanceComments() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.taskService.createComment(null, processInstanceId, "aCommentOne");
        this.taskService.createComment(null, processInstanceId, "aCommentTwo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteProcessInstanceComments(processInstanceId);
        List comments = this.taskService.getProcessInstanceComments(processInstanceId);
        Assert.assertEquals((String)"The comments list should be empty", Collections.emptyList(), (Object)comments);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testUpdateProcessInstanceCommentWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        Comment createdComment = this.createComment(null, processInstanceId, "originalComment");
        try {
            this.taskService.updateProcessInstanceComment(processInstanceId, createdComment.getId(), "updateMessage");
            Assert.fail((String)"Exception expected: It should not be possible to delete a task.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'UPDATE'", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testUpdateProcessInstanceComment() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        String commentMessage = "OriginalCommentMessage";
        String updatedMessage = "UpdatedCommentMessage";
        Comment comment = this.taskService.createComment(null, processInstanceId, commentMessage);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.updateProcessInstanceComment(processInstanceId, comment.getId(), updatedMessage);
        List comments = this.taskService.getProcessInstanceComments(processInstanceId);
        Assert.assertFalse((String)"The comments list should not be empty", (boolean)comments.isEmpty());
        Assert.assertEquals((Object)updatedMessage, (Object)((Comment)comments.get(0)).getFullMessage());
    }
}

