/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization;

import java.util.Collections;
import org.eximeebpms.bpm.engine.AuthorizationService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.authorization.Authorization;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.api.authorization.MyResourceAuthorizationProvider;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class ResourceAuthorizationProviderTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/eximeebpms/bpm/engine/test/api/authorization/resource.authorization.provider.eximeebpms.cfg.xml");
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected IdentityService identityService;
    protected AuthorizationService authorizationService;
    protected TaskService taskService;
    protected String userId = "test";
    protected String groupId = "accounting";
    protected User user;
    protected Group group;

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.processEngineConfiguration.setResourceAuthorizationProvider((ResourceAuthorizationProvider)new MyResourceAuthorizationProvider());
        this.identityService = this.engineRule.getIdentityService();
        this.taskService = this.engineRule.getTaskService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        this.user = this.createUser(this.userId);
        this.group = this.createGroup(this.groupId);
        this.identityService.createMembership(this.userId, this.groupId);
        this.identityService.setAuthentication(this.userId, Collections.singletonList(this.groupId));
        this.processEngineConfiguration.setAuthorizationEnabled(true);
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }

    @Test
    public void testNewTaskAssignee() {
        MyResourceAuthorizationProvider.clearProperties();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", (Permission)Permissions.ALL, this.userId);
        String taskId = "myTask";
        Task newTask = this.taskService.newTask(taskId);
        this.taskService.saveTask(newTask);
        this.taskService.setAssignee(taskId, "demo");
        Assert.assertNull((Object)MyResourceAuthorizationProvider.OLD_ASSIGNEE);
        Assert.assertEquals((Object)"demo", (Object)MyResourceAuthorizationProvider.NEW_ASSIGNEE);
        MyResourceAuthorizationProvider.clearProperties();
        this.taskService.setAssignee(taskId, this.userId);
        Assert.assertEquals((Object)"demo", (Object)MyResourceAuthorizationProvider.OLD_ASSIGNEE);
        Assert.assertEquals((Object)this.userId, (Object)MyResourceAuthorizationProvider.NEW_ASSIGNEE);
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    public void testNewTaskOwner() {
        MyResourceAuthorizationProvider.clearProperties();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", (Permission)Permissions.ALL, this.userId);
        String taskId = "myTask";
        Task newTask = this.taskService.newTask(taskId);
        this.taskService.saveTask(newTask);
        this.taskService.setOwner(taskId, "demo");
        Assert.assertNull((Object)MyResourceAuthorizationProvider.OLD_OWNER);
        Assert.assertEquals((Object)"demo", (Object)MyResourceAuthorizationProvider.NEW_OWNER);
        MyResourceAuthorizationProvider.clearProperties();
        this.taskService.setOwner(taskId, this.userId);
        Assert.assertEquals((Object)"demo", (Object)MyResourceAuthorizationProvider.OLD_OWNER);
        Assert.assertEquals((Object)this.userId, (Object)MyResourceAuthorizationProvider.NEW_OWNER);
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    public void testAddCandidateUser() {
        MyResourceAuthorizationProvider.clearProperties();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", (Permission)Permissions.ALL, this.userId);
        String taskId = "myTask";
        Task newTask = this.taskService.newTask(taskId);
        this.taskService.saveTask(newTask);
        this.taskService.addCandidateUser(taskId, "demo");
        Assert.assertEquals((Object)"candidate", (Object)MyResourceAuthorizationProvider.ADD_USER_IDENTITY_LINK_TYPE);
        Assert.assertEquals((Object)"demo", (Object)MyResourceAuthorizationProvider.ADD_USER_IDENTITY_LINK_USER);
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    public void testAddUserIdentityLink() {
        MyResourceAuthorizationProvider.clearProperties();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", (Permission)Permissions.ALL, this.userId);
        String taskId = "myTask";
        Task newTask = this.taskService.newTask(taskId);
        this.taskService.saveTask(newTask);
        this.taskService.addUserIdentityLink(taskId, "demo", "myIdentityLink");
        Assert.assertEquals((Object)"myIdentityLink", (Object)MyResourceAuthorizationProvider.ADD_USER_IDENTITY_LINK_TYPE);
        Assert.assertEquals((Object)"demo", (Object)MyResourceAuthorizationProvider.ADD_USER_IDENTITY_LINK_USER);
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    public void testAddCandidateGroup() {
        MyResourceAuthorizationProvider.clearProperties();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", (Permission)Permissions.ALL, this.userId);
        String taskId = "myTask";
        Task newTask = this.taskService.newTask(taskId);
        this.taskService.saveTask(newTask);
        this.taskService.addCandidateGroup(taskId, "management");
        Assert.assertEquals((Object)"candidate", (Object)MyResourceAuthorizationProvider.ADD_GROUP_IDENTITY_LINK_TYPE);
        Assert.assertEquals((Object)"management", (Object)MyResourceAuthorizationProvider.ADD_GROUP_IDENTITY_LINK_GROUP);
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    public void testAddGroupIdentityLink() {
        MyResourceAuthorizationProvider.clearProperties();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", (Permission)Permissions.ALL, this.userId);
        String taskId = "myTask";
        Task newTask = this.taskService.newTask(taskId);
        this.taskService.saveTask(newTask);
        this.taskService.addGroupIdentityLink(taskId, "management", "myIdentityLink");
        Assert.assertEquals((Object)"myIdentityLink", (Object)MyResourceAuthorizationProvider.ADD_GROUP_IDENTITY_LINK_TYPE);
        Assert.assertEquals((Object)"management", (Object)MyResourceAuthorizationProvider.ADD_GROUP_IDENTITY_LINK_GROUP);
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    public void testDeleteUserIdentityLink() {
        MyResourceAuthorizationProvider.clearProperties();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", (Permission)Permissions.ALL, this.userId);
        String taskId = "myTask";
        Task newTask = this.taskService.newTask(taskId);
        this.taskService.saveTask(newTask);
        this.taskService.addCandidateUser(taskId, "demo");
        this.taskService.deleteCandidateUser(taskId, "demo");
        Assert.assertEquals((Object)"candidate", (Object)MyResourceAuthorizationProvider.DELETE_USER_IDENTITY_LINK_TYPE);
        Assert.assertEquals((Object)"demo", (Object)MyResourceAuthorizationProvider.DELETE_USER_IDENTITY_LINK_USER);
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    public void testDeleteGroupIdentityLink() {
        MyResourceAuthorizationProvider.clearProperties();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", (Permission)Permissions.ALL, this.userId);
        String taskId = "myTask";
        Task newTask = this.taskService.newTask(taskId);
        this.taskService.saveTask(newTask);
        this.taskService.addCandidateGroup(taskId, "management");
        this.taskService.deleteCandidateGroup(taskId, "management");
        Assert.assertEquals((Object)"candidate", (Object)MyResourceAuthorizationProvider.DELETE_GROUP_IDENTITY_LINK_TYPE);
        Assert.assertEquals((Object)"management", (Object)MyResourceAuthorizationProvider.DELETE_GROUP_IDENTITY_LINK_GROUP);
        this.taskService.deleteTask(taskId, true);
    }

    protected User createUser(String userId) {
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
        Authorization authorization = this.createGrantAuthorization((Resource)Resources.AUTHORIZATION, "*");
        authorization.setUserId(userId);
        authorization.addPermission((Permission)Permissions.ALL);
        this.saveAuthorization(authorization);
        authorization = this.createGrantAuthorization((Resource)Resources.USER, "*");
        authorization.setUserId(userId);
        authorization.addPermission((Permission)Permissions.ALL);
        this.saveAuthorization(authorization);
        return user;
    }

    protected Group createGroup(String groupId) {
        Group group = this.identityService.newGroup(groupId);
        this.identityService.saveGroup(group);
        return group;
    }

    protected void createGrantAuthorization(Resource resource, String resourceId, Permission permission, String userId) {
        Authorization authorization = this.createGrantAuthorization(resource, resourceId);
        authorization.setUserId(userId);
        authorization.addPermission(permission);
        this.saveAuthorization(authorization);
    }

    protected Authorization createGrantAuthorization(Resource resource, String resourceId) {
        Authorization authorization = this.createAuthorization(1, resource, resourceId);
        return authorization;
    }

    protected Authorization createAuthorization(int type, Resource resource, String resourceId) {
        Authorization authorization = this.authorizationService.createNewAuthorization(type);
        authorization.setResource(resource);
        if (resourceId != null) {
            authorization.setResourceId(resourceId);
        }
        return authorization;
    }

    protected void saveAuthorization(Authorization authorization) {
        this.authorizationService.saveAuthorization(authorization);
    }
}

