/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.api.authorization.AuthorizationTest;
import org.eximeebpms.bpm.engine.test.util.ClockTestUtil;
import org.eximeebpms.bpm.engine.test.util.EntityRemoveRule;
import org.eximeebpms.bpm.engine.test.util.ObjectProperty;
import org.eximeebpms.bpm.engine.test.util.RemoveAfter;
import org.eximeebpms.bpm.engine.test.util.TriConsumer;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SetTaskPropertyAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    @Rule
    public EntityRemoveRule entityRemoveRule;
    @Parameterized.Parameter(value=0)
    public String operationName;
    @Parameterized.Parameter(value=1)
    public TriConsumer<TaskService, String, Object> operation;
    @Parameterized.Parameter(value=2)
    public String taskId;
    @Parameterized.Parameter(value=3)
    public Object value;
    protected boolean deleteTask;

    public SetTaskPropertyAuthorizationTest() {
        this.entityRemoveRule = EntityRemoveRule.of(this.testRule);
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> data() {
        TriConsumer<TaskService, String, Object> setPriority = (taskService, taskId, value) -> taskService.setPriority(taskId, ((Integer)value).intValue());
        TriConsumer<TaskService, String, Object> setName = (taskService, taskId, value) -> taskService.setName(taskId, (String)value);
        TriConsumer<TaskService, String, Object> setDescription = (taskService, taskId, value) -> taskService.setDescription(taskId, (String)value);
        TriConsumer<TaskService, String, Object> setDueDate = (taskService, taskId, value) -> taskService.setDueDate(taskId, (Date)value);
        TriConsumer<TaskService, String, Object> setFollowUpDate = (taskService, taskId, value) -> taskService.setFollowUpDate(taskId, (Date)value);
        return Arrays.asList({"setPriority", setPriority, "taskId", 80}, {"setName", setName, "taskId", "name"}, {"setDescription", setDescription, "taskId", "description"}, {"setDueDate", setDueDate, "taskId", ClockTestUtil.setClockToDateWithoutMilliseconds()}, {"setFollowUpDate", setFollowUpDate, "taskId", ClockTestUtil.setClockToDateWithoutMilliseconds()});
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.testRule.deploy("org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml");
        super.setUp();
    }

    @Test
    @RemoveAfter
    public void shouldSetOperationStandaloneWithoutAuthorization() {
        this.createTask(this.taskId);
        try {
            this.operation.accept(this.taskService, this.taskId, this.value);
            Fail.fail((String)("Exception expected: It should not be possible to " + this.operationName));
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id '" + this.userId + "' does not have one of the following permissions: 'TASK_ASSIGN'", e.getMessage());
        }
    }

    @Test
    @RemoveAfter
    public void shouldSetOperationStandalone() {
        this.createTask(this.taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, this.taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.operation.accept(this.taskService, this.taskId, this.value);
        Task task = this.selectSingleTask();
        Assertions.assertThat((Object)task).isNotNull();
        this.assertHasPropertyValue(task, this.operationName, this.value);
    }

    @Test
    @RemoveAfter
    public void shouldSetOperationStandaloneWithTaskAssignPermission() {
        this.createTask(this.taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, this.taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.operation.accept(this.taskService, this.taskId, this.value);
        Task task = this.selectSingleTask();
        Assertions.assertThat((Object)task).isNotNull();
        this.assertHasPropertyValue(task, this.operationName, this.value);
    }

    @Test
    public void shouldSetOperationOnProcessWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.operation.accept(this.taskService, taskId, this.value);
        Task task = this.selectSingleTask();
        Assertions.assertThat((Object)task).isNotNull();
        this.assertHasPropertyValue(task, this.operationName, this.value);
    }

    @Test
    public void shouldSetOperationOnProcessWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.operation.accept(this.taskService, taskId, this.value);
            Fail.fail((String)("Exception expected: It should not be possible to " + this.operationName));
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void shouldSetOperationOnProcessWithUpdatePermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.operation.accept(this.taskService, taskId, this.value);
        Task task = this.selectSingleTask();
        Assertions.assertThat((Object)task).isNotNull();
        this.assertHasPropertyValue(task, this.operationName, this.value);
    }

    @Test
    public void shouldSetOperationOnProcessWithTaskAssignPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.operation.accept(this.taskService, taskId, this.value);
        Task task = this.selectSingleTask();
        Assertions.assertThat((Object)task).isNotNull();
        this.assertHasPropertyValue(task, this.operationName, this.value);
    }

    @Test
    public void shouldSetOperationOnProcessWithUpdateTasksPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.operation.accept(this.taskService, taskId, this.value);
        Task task = this.selectSingleTask();
        Assertions.assertThat((Object)task).isNotNull();
        this.assertHasPropertyValue(task, this.operationName, this.value);
    }

    @Test
    public void shouldSetOperationOnProcessWithTaskAssignPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.operation.accept(this.taskService, taskId, this.value);
        Task task = this.selectSingleTask();
        Assertions.assertThat((Object)task).isNotNull();
        this.assertHasPropertyValue(task, this.operationName, this.value);
    }

    @Test
    public void shouldSetOperationOnProcessTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.operation.accept(this.taskService, taskId, this.value);
        Task task = this.selectSingleTask();
        Assertions.assertThat((Object)task).isNotNull();
        this.assertHasPropertyValue(task, this.operationName, this.value);
    }

    @Test
    public void shouldSetOperationOnProcessWithTaskAssignPermission() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.operation.accept(this.taskService, taskId, this.value);
        Task task = this.selectSingleTask();
        Assertions.assertThat((Object)task).isNotNull();
        this.assertHasPropertyValue(task, this.operationName, this.value);
    }

    private void assertHasPropertyValue(Task task, String operationName, Object expectedValue) {
        try {
            Object value = ObjectProperty.ofSetterMethod(task, operationName).getValue();
            Assertions.assertThat((Object)value).isEqualTo(expectedValue);
        }
        catch (Exception e) {
            Fail.fail((String)("Failed to assert property for operationName=" + operationName + " due to : " + e.getMessage()));
        }
    }
}

