/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization;

import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.authorization.TaskPermissions;
import org.eximeebpms.bpm.engine.query.Query;
import org.eximeebpms.bpm.engine.runtime.VariableInstance;
import org.eximeebpms.bpm.engine.runtime.VariableInstanceQuery;
import org.eximeebpms.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VariableInstanceAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String CASE_KEY = "oneTaskCase";
    protected String deploymentId;
    protected boolean ensureSpecificVariablePermission;

    @Override
    @Before
    public void setUp() throws Exception {
        this.deploymentId = this.testRule.deploy("org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/authorization/oneTaskCase.cmmn").getId();
        this.ensureSpecificVariablePermission = this.processEngineConfiguration.isEnforceSpecificVariablePermission();
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(this.ensureSpecificVariablePermission);
    }

    @Test
    public void testProcessVariableQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testCaseVariableQueryWithoutAuthorization() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testProcessLocalTaskVariableQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, "aVariableName", "aVariableValue");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testCaseLocalTaskVariableQueryWithoutAuthorization() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, "aVariableName", "aVariableValue");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testStandaloneTaskVariableQueryWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.setTaskVariable(taskId, "aVariableName", "aVariableValue");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessVariableQueryWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        VariableInstance variable = (VariableInstance)query.singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)processInstanceId, (Object)variable.getProcessInstanceId());
    }

    @Test
    public void testProcessVariableQueryWithReadInstancesPermissionOnOneTaskProcess() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        VariableInstance variable = (VariableInstance)query.singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)processInstanceId, (Object)variable.getProcessInstanceId());
    }

    @Test
    public void testProcessVariableQueryWithReadInstanceVariablePermission() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        VariableInstance variable = (VariableInstance)query.singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)processInstanceId, (Object)variable.getProcessInstanceId());
    }

    public void failingTestProcessVariableQueryWithReadVariablePermission() {
        this.setReadVariableAsDefaultReadVariablePermission();
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{TaskPermissions.READ_VARIABLE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testProcessVariableQueryWithReadProcessInstanceWhenReadVariableIsEnabled() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testProcessVariableQueryWithReadTaskWhenReadVariableIsEnabled() {
        this.setReadVariableAsDefaultReadVariablePermission();
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testProcessLocalTaskVariableQueryWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, "aVariableName", "aVariableValue");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testProcessLocalTaskVariableQueryWithMultiple() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, "aVariableName", "aVariableValue");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testProcessLocalTaskVariableQueryWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, "aVariableName", "aVariableValue");
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        VariableInstance variable = (VariableInstance)query.singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)processInstanceId, (Object)variable.getProcessInstanceId());
    }

    @Test
    public void testProcessLocalTaskVariableQueryWithReadPermissionOnOneProcessTask() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, "aVariableName", "aVariableValue");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        VariableInstance variable = (VariableInstance)query.singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)processInstanceId, (Object)variable.getProcessInstanceId());
    }

    @Test
    public void testProcessLocalTaskVariableQueryWithReadInstanceVariablePermission() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, "aVariableName", "aVariableValue");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        VariableInstance variable = (VariableInstance)query.singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)processInstanceId, (Object)variable.getProcessInstanceId());
    }

    @Test
    public void testProcessLocalTaskVariableQueryWithReadVariablePermission() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, "aVariableName", "aVariableValue");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.READ_VARIABLE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        VariableInstance variable = (VariableInstance)query.singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)processInstanceId, (Object)variable.getProcessInstanceId());
    }

    @Test
    public void testProcessLocalTaskVariableQueryWithReadProcessInstanceWhenReadVariableIsEnabled() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, "aVariableName", "aVariableValue");
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testProcessLocalTaskVariableQueryWithReadTaskWhenReadVariableIsEnabled() {
        this.setReadVariableAsDefaultReadVariablePermission();
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, "aVariableName", "aVariableValue");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testStandaloneTaskVariableQueryWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.setTaskVariable(taskId, "aVariableName", "aVariableValue");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskVariableQueryWithReadVariablePermissionOnTask() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String taskId = "myTask";
        this.createTask(taskId);
        this.setTaskVariable(taskId, "aVariableName", "aVariableValue");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.READ_VARIABLE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testMixedVariables() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.setTaskVariable(taskId, "aVariableName", "aVariableValue");
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getProcessInstanceId();
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.verifyQueryResults((Query<?, ?>)query, 2);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        this.verifyQueryResults((Query<?, ?>)query, 3);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testMixedVariablesWhenReadVariableIsEnabled() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String taskId = "myTask";
        this.createTask(taskId);
        this.setTaskVariable(taskId, "aVariableName", "aVariableValue");
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getProcessInstanceId();
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.READ_VARIABLE});
        this.verifyQueryResults((Query<?, ?>)query, 2);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        this.verifyQueryResults((Query<?, ?>)query, 3);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testQueryWithVariableValueFilter() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("aVariableName", (Object)"aVariableValue");
        VariableInstanceQuery ignoreCaseQuery = this.runtimeService.createVariableInstanceQuery().variableValueEquals("aVariableName", (Object)"aVariableValue").matchVariableNamesIgnoreCase();
        List results = query.list();
        List ignoreCaseResults = ignoreCaseQuery.list();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)1L, (long)ignoreCaseResults.size());
    }

    @Test
    public void shouldNotFindProcessVariableWithRevokedReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", "*", new Permission[]{Permissions.ALL});
        this.createRevokeAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    protected void setReadVariableAsDefaultReadVariablePermission() {
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
    }
}

