/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.batch;

import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.batch.history.HistoricBatch;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractBatchAuthorizationTest {
    protected static final String TEST_REASON = "test reason";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    protected ProcessDefinition sourceDefinition;
    protected ProcessDefinition sourceDefinition2;
    protected ProcessInstance processInstance;
    protected ProcessInstance processInstance2;
    protected Batch batch;
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected int invocationsPerBatchJob;

    @Before
    public void setUp() {
        this.authRule.createUserAndGroup("userId", "groupId");
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.invocationsPerBatchJob = this.engineRule.getProcessEngineConfiguration().getInvocationsPerBatchJob();
    }

    @Before
    public void deployProcesses() {
        this.sourceDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).changeElementId("Process", "ONE_TASK_PROCESS"));
        this.sourceDefinition2 = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.TWO_TASKS_PROCESS).changeElementId("Process", "TWO_TASKS_PROCESS"));
        this.processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(this.sourceDefinition.getId());
        this.processInstance2 = this.engineRule.getRuntimeService().startProcessInstanceById(this.sourceDefinition2.getId());
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(this.invocationsPerBatchJob);
    }

    @After
    public void cleanBatch() {
        HistoricBatch historicBatch;
        Batch batch = (Batch)this.engineRule.getManagementService().createBatchQuery().singleResult();
        if (batch != null) {
            this.engineRule.getManagementService().deleteBatch(batch.getId(), true);
        }
        if ((historicBatch = (HistoricBatch)this.engineRule.getHistoryService().createHistoricBatchQuery().singleResult()) != null) {
            this.engineRule.getHistoryService().deleteHistoricBatch(historicBatch.getId());
        }
    }

    protected void executeSeedAndBatchJobs() {
        this.executeSeedJobs();
        for (Job pending : this.managementService.createJobQuery().jobDefinitionId(this.batch.getBatchJobDefinitionId()).list()) {
            this.managementService.executeJob(pending.getId());
        }
    }

    public void executeSeedJobs() {
        while (this.getSeedJob() != null) {
            this.managementService.executeJob(this.getSeedJob().getId());
        }
    }

    public Job getSeedJob() {
        return (Job)this.engineRule.getManagementService().createJobQuery().jobDefinitionId(this.batch.getSeedJobDefinitionId()).singleResult();
    }

    protected abstract AuthorizationScenario getScenario();
}

