/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.dmn;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.dmn.engine.DmnDecisionTableResult;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.repository.DecisionDefinition;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EvaluateDecisionAuthorizationTest {
    protected static final String DMN_FILE = "org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn";
    protected static final String DECISION_DEFINITION_KEY = "decision";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, "userId", new Permission[]{Permissions.CREATE_INSTANCE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, "userId", new Permission[]{Permissions.CREATE_INSTANCE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.DECISION_DEFINITION, "*", "userId", new Permission[]{Permissions.CREATE_INSTANCE})).succeeds());
    }

    @Before
    public void setUp() {
        this.authRule.createUserAndGroup("userId", "groupId");
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn"})
    public void evaluateDecisionById() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.engineRule.getRepositoryService().createDecisionDefinitionQuery().singleResult();
        this.authRule.init(this.scenario).withUser("userId").bindResource("decisionDefinitionKey", DECISION_DEFINITION_KEY).start();
        DmnDecisionTableResult decisionResult = this.engineRule.getDecisionService().evaluateDecisionTableById(decisionDefinition.getId(), (Map)this.createVariables());
        if (this.authRule.assertScenario(this.scenario)) {
            this.assertThatDecisionHasExpectedResult(decisionResult);
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn"})
    public void evaluateDecisionByKey() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.engineRule.getRepositoryService().createDecisionDefinitionQuery().singleResult();
        this.authRule.init(this.scenario).withUser("userId").bindResource("decisionDefinitionKey", DECISION_DEFINITION_KEY).start();
        DmnDecisionTableResult decisionResult = this.engineRule.getDecisionService().evaluateDecisionTableByKey(decisionDefinition.getKey(), (Map)this.createVariables());
        if (this.authRule.assertScenario(this.scenario)) {
            this.assertThatDecisionHasExpectedResult(decisionResult);
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn"})
    public void evaluateDecisionByKeyAndVersion() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.engineRule.getRepositoryService().createDecisionDefinitionQuery().singleResult();
        this.authRule.init(this.scenario).withUser("userId").bindResource("decisionDefinitionKey", DECISION_DEFINITION_KEY).start();
        DmnDecisionTableResult decisionResult = this.engineRule.getDecisionService().evaluateDecisionTableByKeyAndVersion(decisionDefinition.getKey(), Integer.valueOf(decisionDefinition.getVersion()), (Map)this.createVariables());
        if (this.authRule.assertScenario(this.scenario)) {
            this.assertThatDecisionHasExpectedResult(decisionResult);
        }
    }

    protected VariableMap createVariables() {
        return Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723);
    }

    protected void assertThatDecisionHasExpectedResult(DmnDecisionTableResult decisionResult) {
        Assertions.assertThat((List)decisionResult).isNotNull();
        Assertions.assertThat((List)decisionResult).hasSize(1);
        String value = (String)decisionResult.getSingleResult().getFirstEntry();
        Assertions.assertThat((String)value).isEqualTo((Object)"ok");
    }
}

