/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.externaltask;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.externaltask.ExternalTask;
import org.eximeebpms.bpm.engine.externaltask.ExternalTaskQuery;
import org.eximeebpms.bpm.engine.externaltask.LockedExternalTask;
import org.eximeebpms.bpm.engine.query.Query;
import org.eximeebpms.bpm.engine.test.api.authorization.AuthorizationTest;
import org.eximeebpms.commons.testing.ProcessEngineLoggingRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ExternalTaskQueryAuthorizationTest
extends AuthorizationTest {
    protected static final String WORKER_ID = "aWorkerId";
    protected static final String EXTERNAL_TASK_TOPIC = "externalTaskTopic";
    protected String deploymentId;
    protected String instance1Id;
    protected String instance2Id;
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule();

    @Override
    @Before
    public void setUp() throws Exception {
        this.deploymentId = this.testRule.deploy("org/eximeebpms/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml").getId();
        this.instance1Id = this.startProcessInstanceByKey("oneExternalTaskProcess").getId();
        this.instance2Id = this.startProcessInstanceByKey("twoExternalTaskProcess").getId();
        super.setUp();
    }

    @Test
    public void testQueryWithoutAuthorization() {
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryWithReadOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Assert.assertEquals((Object)this.instance1Id, (Object)((ExternalTask)query.list().get(0)).getProcessInstanceId());
    }

    @Test
    public void testQueryWithReadOnAnyProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    @Test
    public void testQueryWithReadInstanceOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Assert.assertEquals((Object)this.instance1Id, (Object)((ExternalTask)query.list().get(0)).getProcessInstanceId());
    }

    @Test
    public void testQueryWithReadInstanceOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    @Test
    public void testQueryWithReadInstanceWithMultiple() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    @Test
    public void shouldNotFindTaskWithRevokedReadOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        this.createRevokeAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void shouldFetchAndLockWhenUserAuthorized() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.ALL});
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(EXTERNAL_TASK_TOPIC, 10L).execute();
        Assertions.assertThat((List)externalTasks).hasSize(1);
        ((ObjectAssert)Assertions.assertThat((List)externalTasks).extracting(LockedExternalTask::getTopicName).first()).isEqualTo((Object)EXTERNAL_TASK_TOPIC);
    }

    @Test
    public void shouldFetchAndLockWhenGroupAuthorized() {
        this.createGrantAuthorizationGroup((Resource)Resources.PROCESS_DEFINITION, "*", this.groupId, new Permission[]{Permissions.ALL});
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(EXTERNAL_TASK_TOPIC, 10L).execute();
        Assertions.assertThat((List)externalTasks).hasSize(1);
        ((ObjectAssert)Assertions.assertThat((List)externalTasks).extracting(LockedExternalTask::getTopicName).first()).isEqualTo((Object)EXTERNAL_TASK_TOPIC);
    }

    @Test
    public void shouldNotFetchAndLockWhenUnauthorized() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        this.createGrantAuthorizationGroup((Resource)Resources.PROCESS_DEFINITION, "*", this.groupId, new Permission[]{Permissions.READ_INSTANCE});
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(EXTERNAL_TASK_TOPIC, 10L).execute();
        Assertions.assertThat((List)externalTasks).isEmpty();
    }
}

