/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.externaltask;

import java.util.List;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GetTopicNamesAuthorizationTest
extends AuthorizationTest {
    protected String instance1Id;
    protected String instance2Id;

    @Override
    @Before
    public void setUp() throws Exception {
        this.testRule.deploy("org/eximeebpms/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchMultipleTopics.bpmn20.xml");
        this.instance1Id = this.startProcessInstanceByKey("oneExternalTaskProcess").getId();
        this.instance2Id = this.startProcessInstanceByKey("parallelExternalTaskProcess").getId();
        super.setUp();
    }

    @Test
    public void testGetTopicNamesWithoutAuthorization() {
        List result = this.externalTaskService.getTopicNames();
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testGetTopicNamesWithReadOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        List result = this.externalTaskService.getTopicNames();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"externalTaskTopic", result.get(0));
    }

    @Test
    public void testGetTopicNamesWithReadOnAnyProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        List result = this.externalTaskService.getTopicNames();
        Assert.assertEquals((long)4L, (long)result.size());
    }

    @Test
    public void testGetTopicNamesWithReadInstanceOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List result = this.externalTaskService.getTopicNames();
        Assert.assertEquals((long)4L, (long)result.size());
    }

    @Test
    public void testGetTopicNamesWithReadDefinitionWithMultiple() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List result = this.externalTaskService.getTopicNames();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"externalTaskTopic", result.get(0));
    }

    @Test
    public void testGetTopicNamesWithReadInstanceWithMultiple() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        List result = this.externalTaskService.getTopicNames();
        Assert.assertEquals((long)4L, (long)result.size());
    }
}

