/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.history;

import org.eximeebpms.bpm.engine.authorization.Authorization;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.authorization.UserOperationLogCategoryPermissions;
import org.eximeebpms.bpm.engine.history.UserOperationLogEntry;
import org.eximeebpms.bpm.engine.history.UserOperationLogQuery;
import org.eximeebpms.bpm.engine.impl.cfg.auth.DefaultPermissionProvider;
import org.eximeebpms.bpm.engine.impl.cfg.auth.PermissionProvider;
import org.eximeebpms.bpm.engine.impl.util.StringUtil;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.authorization.AuthorizationTest;
import org.eximeebpms.bpm.engine.test.api.identity.TestPermissions;
import org.eximeebpms.bpm.engine.test.api.identity.TestResource;
import org.junit.Assert;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class AuthorizationUserOperationLogTest
extends AuthorizationTest {
    @Test
    public void testLogCreatedOnAuthorizationCreation() {
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Admin", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assert.assertEquals((long)0L, (long)query.count());
        this.createGrantAuthorizationGroup((Resource)Resources.PROCESS_DEFINITION, "*", "testGroupId", new Permission[]{ProcessDefinitionPermissions.DELETE});
        Assert.assertEquals((long)6L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("permissionBits").singleResult();
        Assert.assertEquals((Object)"Create", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)String.valueOf(ProcessDefinitionPermissions.DELETE.getValue()), (Object)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("permissions").singleResult();
        Assert.assertEquals((Object)"Create", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)ProcessDefinitionPermissions.DELETE.getName(), (Object)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("type").singleResult();
        Assert.assertEquals((Object)"Create", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)String.valueOf(1), (Object)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("resource").singleResult();
        Assert.assertEquals((Object)"Create", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)Resources.PROCESS_DEFINITION.resourceName(), (Object)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("resourceId").singleResult();
        Assert.assertEquals((Object)"Create", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)"*", (Object)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("groupId").singleResult();
        Assert.assertEquals((Object)"Create", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)"testGroupId", (Object)entry.getNewValue());
    }

    @Test
    public void testLogCreatedOnAuthorizationUpdate() {
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Authorization authorization = this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, "*", "testUserId", new Permission[]{Permissions.DELETE});
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Admin", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        Assert.assertEquals((long)0L, (long)query.count());
        authorization.addPermission((Permission)Permissions.READ);
        authorization.setResource((Resource)Resources.PROCESS_INSTANCE);
        authorization.setResourceId("abc123");
        authorization.setGroupId("testGroupId");
        authorization.setUserId(null);
        this.saveAuthorization(authorization);
        Assert.assertEquals((long)7L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("permissionBits").singleResult();
        Assert.assertEquals((Object)"Update", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)String.valueOf(Permissions.DELETE.getValue() | Permissions.READ.getValue()), (Object)entry.getNewValue());
        Assert.assertEquals((Object)String.valueOf(Permissions.DELETE.getValue()), (Object)entry.getOrgValue());
        entry = (UserOperationLogEntry)query.property("permissions").singleResult();
        Assert.assertEquals((Object)"Update", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)(Permissions.READ.getName() + ", " + Permissions.DELETE.getName()), (Object)entry.getNewValue());
        Assert.assertEquals((Object)Permissions.DELETE.getName(), (Object)entry.getOrgValue());
        entry = (UserOperationLogEntry)query.property("type").singleResult();
        Assert.assertEquals((Object)"Update", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)String.valueOf(1), (Object)entry.getNewValue());
        Assert.assertEquals((Object)String.valueOf(1), (Object)entry.getOrgValue());
        entry = (UserOperationLogEntry)query.property("resource").singleResult();
        Assert.assertEquals((Object)"Update", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)Resources.PROCESS_INSTANCE.resourceName(), (Object)entry.getNewValue());
        Assert.assertEquals((Object)Resources.PROCESS_DEFINITION.resourceName(), (Object)entry.getOrgValue());
        entry = (UserOperationLogEntry)query.property("resourceId").singleResult();
        Assert.assertEquals((Object)"Update", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)"abc123", (Object)entry.getNewValue());
        Assert.assertEquals((Object)"*", (Object)entry.getOrgValue());
        entry = (UserOperationLogEntry)query.property("userId").singleResult();
        Assert.assertEquals((Object)"Update", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertNull((Object)entry.getNewValue());
        Assert.assertEquals((Object)"testUserId", (Object)entry.getOrgValue());
        entry = (UserOperationLogEntry)query.property("groupId").singleResult();
        Assert.assertEquals((Object)"Update", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)"testGroupId", (Object)entry.getNewValue());
        Assert.assertNull((Object)entry.getOrgValue());
    }

    @Test
    public void testLogCreatedOnAuthorizationDeletion() {
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Authorization authorization = this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.PROCESS_DEFINITION, "*", "testUserId", new Permission[]{ProcessDefinitionPermissions.DELETE});
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Admin", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        Assert.assertEquals((long)0L, (long)query.count());
        this.authorizationService.deleteAuthorization(authorization.getId());
        Assert.assertEquals((long)6L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("permissionBits").singleResult();
        Assert.assertEquals((Object)"Delete", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)String.valueOf(ProcessDefinitionPermissions.DELETE.getValue()), (Object)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("permissions").singleResult();
        Assert.assertEquals((Object)"Delete", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)ProcessDefinitionPermissions.DELETE.getName(), (Object)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("type").singleResult();
        Assert.assertEquals((Object)"Delete", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)String.valueOf(1), (Object)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("resource").singleResult();
        Assert.assertEquals((Object)"Delete", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)Resources.PROCESS_DEFINITION.resourceName(), (Object)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("resourceId").singleResult();
        Assert.assertEquals((Object)"Delete", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)"*", (Object)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("userId").singleResult();
        Assert.assertEquals((Object)"Delete", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)"testUserId", (Object)entry.getNewValue());
    }

    @Test
    public void testLogCreatedOnAuthorizationCreationWithExceedingPermissionStringList() {
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Admin", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assert.assertEquals((long)0L, (long)query.count());
        PermissionProvider permissionProvider = this.processEngineConfiguration.getPermissionProvider();
        this.processEngineConfiguration.setPermissionProvider((PermissionProvider)new TestPermissionProvider());
        this.createGrantAuthorizationGroup(TestResource.RESOURCE1, "*", "testGroupId", TestPermissions.LONG_NAME);
        this.processEngineConfiguration.setPermissionProvider(permissionProvider);
        Assert.assertEquals((long)6L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("permissions").singleResult();
        Assert.assertEquals((Object)"Create", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)TestPermissions.LONG_NAME.getName().substring(0, StringUtil.DB_MAX_STRING_LENGTH), (Object)entry.getNewValue());
    }

    @Test
    public void testLogCreatedOnAuthorizationCreationWithAllPermission() {
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Admin", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assert.assertEquals((long)0L, (long)query.count());
        PermissionProvider permissionProvider = this.processEngineConfiguration.getPermissionProvider();
        this.processEngineConfiguration.setPermissionProvider((PermissionProvider)new TestPermissionProvider());
        this.createGrantAuthorizationGroup(TestResource.RESOURCE1, "*", "testGroupId", TestPermissions.ALL);
        this.processEngineConfiguration.setPermissionProvider(permissionProvider);
        Assert.assertEquals((long)6L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("permissions").singleResult();
        Assert.assertEquals((Object)"Create", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)TestPermissions.ALL.getName(), (Object)entry.getNewValue());
    }

    @Test
    public void testLogCreatedOnAuthorizationCreationWithNonePermission() {
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Admin", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assert.assertEquals((long)0L, (long)query.count());
        PermissionProvider permissionProvider = this.processEngineConfiguration.getPermissionProvider();
        this.processEngineConfiguration.setPermissionProvider((PermissionProvider)new TestPermissionProvider());
        this.createGrantAuthorizationGroup(TestResource.RESOURCE1, "*", "testGroupId", TestPermissions.NONE);
        this.processEngineConfiguration.setPermissionProvider(permissionProvider);
        Assert.assertEquals((long)6L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("permissions").singleResult();
        Assert.assertEquals((Object)"Create", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"Admin", (Object)entry.getCategory());
        Assert.assertEquals((Object)"Authorization", (Object)entry.getEntityType());
        Assert.assertEquals((Object)TestPermissions.NONE.getName(), (Object)entry.getNewValue());
    }

    @Test
    public void testLogCreatedOnAuthorizationCreationWithoutAuthorization() {
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assert.assertEquals((long)0L, (long)query.count());
        this.createGrantAuthorizationGroup((Resource)Resources.PROCESS_DEFINITION, "*", "testGroupId", new Permission[]{ProcessDefinitionPermissions.DELETE});
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Test
    public void testLogCreatedOnAuthorizationCreationWithReadPermissionOnAnyCategoryPermission() {
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "*", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assert.assertEquals((long)0L, (long)query.count());
        this.createGrantAuthorizationGroup((Resource)Resources.PROCESS_DEFINITION, "*", "testGroupId", new Permission[]{ProcessDefinitionPermissions.DELETE});
        Assert.assertEquals((long)6L, (long)query.count());
    }

    @Test
    public void testLogCreatedOnAuthorizationCreationWithReadPermissionOnWrongCategory() {
        this.createGrantAuthorizationWithoutAuthentication((Resource)Resources.OPERATION_LOG_CATEGORY, "Operator", this.userId, new Permission[]{UserOperationLogCategoryPermissions.READ});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assert.assertEquals((long)0L, (long)query.count());
        this.createGrantAuthorizationGroup((Resource)Resources.PROCESS_DEFINITION, "*", "testGroupId", new Permission[]{ProcessDefinitionPermissions.DELETE});
        Assert.assertEquals((long)0L, (long)query.count());
    }

    public static class TestPermissionProvider
    extends DefaultPermissionProvider {
        public String getNameForResource(int resourceType) {
            for (TestResource resource : TestResource.values()) {
                if (resourceType != resource.resourceType()) continue;
                return resource.resourceName();
            }
            return null;
        }

        public Permission[] getPermissionsForResource(int resourceType) {
            return TestPermissions.values();
        }
    }
}

