/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.history;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstance;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RequiredHistoryLevel(value="activity")
@RunWith(value=Parameterized.class)
public class DeleteHistoricProcessInstancesAuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    protected ProcessInstance processInstance;
    protected ProcessInstance processInstance2;
    protected HistoricProcessInstance historicProcessInstance;
    protected HistoricProcessInstance historicProcessInstance2;
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected ManagementService managementService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process", "userId", new Permission[]{Permissions.READ_HISTORY})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process", "userId", new Permission[]{Permissions.DELETE_HISTORY})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process", "userId", new Permission[]{Permissions.READ_HISTORY, Permissions.DELETE_HISTORY})).succeeds());
    }

    @Before
    public void setUp() {
        this.authRule.createUserAndGroup("userId", "groupId");
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
        this.deployAndCompleteProcesses();
    }

    public void deployAndCompleteProcesses() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        this.processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        this.processInstance2 = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        List<String> processInstanceIds = Arrays.asList(this.processInstance.getId(), this.processInstance2.getId());
        this.runtimeService.deleteProcessInstances(processInstanceIds, null, false, false);
        this.historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(this.processInstance.getId()).singleResult();
        this.historicProcessInstance2 = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(this.processInstance2.getId()).singleResult();
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @Test
    public void testProcessInstancesList() {
        List<String> processInstanceIds = Arrays.asList(this.historicProcessInstance.getId(), this.historicProcessInstance2.getId());
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstance1", this.processInstance.getId()).bindResource("processInstance2", this.processInstance2.getId()).start();
        this.historyService.deleteHistoricProcessInstances(processInstanceIds);
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertThat((Object)this.historyService.createHistoricProcessInstanceQuery().count(), (Matcher)Is.is((Object)0L));
        }
    }
}

