/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.history;

import java.util.Collection;
import java.util.Map;
import org.eximeebpms.bpm.engine.DecisionService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.repository.DecisionRequirementsDefinition;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HistoricDecisionInstanceStatisticsAuthorizationTest {
    protected static final String DISH_DRG_DMN = "org/eximeebpms/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    protected DecisionService decisionService;
    protected HistoryService historyService;
    protected RepositoryService repositoryService;
    protected DecisionRequirementsDefinition decisionRequirementsDefinition;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.DECISION_REQUIREMENTS_DEFINITION, "dish", "userId", new Permission[]{Permissions.READ})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.DECISION_REQUIREMENTS_DEFINITION, "drd", "userId", new Permission[]{Permissions.READ})).succeeds());
    }

    @Before
    public void setUp() {
        this.testHelper.deploy(DISH_DRG_DMN);
        this.decisionService = this.engineRule.getDecisionService();
        this.historyService = this.engineRule.getHistoryService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.authRule.createUserAndGroup("userId", "groupId");
        this.decisionService.evaluateDecisionTableByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)21).putValue("dayType", (Object)"Weekend")).evaluate();
        this.decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().singleResult();
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @Test
    public void testCreateStatistics() {
        this.authRule.init(this.scenario).withUser("userId").bindResource("drd", "*").start();
        this.historyService.createHistoricDecisionInstanceStatisticsQuery(this.decisionRequirementsDefinition.getId()).list();
        this.authRule.assertScenario(this.scenario);
    }
}

