/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.history;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.authorization.Authorization;
import org.eximeebpms.bpm.engine.authorization.HistoricProcessInstancePermissions;
import org.eximeebpms.bpm.engine.authorization.HistoricTaskPermissions;
import org.eximeebpms.bpm.engine.authorization.MissingAuthorization;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.authorization.TaskPermissions;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstance;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstanceQuery;
import org.eximeebpms.bpm.engine.query.PeriodUnit;
import org.eximeebpms.bpm.engine.query.Query;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@RequiredHistoryLevel(value="activity")
public class HistoricTaskInstanceAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String MESSAGE_START_PROCESS_KEY = "messageStartProcess";
    protected static final String CASE_KEY = "oneTaskCase";
    protected String deploymentId;

    @Override
    @Before
    public void setUp() throws Exception {
        this.deploymentId = this.testRule.deploy("org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/authorization/messageStartEventProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/authorization/oneTaskCase.cmmn").getId();
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(false);
    }

    @Test
    public void testQueryAfterStandaloneTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testSimpleQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testSimpleQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testSimpleQueryWithMultiple() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void shouldNottFindTaskWithRevokedReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", "*", new Permission[]{Permissions.READ_HISTORY});
        this.createRevokeAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 3);
    }

    @Test
    public void testQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 7);
    }

    @Test
    public void testQueryAfterCaseTask() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testMixedQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createTask("one");
        this.createTask("two");
        this.createTask("three");
        this.createTask("four");
        this.createTask("five");
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 7);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    @Test
    public void testMixedQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createTask("one");
        this.createTask("two");
        this.createTask("three");
        this.createTask("four");
        this.createTask("five");
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 10);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    @Test
    public void testMixedQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createTask("one");
        this.createTask("two");
        this.createTask("three");
        this.createTask("four");
        this.createTask("five");
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 14);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    @Test
    public void testQueryAfterDeletingDeployment() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.enableAuthorization();
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 3);
        this.disableAuthorization();
        List instances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance instance : instances) {
            this.historyService.deleteHistoricProcessInstance(instance.getId());
        }
        this.enableAuthorization();
    }

    @Test
    public void testDeleteStandaloneTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.historyService.deleteHistoricTaskInstance(taskId);
        this.disableAuthorization();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().taskId(taskId);
        this.verifyQueryResults((Query<?, ?>)query, 0);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    @Test
    public void testDeleteProcessTaskWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.historyService.deleteHistoricTaskInstance(taskId);
            Assert.fail((String)"Exception expected: It should not be possible to delete the historic task instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.DELETE_HISTORY.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testDeleteProcessTaskWithDeleteHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.historyService.deleteHistoricTaskInstance(taskId);
        this.disableAuthorization();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().taskId(taskId);
        this.verifyQueryResults((Query<?, ?>)query, 0);
        this.enableAuthorization();
    }

    @Test
    public void testDeleteProcessTaskWithDeleteHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.historyService.deleteHistoricTaskInstance(taskId);
        this.disableAuthorization();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().taskId(taskId);
        this.verifyQueryResults((Query<?, ?>)query, 0);
        this.enableAuthorization();
    }

    @Test
    public void testDeleteHistoricTaskInstanceAfterDeletingDeployment() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        this.historyService.deleteHistoricTaskInstance(taskId);
        this.disableAuthorization();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().taskId(taskId);
        this.verifyQueryResults((Query<?, ?>)query, 0);
        this.enableAuthorization();
        this.disableAuthorization();
        this.historyService.deleteHistoricProcessInstance(processInstanceId);
        this.enableAuthorization();
    }

    @Test
    public void testHistoricTaskInstanceDurationReportWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        try {
            this.historyService.createHistoricTaskInstanceReport().duration(PeriodUnit.MONTH);
            Assert.fail((String)"Exception expected: It should not be possible to create a historic task instance report");
        }
        catch (AuthorizationException e) {
            List missingAuthorizations = e.getMissingAuthorizations();
            Assert.assertEquals((long)1L, (long)missingAuthorizations.size());
            MissingAuthorization missingAuthorization = (MissingAuthorization)missingAuthorizations.get(0);
            Assert.assertEquals((Object)Permissions.READ_HISTORY.toString(), (Object)missingAuthorization.getViolatedPermissionName());
            Assert.assertEquals((Object)Resources.PROCESS_DEFINITION.resourceName(), (Object)missingAuthorization.getResourceType());
            Assert.assertEquals((Object)"*", (Object)missingAuthorization.getResourceId());
        }
    }

    @Test
    public void testHistoricTaskInstanceReportWithHistoryReadPermissionOnAny() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        List result = this.historyService.createHistoricTaskInstanceReport().duration(PeriodUnit.MONTH);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testHistoricTaskInstanceCountByProcessDefinitionReportWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        try {
            this.historyService.createHistoricTaskInstanceReport().countByProcessDefinitionKey();
            Assert.fail((String)"Exception expected: It should not be possible to create a historic task instance report");
        }
        catch (AuthorizationException e) {
            List missingAuthorizations = e.getMissingAuthorizations();
            Assert.assertEquals((long)1L, (long)missingAuthorizations.size());
            MissingAuthorization missingAuthorization = (MissingAuthorization)missingAuthorizations.get(0);
            Assert.assertEquals((Object)Permissions.READ_HISTORY.toString(), (Object)missingAuthorization.getViolatedPermissionName());
            Assert.assertEquals((Object)Resources.PROCESS_DEFINITION.resourceName(), (Object)missingAuthorization.getResourceType());
            Assert.assertEquals((Object)"*", (Object)missingAuthorization.getResourceId());
        }
    }

    @Test
    public void testHistoricTaskInstanceReportGroupedByProcessDefinitionKeyWithHistoryReadPermissionOnAny() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        List result = this.historyService.createHistoricTaskInstanceReport().countByProcessDefinitionKey();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testHistoricTaskInstanceGroupedByTaskNameReportWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        try {
            this.historyService.createHistoricTaskInstanceReport().countByTaskName();
            Assert.fail((String)"Exception expected: It should not be possible to create a historic task instance report");
        }
        catch (AuthorizationException e) {
            List missingAuthorizations = e.getMissingAuthorizations();
            Assert.assertEquals((long)1L, (long)missingAuthorizations.size());
            MissingAuthorization missingAuthorization = (MissingAuthorization)missingAuthorizations.get(0);
            Assert.assertEquals((Object)Permissions.READ_HISTORY.toString(), (Object)missingAuthorization.getViolatedPermissionName());
            Assert.assertEquals((Object)Resources.PROCESS_DEFINITION.resourceName(), (Object)missingAuthorization.getResourceType());
            Assert.assertEquals((Object)"*", (Object)missingAuthorization.getResourceId());
        }
    }

    @Test
    public void testHistoricTaskInstanceGroupedByTaskNameReportWithHistoryReadPermissionOnAny() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        List result = this.historyService.createHistoricTaskInstanceReport().countByTaskName();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckAllHistoricTaskPermissions() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, "*", this.userId, new Permission[]{HistoricTaskPermissions.ALL});
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricTaskPermissions.NONE, (Resource)Resources.HISTORIC_TASK));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricTaskPermissions.READ, (Resource)Resources.HISTORIC_TASK));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricTaskPermissions.READ_VARIABLE, (Resource)Resources.HISTORIC_TASK));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricTaskPermissions.ALL, (Resource)Resources.HISTORIC_TASK));
    }

    @Test
    public void testCheckReadHistoricTaskPermissions() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, "*", this.userId, new Permission[]{HistoricTaskPermissions.READ});
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricTaskPermissions.NONE, (Resource)Resources.HISTORIC_TASK));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricTaskPermissions.READ, (Resource)Resources.HISTORIC_TASK));
    }

    @Test
    public void testCheckNoneHistoricTaskPermission() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, "*", this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricTaskPermissions.NONE, (Resource)Resources.HISTORIC_TASK));
    }

    @Test
    public void testCheckNonePermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testCheckReadPermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckReadPermissionOnStandaloneHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String taskId = "aTaskId";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testCheckNonePermissionOnStandaloneHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String taskId = "aTaskId";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)result.size());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testCheckReadPermissionOnCompletedHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckNonePermissionOndHistoricTaskAndReadHistoryPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckReadPermissionOndHistoricTaskAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testHistoricTaskPermissionsAuthorizationDisabled() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.disableAuthorization();
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testHistoricTaskReadPermissionGrantedWhenAssign() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.TASK_ASSIGN});
        this.enableAuthorization();
        this.taskService.setAssignee(taskId, this.userId);
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testHistoricTaskReadPermissionGrantedWhenAddingIdentityLinkOnStandaloneTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String taskId = "aTaskId";
        this.createTask(taskId);
        this.disableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.TASK_ASSIGN});
        this.enableAuthorization();
        this.taskService.setAssignee(taskId, this.userId);
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testHistoricTaskReadPermissionGrantedWhenSettingOwner() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.TASK_ASSIGN});
        this.enableAuthorization();
        this.taskService.setOwner(taskId, this.userId);
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testHistoricTaskReadPermissionGrantedWhenSettingCandidateUser() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.TASK_ASSIGN});
        this.enableAuthorization();
        this.taskService.addCandidateUser(taskId, this.userId);
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testHistoricTaskReadPermissionGrantedWhenSettingCandidateGroup() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.TASK_ASSIGN});
        this.enableAuthorization();
        this.taskService.addCandidateGroup(taskId, this.groupId);
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testStandaloneTaskClearHistoricAuthorization() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.ALL});
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{Permissions.ALL});
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).resourceId(taskId).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        this.historyService.deleteHistoricTaskInstance(taskId);
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).resourceId(taskId).singleResult();
        this.enableAuthorization();
        Assert.assertNull((Object)authorization);
        this.taskService.deleteTask(taskId);
    }

    @Test
    public void testProcessTaskClearHistoricAuthorization() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.ALL});
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{Permissions.ALL});
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).resourceId(taskId).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        this.taskService.complete(taskId);
        this.historyService.deleteHistoricTaskInstance(taskId);
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).resourceId(taskId).singleResult();
        this.enableAuthorization();
        Assert.assertNull((Object)authorization);
        this.taskService.deleteTask(taskId);
    }

    @Test
    public void testCheckNonePermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assertions.assertThat((List)query.list()).isEmpty();
    }

    @Test
    public void testCheckReadPermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckReadPermissionOnCompletedHHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckNoneOnHistoricProcessInstanceAndReadHistoryPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckReadPermissionOnHistoricProcessInstanceAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }
}

