/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.cfg;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.db.AuthorizationCheck;
import org.eximeebpms.bpm.engine.impl.db.ListQueryParameterObject;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.eximeebpms.bpm.engine.impl.identity.Authentication;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AuthorizationCheckRevokesCfgTest {
    private static final List<String> AUTHENTICATED_GROUPS = Arrays.asList("aGroup");
    private static final String AUTHENTICATED_USER_ID = "userId";
    CommandContext mockedCmdContext;
    ProcessEngineConfigurationImpl mockedConfiguration;
    AuthorizationManager authorizationManager;
    DbEntityManager mockedEntityManager;

    @Before
    public void setup() {
        this.mockedCmdContext = (CommandContext)Mockito.mock(CommandContext.class);
        this.mockedConfiguration = (ProcessEngineConfigurationImpl)Mockito.mock(ProcessEngineConfigurationImpl.class);
        this.authorizationManager = (AuthorizationManager)Mockito.spy((Object)new AuthorizationManager());
        this.mockedEntityManager = (DbEntityManager)Mockito.mock(DbEntityManager.class);
        Mockito.when((Object)((DbEntityManager)this.mockedCmdContext.getSession((Class)Mockito.eq(DbEntityManager.class)))).thenReturn((Object)this.mockedEntityManager);
        Mockito.when((Object)this.authorizationManager.filterAuthenticatedGroupIds((List)Mockito.eq(AUTHENTICATED_GROUPS))).thenReturn(AUTHENTICATED_GROUPS);
        Mockito.when((Object)this.mockedCmdContext.getAuthentication()).thenReturn((Object)new Authentication(AUTHENTICATED_USER_ID, AUTHENTICATED_GROUPS));
        Mockito.when((Object)this.mockedCmdContext.isAuthorizationCheckEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedConfiguration.isAuthorizationEnabled()).thenReturn((Object)true);
        Context.setCommandContext((CommandContext)this.mockedCmdContext);
        Context.setProcessEngineConfiguration((ProcessEngineConfigurationImpl)this.mockedConfiguration);
    }

    @After
    public void cleanup() {
        Context.removeCommandContext();
        Context.removeProcessEngineConfiguration();
    }

    @Test
    public void shouldUseCfgValue_always() {
        ListQueryParameterObject query = new ListQueryParameterObject();
        AuthorizationCheck authCheck = query.getAuthCheck();
        Mockito.when((Object)this.mockedConfiguration.getAuthorizationCheckRevokes()).thenReturn((Object)"always");
        this.authorizationManager.configureQuery(query);
        Assert.assertEquals((Object)true, (Object)authCheck.isRevokeAuthorizationCheckEnabled());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedEntityManager});
    }

    @Test
    public void shouldUseCfgValue_never() {
        ListQueryParameterObject query = new ListQueryParameterObject();
        AuthorizationCheck authCheck = query.getAuthCheck();
        Mockito.when((Object)this.mockedConfiguration.getAuthorizationCheckRevokes()).thenReturn((Object)"never");
        this.authorizationManager.configureQuery(query);
        Assert.assertEquals((Object)false, (Object)authCheck.isRevokeAuthorizationCheckEnabled());
        ((DbEntityManager)Mockito.verify((Object)this.mockedEntityManager, (VerificationMode)Mockito.never())).selectBoolean((String)Mockito.eq((Object)"selectRevokeAuthorization"), Mockito.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedEntityManager});
    }

    @Test
    public void shouldCheckDbForCfgValue_auto() {
        ListQueryParameterObject query = new ListQueryParameterObject();
        AuthorizationCheck authCheck = query.getAuthCheck();
        HashMap<String, Object> expectedQueryParams = new HashMap<String, Object>();
        expectedQueryParams.put(AUTHENTICATED_USER_ID, AUTHENTICATED_USER_ID);
        expectedQueryParams.put("authGroupIds", AUTHENTICATED_GROUPS);
        Mockito.when((Object)this.mockedConfiguration.getAuthorizationCheckRevokes()).thenReturn((Object)"auto");
        Mockito.when((Object)this.mockedEntityManager.selectBoolean((String)Mockito.eq((Object)"selectRevokeAuthorization"), Mockito.eq(expectedQueryParams))).thenReturn((Object)true);
        this.authorizationManager.configureQuery(query);
        Assert.assertEquals((Object)true, (Object)authCheck.isRevokeAuthorizationCheckEnabled());
        ((DbEntityManager)Mockito.verify((Object)this.mockedEntityManager, (VerificationMode)Mockito.times((int)1))).selectBoolean((String)Mockito.eq((Object)"selectRevokeAuthorization"), Mockito.eq(expectedQueryParams));
    }

    @Test
    public void shouldCheckDbForCfgValueWithNoRevokes_auto() {
        ListQueryParameterObject query = new ListQueryParameterObject();
        AuthorizationCheck authCheck = query.getAuthCheck();
        HashMap<String, Object> expectedQueryParams = new HashMap<String, Object>();
        expectedQueryParams.put(AUTHENTICATED_USER_ID, AUTHENTICATED_USER_ID);
        expectedQueryParams.put("authGroupIds", AUTHENTICATED_GROUPS);
        Mockito.when((Object)this.mockedConfiguration.getAuthorizationCheckRevokes()).thenReturn((Object)"auto");
        Mockito.when((Object)this.mockedEntityManager.selectBoolean((String)Mockito.eq((Object)"selectRevokeAuthorization"), Mockito.eq(expectedQueryParams))).thenReturn((Object)false);
        this.authorizationManager.configureQuery(query);
        Assert.assertEquals((Object)false, (Object)authCheck.isRevokeAuthorizationCheckEnabled());
        ((DbEntityManager)Mockito.verify((Object)this.mockedEntityManager, (VerificationMode)Mockito.times((int)1))).selectBoolean((String)Mockito.eq((Object)"selectRevokeAuthorization"), Mockito.eq(expectedQueryParams));
    }

    @Test
    public void shouldCheckDbForCfgCaseInsensitive() {
        ListQueryParameterObject query = new ListQueryParameterObject();
        AuthorizationCheck authCheck = query.getAuthCheck();
        HashMap<String, Object> expectedQueryParams = new HashMap<String, Object>();
        expectedQueryParams.put(AUTHENTICATED_USER_ID, AUTHENTICATED_USER_ID);
        expectedQueryParams.put("authGroupIds", AUTHENTICATED_GROUPS);
        Mockito.when((Object)this.mockedConfiguration.getAuthorizationCheckRevokes()).thenReturn((Object)"AuTo");
        Mockito.when((Object)this.mockedEntityManager.selectBoolean((String)Mockito.eq((Object)"selectRevokeAuthorization"), Mockito.eq(expectedQueryParams))).thenReturn((Object)true);
        this.authorizationManager.configureQuery(query);
        Assert.assertEquals((Object)true, (Object)authCheck.isRevokeAuthorizationCheckEnabled());
        ((DbEntityManager)Mockito.verify((Object)this.mockedEntityManager, (VerificationMode)Mockito.times((int)1))).selectBoolean((String)Mockito.eq((Object)"selectRevokeAuthorization"), Mockito.eq(expectedQueryParams));
    }

    @Test
    public void shouldCacheCheck() {
        ListQueryParameterObject query = new ListQueryParameterObject();
        AuthorizationCheck authCheck = query.getAuthCheck();
        HashMap<String, Object> expectedQueryParams = new HashMap<String, Object>();
        expectedQueryParams.put(AUTHENTICATED_USER_ID, AUTHENTICATED_USER_ID);
        expectedQueryParams.put("authGroupIds", AUTHENTICATED_GROUPS);
        Mockito.when((Object)this.mockedConfiguration.getAuthorizationCheckRevokes()).thenReturn((Object)"auto");
        Mockito.when((Object)this.mockedEntityManager.selectBoolean((String)Mockito.eq((Object)"selectRevokeAuthorization"), Mockito.eq(expectedQueryParams))).thenReturn((Object)true);
        this.authorizationManager.configureQuery(query);
        this.authorizationManager.configureQuery(query);
        Assert.assertEquals((Object)true, (Object)authCheck.isRevokeAuthorizationCheckEnabled());
        ((DbEntityManager)Mockito.verify((Object)this.mockedEntityManager, (VerificationMode)Mockito.times((int)1))).selectBoolean((String)Mockito.eq((Object)"selectRevokeAuthorization"), Mockito.eq(expectedQueryParams));
    }

    @Test
    public void testAutoIsDefault() {
        Assert.assertEquals((Object)"auto", (Object)new StandaloneProcessEngineConfiguration().getAuthorizationCheckRevokes());
    }
}

