/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.cfg;

import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.apache.ibatis.session.Configuration;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.junit.Assert;
import org.junit.Test;

public class ConnectionPoolTest {
    @Test
    public void testMyBatisConnectionPoolProperlyConfigured() {
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/eximeebpms/bpm/engine/test/api/cfg/connection-pool.eximeebpms.cfg.xml");
        ProcessEngine engine = config.buildProcessEngine();
        int maxActive = 25;
        int maxIdle = 10;
        int maxCheckoutTime = 30000;
        int maxWaitTime = 25000;
        Integer jdbcStatementTimeout = 300;
        Assert.assertEquals((long)maxActive, (long)config.getJdbcMaxActiveConnections());
        Assert.assertEquals((long)maxIdle, (long)config.getJdbcMaxIdleConnections());
        Assert.assertEquals((long)maxCheckoutTime, (long)config.getJdbcMaxCheckoutTime());
        Assert.assertEquals((long)maxWaitTime, (long)config.getJdbcMaxWaitTime());
        Assert.assertEquals((Object)jdbcStatementTimeout, (Object)config.getJdbcStatementTimeout());
        Configuration sessionFactoryConfiguration = config.getDbSqlSessionFactory().getSqlSessionFactory().getConfiguration();
        DataSource datasource = sessionFactoryConfiguration.getEnvironment().getDataSource();
        Assert.assertTrue((boolean)(datasource instanceof PooledDataSource));
        PooledDataSource pooledDataSource = (PooledDataSource)datasource;
        Assert.assertEquals((long)maxActive, (long)pooledDataSource.getPoolMaximumActiveConnections());
        Assert.assertEquals((long)maxIdle, (long)pooledDataSource.getPoolMaximumIdleConnections());
        Assert.assertEquals((long)maxCheckoutTime, (long)pooledDataSource.getPoolMaximumCheckoutTime());
        Assert.assertEquals((long)maxWaitTime, (long)pooledDataSource.getPoolTimeToWait());
        Assert.assertEquals((Object)jdbcStatementTimeout, (Object)sessionFactoryConfiguration.getDefaultStatementTimeout());
        engine.close();
    }
}

