/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.cfg;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.dmn.engine.DmnEngine;
import org.eximeebpms.bpm.dmn.engine.DmnEngineConfiguration;
import org.eximeebpms.bpm.dmn.engine.delegate.DmnDecisionTableEvaluationListener;
import org.eximeebpms.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.eximeebpms.bpm.dmn.engine.impl.spi.el.DmnScriptEngineResolver;
import org.eximeebpms.bpm.dmn.engine.impl.spi.el.ElProvider;
import org.eximeebpms.bpm.dmn.feel.impl.FeelEngineFactory;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.dmn.el.ProcessEngineJuelElProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DmnEngineConfigurationTest {
    protected static final String CONFIGURATION_XML = "org/eximeebpms/bpm/engine/test/api/cfg/custom-dmn-eximeebpms.cfg.xml";
    protected ProcessEngine engine;

    @After
    public void tearDown() {
        if (this.engine != null) {
            this.engine.close();
            this.engine = null;
        }
    }

    @Test
    public void setDefaultInputExpressionLanguage() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = (DefaultDmnEngineConfiguration)DmnEngineConfiguration.createDefaultDmnEngineConfiguration();
        dmnEngineConfiguration.setDefaultInputExpressionExpressionLanguage("groovy");
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createProcessEngineConfiguration();
        processEngineConfiguration.setDmnEngineConfiguration(dmnEngineConfiguration);
        this.engine = processEngineConfiguration.buildProcessEngine();
        Assertions.assertThat((String)this.getConfigurationOfDmnEngine().getDefaultInputExpressionExpressionLanguage()).isEqualTo((Object)"groovy");
    }

    @Test
    public void setCustomPostTableExecutionListener() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = (DefaultDmnEngineConfiguration)DmnEngineConfiguration.createDefaultDmnEngineConfiguration();
        DmnDecisionTableEvaluationListener customEvaluationListener = (DmnDecisionTableEvaluationListener)Mockito.mock(DmnDecisionTableEvaluationListener.class);
        ArrayList<DmnDecisionTableEvaluationListener> customListeners = new ArrayList<DmnDecisionTableEvaluationListener>();
        customListeners.add(customEvaluationListener);
        dmnEngineConfiguration.setCustomPostDecisionTableEvaluationListeners(customListeners);
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createProcessEngineConfiguration();
        processEngineConfiguration.setDmnEngineConfiguration(dmnEngineConfiguration);
        this.engine = processEngineConfiguration.buildProcessEngine();
        Assertions.assertThat((List)this.getConfigurationOfDmnEngine().getCustomPostDecisionTableEvaluationListeners()).contains((Object[])new DmnDecisionTableEvaluationListener[]{customEvaluationListener});
    }

    @Test
    public void setFeelEngineFactory() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = (DefaultDmnEngineConfiguration)DmnEngineConfiguration.createDefaultDmnEngineConfiguration();
        FeelEngineFactory feelEngineFactory = (FeelEngineFactory)Mockito.mock(FeelEngineFactory.class);
        dmnEngineConfiguration.setFeelEngineFactory(feelEngineFactory);
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createProcessEngineConfiguration();
        processEngineConfiguration.setDmnEngineConfiguration(dmnEngineConfiguration);
        this.engine = processEngineConfiguration.buildProcessEngine();
        Assertions.assertThat((Object)this.getConfigurationOfDmnEngine().getFeelEngineFactory()).isSameAs((Object)feelEngineFactory);
    }

    @Test
    public void setScriptEngineResolver() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = (DefaultDmnEngineConfiguration)DmnEngineConfiguration.createDefaultDmnEngineConfiguration();
        DmnScriptEngineResolver scriptEngineResolver = (DmnScriptEngineResolver)Mockito.mock(DmnScriptEngineResolver.class);
        dmnEngineConfiguration.setScriptEngineResolver(scriptEngineResolver);
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createProcessEngineConfiguration();
        processEngineConfiguration.setDmnEngineConfiguration(dmnEngineConfiguration);
        this.engine = processEngineConfiguration.buildProcessEngine();
        Assertions.assertThat((Object)this.getConfigurationOfDmnEngine().getScriptEngineResolver()).isSameAs((Object)scriptEngineResolver);
    }

    @Test
    public void setElProvider() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = (DefaultDmnEngineConfiguration)DmnEngineConfiguration.createDefaultDmnEngineConfiguration();
        ElProvider elProvider = (ElProvider)Mockito.mock(ElProvider.class);
        dmnEngineConfiguration.setElProvider(elProvider);
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createProcessEngineConfiguration();
        processEngineConfiguration.setDmnEngineConfiguration(dmnEngineConfiguration);
        this.engine = processEngineConfiguration.buildProcessEngine();
        Assertions.assertThat((Object)this.getConfigurationOfDmnEngine().getElProvider()).isSameAs((Object)elProvider);
    }

    @Test
    public void setProcessEngineElProviderByDefault() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createProcessEngineConfiguration();
        this.engine = processEngineConfiguration.buildProcessEngine();
        Assert.assertEquals(ProcessEngineJuelElProvider.class, this.getConfigurationOfDmnEngine().getElProvider().getClass());
    }

    @Test
    public void setProvidedElProvider() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createProcessEngineConfiguration();
        ElProvider elProvider = (ElProvider)Mockito.mock(ElProvider.class);
        processEngineConfiguration.setDmnElProvider(elProvider);
        this.engine = processEngineConfiguration.buildProcessEngine();
        Assert.assertEquals((Object)elProvider, (Object)this.getConfigurationOfDmnEngine().getElProvider());
    }

    @Test
    public void setProcessEngineScriptEnginesByDefault() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.createProcessEngineConfiguration();
        this.engine = processEngineConfiguration.buildProcessEngine();
        Assert.assertEquals((Object)processEngineConfiguration.getScriptingEngines(), (Object)this.getConfigurationOfDmnEngine().getScriptEngineResolver());
    }

    @Test
    public void setDmnEngineConfigurationOverXmlConfiguration() {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)CONFIGURATION_XML);
        DefaultDmnEngineConfiguration dmnEngineConfiguration = processEngineConfiguration.getDmnEngineConfiguration();
        Assertions.assertThat((Object)dmnEngineConfiguration).isNotNull();
        Assertions.assertThat((String)dmnEngineConfiguration.getDefaultInputExpressionExpressionLanguage()).isEqualTo((Object)"groovy");
        this.engine = processEngineConfiguration.buildProcessEngine();
        Assertions.assertThat((String)this.getConfigurationOfDmnEngine().getDefaultInputExpressionExpressionLanguage()).isEqualTo((Object)"groovy");
    }

    protected ProcessEngineConfigurationImpl createProcessEngineConfiguration() {
        return (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createStandaloneInMemProcessEngineConfiguration().setJdbcUrl("jdbc:h2:mem:eximeebpms" + this.getClass().getSimpleName());
    }

    protected DefaultDmnEngineConfiguration getConfigurationOfDmnEngine() {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)this.engine.getProcessEngineConfiguration();
        DmnEngine dmnEngine = processEngineConfiguration.getDmnEngine();
        return (DefaultDmnEngineConfiguration)dmnEngine.getConfiguration();
    }
}

