/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.cfg;

import java.util.Arrays;
import java.util.Map;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.impl.variable.serializer.JavaObjectSerializer;
import org.eximeebpms.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.eximeebpms.bpm.engine.impl.variable.serializer.VariableSerializerFactory;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.engine.variable.value.ObjectValue;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class FallbackSerializerFactoryTest {
    protected ProcessEngine processEngine;
    protected String deployment;

    @After
    public void tearDown() {
        if (this.processEngine != null) {
            if (this.deployment != null) {
                this.processEngine.getRepositoryService().deleteDeployment(this.deployment, true);
            }
            this.processEngine.close();
        }
    }

    @Test
    public void testFallbackSerializer() {
        ProcessEngineConfigurationImpl engineConfiguration = new StandaloneInMemProcessEngineConfiguration().setJdbcUrl("jdbc:h2:mem:eximeebpms-forceclose").setProcessEngineName("engine-forceclose");
        engineConfiguration.setFallbackSerializerFactory((VariableSerializerFactory)new ExampleSerializerFactory());
        this.processEngine = engineConfiguration.buildProcessEngine();
        this.deployOneTaskProcess(this.processEngine);
        ObjectValue objectValue = (ObjectValue)Variables.objectValue((Object)"foo").serializationDataFormat("example").create();
        ProcessInstance pi = this.processEngine.getRuntimeService().startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValueTyped("var", (TypedValue)objectValue));
        ObjectValue fetchedValue = (ObjectValue)this.processEngine.getRuntimeService().getVariableTyped(pi.getId(), "var", true);
        Assert.assertNotNull((Object)fetchedValue);
        Assert.assertEquals((Object)"example", (Object)fetchedValue.getSerializationDataFormat());
        Assert.assertEquals((Object)"foo", (Object)fetchedValue.getValue());
    }

    @Test
    public void testFallbackSerializerDoesNotOverrideRegularSerializer() {
        ProcessEngineConfigurationImpl engineConfiguration = new StandaloneInMemProcessEngineConfiguration().setJdbcUrl("jdbc:h2:mem:eximeebpms-forceclose").setProcessEngineName("engine-forceclose");
        engineConfiguration.setCustomPreVariableSerializers(Arrays.asList(new TypedValueSerializer[]{new ExampleConstantSerializer()}));
        engineConfiguration.setFallbackSerializerFactory((VariableSerializerFactory)new ExampleSerializerFactory());
        this.processEngine = engineConfiguration.buildProcessEngine();
        this.deployOneTaskProcess(this.processEngine);
        ObjectValue objectValue = (ObjectValue)Variables.objectValue((Object)"foo").serializationDataFormat("example").create();
        ProcessInstance pi = this.processEngine.getRuntimeService().startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValueTyped("var", (TypedValue)objectValue));
        ObjectValue fetchedValue = (ObjectValue)this.processEngine.getRuntimeService().getVariableTyped(pi.getId(), "var", true);
        Assert.assertNotNull((Object)fetchedValue);
        Assert.assertEquals((Object)"example", (Object)fetchedValue.getSerializationDataFormat());
        Assert.assertEquals((Object)"bar", (Object)fetchedValue.getValue());
    }

    protected void deployOneTaskProcess(ProcessEngine engine) {
        this.deployment = engine.getRepositoryService().createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").deploy().getId();
    }

    public static class ExampleSerializerFactory
    implements VariableSerializerFactory {
        public TypedValueSerializer<?> getSerializer(String serializerName) {
            return new ExampleSerializer();
        }

        public TypedValueSerializer<?> getSerializer(TypedValue value) {
            return new ExampleSerializer();
        }
    }

    public static class ExampleSerializer
    extends JavaObjectSerializer {
        public static final String FORMAT = "example";

        public ExampleSerializer() {
            this.serializationDataFormat = FORMAT;
        }

        public String getName() {
            return FORMAT;
        }
    }

    public static class ExampleConstantSerializer
    extends JavaObjectSerializer {
        public static final String DESERIALIZED_VALUE = "bar";

        public ExampleConstantSerializer() {
            this.serializationDataFormat = "example";
        }

        public String getName() {
            return "example";
        }

        protected Object deserializeFromByteArray(byte[] bytes, String objectTypeName) throws Exception {
            return DESERIALIZED_VALUE;
        }
    }
}

