/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.cmmn;

import java.util.HashMap;
import java.util.List;
import org.eximeebpms.bpm.engine.exception.NotAllowedException;
import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.VariableInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class CaseServiceProcessTaskTest
extends PluggableProcessEngineTest {
    protected final String DEFINITION_KEY = "oneProcessTaskCase";
    protected final String PROCESS_TASK_KEY = "PI_ProcessTask_1";

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testStart() {
        String caseInstanceId = this.createCaseInstance("oneProcessTaskCase").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)caseInstanceId, (Object)processInstance.getCaseInstanceId());
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        Assert.assertTrue((boolean)processTask.isActive());
    }

    protected void verifyVariables(String caseInstanceId, List<VariableInstance> result) {
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskCaseWithManualActivation.cmmn", "org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testManualStart() {
        String caseInstanceId = this.createCaseInstance("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        Assert.assertNull((Object)processInstance);
        this.caseService.withCaseExecution(processTaskId).manualStart();
        processInstance = this.queryProcessInstance();
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)caseInstanceId, (Object)processInstance.getCaseInstanceId());
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        Assert.assertTrue((boolean)processTask.isActive());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskCaseWithManualActivation.cmmn", "org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testManualStartWithVariables() {
        String caseInstanceId = this.createCaseInstance("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        Assert.assertNull((Object)processInstance);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(processTaskId).setVariables(variables).manualStart();
        processInstance = this.queryProcessInstance();
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)caseInstanceId, (Object)processInstance.getCaseInstanceId());
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        Assert.assertTrue((boolean)processTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        this.verifyVariables(caseInstanceId, result);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskCaseWithManualActivation.cmmn", "org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testManualStartWithLocalVariable() {
        String caseInstanceId = this.createCaseInstance("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        Assert.assertNull((Object)processInstance);
        this.caseService.withCaseExecution(processTaskId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).manualStart();
        processInstance = this.queryProcessInstance();
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)caseInstanceId, (Object)processInstance.getCaseInstanceId());
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        Assert.assertTrue((boolean)processTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)processTaskId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testReenableAnEnabledProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        Assert.assertNull((Object)processInstance);
        try {
            this.caseService.withCaseExecution(processTaskId).reenable();
            Assert.fail((String)"It should not be possible to re-enable an enabled process task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskWithManualActivationAndOneHumanTaskCase.cmmn", "org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testReenableADisabledProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        Assert.assertNull((Object)processInstance);
        this.caseService.withCaseExecution(processTaskId).disable();
        this.caseService.withCaseExecution(processTaskId).reenable();
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        Assert.assertTrue((boolean)processTask.isEnabled());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testReenableAnActiveProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        try {
            this.caseService.withCaseExecution(processTaskId).reenable();
            Assert.fail((String)"It should not be possible to re-enable an active process task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskWithManualActivationAndOneHumanTaskCase.cmmn"})
    @Test
    public void testDisableAnEnabledProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        Assert.assertNull((Object)processInstance);
        this.caseService.withCaseExecution(processTaskId).disable();
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        Assert.assertTrue((boolean)processTask.isDisabled());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskWithManualActivationAndOneHumanTaskCase.cmmn"})
    @Test
    public void testDisableADisabledProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.caseService.withCaseExecution(processTaskId).disable();
        try {
            this.caseService.withCaseExecution(processTaskId).disable();
            Assert.fail((String)"It should not be possible to disable a already disabled process task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDisableAnActiveProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        try {
            this.caseService.withCaseExecution(processTaskId).disable();
            Assert.fail((String)"It should not be possible to disable an active process task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskWithManualActivationAndOneHumanTaskCase.cmmn"})
    @Test
    public void testManualStartOfADisabledProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.caseService.withCaseExecution(processTaskId).disable();
        try {
            this.caseService.withCaseExecution(processTaskId).manualStart();
            Assert.fail((String)"It should not be possible to start a disabled process task manually.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testManualStartOfAnActiveProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        try {
            this.caseService.withCaseExecution(processTaskId).manualStart();
            Assert.fail((String)"It should not be possible to start an already active process task manually.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testComplete() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        try {
            this.caseService.withCaseExecution(processTaskId).complete();
            Assert.fail((String)"It should not be possible to complete a process task, while the process instance is still running.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testCompleteProcessInstanceShouldCompleteProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        String taskId = this.queryTask().getId();
        this.taskService.complete(taskId);
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        Assert.assertNull((Object)processTask);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testDisableShouldCompleteCaseInstance() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.caseService.withCaseExecution(processTaskId).disable();
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        Assert.assertNull((Object)processTask);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().completed().singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testCompleteAnEnabledProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        try {
            this.caseService.withCaseExecution(processTaskId).complete();
            Assert.fail((String)"Should not be able to complete an enabled process task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskWithManualActivationAndOneHumanTaskCase.cmmn"})
    @Test
    public void testCompleteADisabledProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.caseService.withCaseExecution(processTaskId).disable();
        try {
            this.caseService.withCaseExecution(processTaskId).complete();
            Assert.fail((String)"Should not be able to complete a disabled process task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testClose() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        try {
            this.caseService.withCaseExecution(processTaskId).close();
            Assert.fail((String)"It should not be possible to close a process task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTerminate() {
        this.createCaseInstance("oneProcessTaskCase");
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        Assert.assertTrue((boolean)processTask.isActive());
        this.caseService.withCaseExecution(processTask.getId()).terminate();
        processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        Assert.assertNull((Object)processTask);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTerminateNonFluent() {
        this.createCaseInstance("oneProcessTaskCase");
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        Assert.assertTrue((boolean)processTask.isActive());
        this.caseService.terminateCaseExecution(processTask.getId());
        processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        Assert.assertNull((Object)processTask);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneProcessTaskCaseWithManualActivation.cmmn", "org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testTerminateNonActiveProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        Assert.assertTrue((boolean)processTask.isEnabled());
        try {
            this.caseService.terminateCaseExecution(processTask.getId());
            Assert.fail((String)"It should not be possible to terminate a task.");
        }
        catch (NotAllowedException e) {
            boolean result = e.getMessage().contains("The case execution must be in state 'active' to terminate");
            Assert.assertTrue((boolean)result);
        }
    }

    protected CaseInstance createCaseInstance(String caseDefinitionKey) {
        return this.caseService.withCaseDefinitionByKey(caseDefinitionKey).create();
    }

    protected CaseExecution queryCaseExecutionByActivityId(String activityId) {
        return (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(activityId).singleResult();
    }

    protected ProcessInstance queryProcessInstance() {
        return (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
    }

    protected Task queryTask() {
        return (Task)this.taskService.createTaskQuery().singleResult();
    }
}

