/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.cmmn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.exception.NotFoundException;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.runtime.CaseExecutionCommandBuilder;
import org.eximeebpms.bpm.engine.runtime.CaseExecutionQuery;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;
import org.eximeebpms.bpm.engine.runtime.CaseInstanceQuery;
import org.eximeebpms.bpm.engine.runtime.VariableInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.engine.variable.value.ObjectValue;
import org.eximeebpms.bpm.engine.variable.value.StringValue;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;
import org.junit.Assert;
import org.junit.Test;

public class CaseServiceTest
extends PluggableProcessEngineTest {
    @Test
    public void testCreateCaseInstanceQuery() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assert.assertNotNull((Object)query);
    }

    @Test
    public void testCreateCaseExecutionQuery() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Assert.assertNotNull((Object)query);
    }

    @Test
    public void testWithCaseExecution() {
        CaseExecutionCommandBuilder builder = this.caseService.withCaseExecution("aCaseExecutionId");
        Assert.assertNotNull((Object)builder);
    }

    @Test
    public void testManualStartInvalidCaseExecution() {
        try {
            this.caseService.withCaseExecution("invalid").manualStart();
            Assert.fail();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.caseService.withCaseExecution(null).manualStart();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testCompleteInvalidCaseExeuction() {
        try {
            this.caseService.withCaseExecution("invalid").complete();
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.caseService.withCaseExecution(null).complete();
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testCloseInvalidCaseExeuction() {
        try {
            this.caseService.withCaseExecution("invalid").close();
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.caseService.withCaseExecution(null).close();
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testTerminateInvalidCaseExeuction() {
        try {
            this.caseService.withCaseExecution("invalid").terminate();
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.caseService.withCaseExecution(null).terminate();
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteSetVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteSetVariableTyped() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariable("aVariableName", (Object)Variables.stringValue((String)"abc")).setVariable("anotherVariableName", (Object)Variables.integerValue(null)).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)Variables.stringValue((String)"abc"), (Object)variable.getTypedValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)Variables.integerValue(null), (Object)variable.getTypedValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteSetVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariables(variables).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteSetVariablesTyped() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableMap variables = Variables.createVariables().putValueTyped("aVariableName", (TypedValue)Variables.stringValue((String)"abc")).putValueTyped("anotherVariableName", (TypedValue)Variables.integerValue(null));
        this.caseService.withCaseExecution(caseExecutionId).setVariables((Map)variables).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)Variables.stringValue((String)"abc"), (Object)variable.getTypedValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)Variables.integerValue(null), (Object)variable.getTypedValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteSetVariableAndVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariables(variables).setVariable("aThirdVariable", (Object)123).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)3L, (long)result.size());
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("aThirdVariable")) {
                Assert.assertEquals((Object)"aThirdVariable", (Object)variable.getName());
                Assert.assertEquals((Object)123, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteSetVariableAndVariablesTyped() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableMap variables = Variables.createVariables().putValueTyped("aVariableName", (TypedValue)Variables.stringValue((String)"abc")).putValueTyped("anotherVariableName", (TypedValue)Variables.integerValue(null));
        this.caseService.withCaseExecution(caseExecutionId).setVariables((Map)variables).setVariable("aThirdVariable", (Object)Variables.booleanValue(null)).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)3L, (long)result.size());
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)Variables.stringValue((String)"abc"), (Object)variable.getTypedValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)Variables.integerValue(null), (Object)variable.getTypedValue());
                continue;
            }
            if (variable.getName().equals("aThirdVariable")) {
                Assert.assertEquals((Object)"aThirdVariable", (Object)variable.getName());
                Assert.assertEquals((Object)Variables.booleanValue(null), (Object)variable.getTypedValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteSetVariableLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)caseExecutionId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)caseExecutionId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteSetVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariablesLocal(variables).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)caseExecutionId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)caseExecutionId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteSetVariablesLocalTyped() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableMap variables = Variables.createVariables().putValueTyped("aVariableName", (TypedValue)Variables.stringValue((String)"abc")).putValueTyped("anotherVariableName", (TypedValue)Variables.integerValue(null));
        this.caseService.withCaseExecution(caseExecutionId).setVariablesLocal((Map)variables).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)caseExecutionId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)Variables.stringValue((String)"abc"), (Object)variable.getTypedValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)Variables.integerValue(null), (Object)variable.getTypedValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteSetVariableLocalAndVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariablesLocal(variables).setVariableLocal("aThirdVariable", (Object)123).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)3L, (long)result.size());
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)caseExecutionId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("aThirdVariable")) {
                Assert.assertEquals((Object)"aThirdVariable", (Object)variable.getName());
                Assert.assertEquals((Object)123, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)3L, (long)result.size());
        for (VariableInstance variable : result) {
            Assert.assertEquals((Object)caseExecutionId, (Object)variable.getCaseExecutionId());
            Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("aThirdVariable")) {
                Assert.assertEquals((Object)"aThirdVariable", (Object)variable.getName());
                Assert.assertEquals((Object)123, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteSetVariableAndVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariables(variables).setVariableLocal("aThirdVariable", (Object)123).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        VariableInstance aThirdVariable = (VariableInstance)result.get(0);
        Assert.assertNotNull((Object)aThirdVariable);
        Assert.assertEquals((Object)"aThirdVariable", (Object)aThirdVariable.getName());
        Assert.assertEquals((Object)123, (Object)aThirdVariable.getValue());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)3L, (long)result.size());
        for (VariableInstance variable : result) {
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseExecutionId());
                Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseExecutionId());
                Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("aThirdVariable")) {
                Assert.assertEquals((Object)caseExecutionId, (Object)variable.getCaseExecutionId());
                Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
                Assert.assertEquals((Object)"aThirdVariable", (Object)variable.getName());
                Assert.assertEquals((Object)123, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteRemoveVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).removeVariable("aVariableName").removeVariable("anotherVariableName").execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteRemoveVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add("aVariableName");
        variableNames.add("anotherVariableName");
        this.caseService.withCaseExecution(caseExecutionId).removeVariables(variableNames).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteRemoveVariableAndVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).setVariable("aThirdVariable", (Object)123).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add("aVariableName");
        variableNames.add("anotherVariableName");
        this.caseService.withCaseExecution(caseExecutionId).removeVariables(variableNames).removeVariable("aThirdVariable").execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteRemoveVariableLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        this.caseService.withCaseExecution(caseExecutionId).removeVariableLocal("aVariableName").removeVariableLocal("anotherVariableName").execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteRemoveVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add("aVariableName");
        variableNames.add("anotherVariableName");
        this.caseService.withCaseExecution(caseExecutionId).removeVariablesLocal(variableNames).execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteRemoveVariableLocalAndVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).setVariableLocal("aThirdVariable", (Object)123).execute();
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add("aVariableName");
        variableNames.add("anotherVariableName");
        this.caseService.withCaseExecution(caseExecutionId).removeVariablesLocal(variableNames).removeVariableLocal("aThirdVariable").execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteRemoveVariableAndVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).setVariableLocal("aThirdVariable", (Object)123).execute();
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add("aVariableName");
        variableNames.add("anotherVariableName");
        this.caseService.withCaseExecution(caseExecutionId).removeVariables(variableNames).removeVariableLocal("aThirdVariable").execute();
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteRemoveAndSetSameVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).removeVariable("aVariableName").setVariable("aVariableName", (Object)"xyz").execute();
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("Cannot set and remove a variable with the same variable name: 'aVariableName' within a command.", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testExecuteRemoveAndSetSameLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"xyz").removeVariableLocal("aVariableName").execute();
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("Cannot set and remove a variable with the same variable name: 'aVariableName' within a command.", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testGetVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        Map variables = this.caseService.getVariables(caseExecutionId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        Assert.assertEquals((Object)"abc", variables.get("aVariableName"));
        Assert.assertEquals((Object)999, variables.get("anotherVariableName"));
        Assert.assertEquals((Object)variables, (Object)this.caseService.getVariablesTyped(caseExecutionId, true));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testGetVariablesTyped() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableMap variables = this.caseService.getVariablesTyped(caseExecutionId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        Assert.assertEquals((Object)"abc", (Object)variables.get((Object)"aVariableName"));
        Assert.assertEquals((Object)999, (Object)variables.get((Object)"anotherVariableName"));
        Assert.assertEquals((Object)variables, (Object)this.caseService.getVariablesTyped(caseExecutionId, true));
    }

    @Test
    public void testGetVariablesInvalidCaseExecutionId() {
        try {
            this.caseService.getVariables("invalid");
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.caseService.getVariables(null);
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testGetVariablesWithVariableNames() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).setVariable("thirVariable", (Object)"xyz").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        ArrayList<String> names = new ArrayList<String>();
        names.add("aVariableName");
        names.add("anotherVariableName");
        Map variables = this.caseService.getVariables(caseExecutionId, names);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        Assert.assertEquals((Object)"abc", variables.get("aVariableName"));
        Assert.assertEquals((Object)999, variables.get("anotherVariableName"));
        Assert.assertEquals((Object)variables, (Object)this.caseService.getVariables(caseExecutionId, names));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testGetVariablesWithVariableNamesTyped() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).setVariable("thirVariable", (Object)"xyz").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        ArrayList<String> names = new ArrayList<String>();
        names.add("aVariableName");
        names.add("anotherVariableName");
        VariableMap variables = this.caseService.getVariablesTyped(caseExecutionId, names, true);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        Assert.assertEquals((Object)"abc", (Object)variables.get((Object)"aVariableName"));
        Assert.assertEquals((Object)999, (Object)variables.get((Object)"anotherVariableName"));
        Assert.assertEquals((Object)variables, (Object)this.caseService.getVariables(caseExecutionId, names));
    }

    @Test
    public void testGetVariablesWithVariablesNamesInvalidCaseExecutionId() {
        try {
            this.caseService.getVariables("invalid", null);
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.caseService.getVariables(null, null);
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testGetVariablesLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        Map variables = this.caseService.getVariablesLocal(caseExecutionId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        Assert.assertEquals((Object)"abc", variables.get("aVariableName"));
        Assert.assertEquals((Object)999, variables.get("anotherVariableName"));
        Assert.assertEquals((Object)variables, (Object)this.caseService.getVariablesLocal(caseExecutionId));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testGetVariablesLocalTyped() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        VariableMap variables = this.caseService.getVariablesLocalTyped(caseExecutionId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        Assert.assertEquals((Object)"abc", (Object)variables.get((Object)"aVariableName"));
        Assert.assertEquals((Object)999, (Object)variables.get((Object)"anotherVariableName"));
        Assert.assertEquals((Object)variables, (Object)this.caseService.getVariablesLocalTyped(caseExecutionId, true));
    }

    @Test
    public void testGetVariablesLocalInvalidCaseExecutionId() {
        try {
            this.caseService.getVariablesLocal("invalid");
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.caseService.getVariablesLocal(null);
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testGetVariablesLocalWithVariableNames() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        ArrayList<String> names = new ArrayList<String>();
        names.add("aVariableName");
        names.add("anotherVariableName");
        Map variables = this.caseService.getVariablesLocal(caseExecutionId, names);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        Assert.assertEquals((Object)"abc", variables.get("aVariableName"));
        Assert.assertEquals((Object)999, variables.get("anotherVariableName"));
        Assert.assertEquals((Object)variables, (Object)this.caseService.getVariablesLocal(caseExecutionId, names));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testGetVariablesLocalWithVariableNamesTyped() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        ArrayList<String> names = new ArrayList<String>();
        names.add("aVariableName");
        names.add("anotherVariableName");
        VariableMap variables = this.caseService.getVariablesLocalTyped(caseExecutionId, names, true);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)2L, (long)variables.size());
        Assert.assertEquals((Object)"abc", (Object)variables.get((Object)"aVariableName"));
        Assert.assertEquals((Object)999, (Object)variables.get((Object)"anotherVariableName"));
        Assert.assertEquals((Object)variables, (Object)this.caseService.getVariablesLocal(caseExecutionId, names));
    }

    @Test
    public void testGetVariablesLocalWithVariablesNamesInvalidCaseExecutionId() {
        try {
            this.caseService.getVariablesLocal("invalid", null);
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.caseService.getVariablesLocal(null, null);
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testGetVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).setVariable("thirVariable", (Object)"xyz").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        Object value = this.caseService.getVariable(caseExecutionId, "aVariableName");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"abc", (Object)value);
    }

    @Test
    public void testGetVariableInvalidCaseExecutionId() {
        try {
            this.caseService.getVariable("invalid", "aVariableName");
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.caseService.getVariable(null, "aVariableName");
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testGetVariableLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).execute();
        Object value = this.caseService.getVariableLocal(caseExecutionId, "aVariableName");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"abc", (Object)value);
    }

    @Test
    public void testGetVariableLocalInvalidCaseExecutionId() {
        try {
            this.caseService.getVariableLocal("invalid", "aVariableName");
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.caseService.getVariableLocal(null, "aVariableName");
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testGetVariableTyped() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).setVariable("aSerializedObject", (Object)Variables.objectValue(Arrays.asList("1", "2")).create()).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        StringValue stringValue = (StringValue)this.caseService.getVariableTyped(caseExecutionId, "aVariableName");
        ObjectValue objectValue = (ObjectValue)this.caseService.getVariableTyped(caseExecutionId, "aSerializedObject");
        ObjectValue serializedObjectValue = (ObjectValue)this.caseService.getVariableTyped(caseExecutionId, "aSerializedObject", false);
        Assert.assertNotNull((Object)stringValue.getValue());
        Assert.assertNotNull((Object)objectValue.getValue());
        Assert.assertTrue((boolean)objectValue.isDeserialized());
        Assert.assertEquals(Arrays.asList("1", "2"), (Object)objectValue.getValue());
        Assert.assertFalse((boolean)serializedObjectValue.isDeserialized());
        Assert.assertNotNull((Object)serializedObjectValue.getValueSerialized());
    }

    @Test
    public void testGetVariableTypedInvalidCaseExecutionId() {
        try {
            this.caseService.getVariableTyped("invalid", "aVariableName");
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.caseService.getVariableTyped(null, "aVariableName");
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testSetVariable() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneTaskCase").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.setVariable(caseExecutionId, "aVariableName", (Object)"abc");
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseInstanceId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        VariableInstance variable = (VariableInstance)result.get(0);
        Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
        Assert.assertEquals((Object)"abc", (Object)variable.getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testSetVariables() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneTaskCase").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 123);
        this.caseService.setVariables(caseExecutionId, variables);
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseInstanceId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variable : result) {
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseExecutionId());
                Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseExecutionId());
                Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)123, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testSetVariableLocal() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneTaskCase").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.setVariableLocal(caseExecutionId, "aVariableName", (Object)"abc");
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseInstanceId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        VariableInstance variable = (VariableInstance)result.get(0);
        Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
        Assert.assertEquals((Object)"abc", (Object)variable.getValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testSetVariablesLocal() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneTaskCase").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 123);
        this.caseService.setVariablesLocal(caseExecutionId, variables);
        List result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseInstanceId}).list();
        Assert.assertTrue((boolean)result.isEmpty());
        result = this.runtimeService.createVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variable : result) {
            if (variable.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)caseExecutionId, (Object)variable.getCaseExecutionId());
                Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
                Assert.assertEquals((Object)"aVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)caseExecutionId, (Object)variable.getCaseExecutionId());
                Assert.assertEquals((Object)caseInstanceId, (Object)variable.getCaseInstanceId());
                Assert.assertEquals((Object)"anotherVariableName", (Object)variable.getName());
                Assert.assertEquals((Object)123, (Object)variable.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testGetVariableTypedLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).setVariableLocal("aSerializedObject", (Object)Variables.objectValue(Arrays.asList("1", "2")).create()).execute();
        StringValue stringValue = (StringValue)this.caseService.getVariableLocalTyped(caseExecutionId, "aVariableName");
        ObjectValue objectValue = (ObjectValue)this.caseService.getVariableLocalTyped(caseExecutionId, "aSerializedObject");
        ObjectValue serializedObjectValue = (ObjectValue)this.caseService.getVariableLocalTyped(caseExecutionId, "aSerializedObject", false);
        Assert.assertNotNull((Object)stringValue.getValue());
        Assert.assertNotNull((Object)objectValue.getValue());
        Assert.assertTrue((boolean)objectValue.isDeserialized());
        Assert.assertEquals(Arrays.asList("1", "2"), (Object)objectValue.getValue());
        Assert.assertFalse((boolean)serializedObjectValue.isDeserialized());
        Assert.assertNotNull((Object)serializedObjectValue.getValueSerialized());
    }

    @Test
    public void testGetVariableLocalTypedInvalidCaseExecutionId() {
        try {
            this.caseService.getVariableLocalTyped("invalid", "aVariableName");
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.caseService.getVariableLocalTyped(null, "aVariableName");
            Assert.fail((String)"The case execution should not be found.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testRemoveVariable() {
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("aVariableName", (Object)"abc").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.removeVariable(caseExecutionId, "aVariableName");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testRemoveVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariable", "abc");
        variables.put("anotherVariable", 123);
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariables(variables).setVariable("aThirdVariable", (Object)"def").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.removeVariables(caseExecutionId, variables.keySet());
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"aThirdVariable", (Object)variable.getName());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testRemoveVariableLocal() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneTaskCase").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.setVariableLocal(caseExecutionId, "aVariableName", (Object)"abc");
        this.caseService.removeVariableLocal(caseInstanceId, "aVariableName");
        Assert.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().count());
        this.caseService.removeVariableLocal(caseExecutionId, "aVariableName");
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testRemoveVariablesLocal() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneTaskCase").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariable", "abc");
        variables.put("anotherVariable", 123);
        this.caseService.setVariablesLocal(caseExecutionId, variables);
        this.caseService.setVariableLocal(caseExecutionId, "aThirdVariable", (Object)"def");
        this.caseService.removeVariablesLocal(caseInstanceId, variables.keySet());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createVariableInstanceQuery().count());
        this.caseService.removeVariablesLocal(caseExecutionId, variables.keySet());
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"aThirdVariable", (Object)variable.getName());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/loan-application.cmmn"})
    @Test
    public void testCreateCaseInstanceById() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("loanApplication").singleResult();
        Assert.assertNotNull((Object)caseDefinition);
        CaseInstance caseInstance = this.caseService.withCaseDefinition(caseDefinition.getId()).create();
        Assert.assertNotNull((Object)caseInstance);
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstance.getId()).singleResult();
        Assert.assertNotNull((Object)instance);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/loan-application.cmmn"})
    @Test
    public void testCreateCaseInstanceByKey() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("loanApplication").singleResult();
        Assert.assertNotNull((Object)caseDefinition);
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey(caseDefinition.getKey()).create();
        Assert.assertNotNull((Object)caseInstance);
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstance.getId()).singleResult();
        Assert.assertNotNull((Object)instance);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/loan-application.cmmn"})
    @Test
    public void testCaseExecutionQuery() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("loanApplication").singleResult();
        Assert.assertNotNull((Object)caseDefinition);
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey(caseDefinition.getKey()).create();
        Assert.assertNotNull((Object)caseInstance);
        List caseExecutions = this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstance.getId()).list();
        Assert.assertEquals((long)3L, (long)caseExecutions.size());
        CaseExecution casePlanModelExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("CasePlanModel_1").singleResult();
        Assert.assertNotNull((Object)casePlanModelExecution);
        CaseExecution stageExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult();
        Assert.assertNotNull((Object)stageExecution);
        CaseExecution humanTaskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_6").singleResult();
        Assert.assertNotNull((Object)humanTaskExecution);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/loan-application.cmmn"})
    @Test
    public void testCaseInstanceQuery() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("loanApplication").singleResult();
        Assert.assertNotNull((Object)caseDefinition);
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey(caseDefinition.getKey()).create();
        Assert.assertNotNull((Object)caseInstance);
        List caseInstances = this.caseService.createCaseInstanceQuery().active().list();
        Assert.assertEquals((long)1L, (long)caseInstances.size());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testGetVariablesByEmptyList() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        Map variables = this.caseService.getVariables(caseInstanceId, new ArrayList());
        Assert.assertNotNull((Object)variables);
        Assert.assertTrue((boolean)variables.isEmpty());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testGetVariablesTypedByEmptyList() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        VariableMap variables = this.caseService.getVariablesTyped(caseInstanceId, new ArrayList(), false);
        Assert.assertNotNull((Object)variables);
        Assert.assertTrue((boolean)variables.isEmpty());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testGetVariablesLocalByEmptyList() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        Map variables = this.caseService.getVariablesLocal(caseInstanceId, new ArrayList());
        Assert.assertNotNull((Object)variables);
        Assert.assertTrue((boolean)variables.isEmpty());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testGetVariablesLocalTypedByEmptyList() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        VariableMap variables = this.caseService.getVariablesLocalTyped(caseInstanceId, new ArrayList(), false);
        Assert.assertNotNull((Object)variables);
        Assert.assertTrue((boolean)variables.isEmpty());
    }
}

