/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.FilterService;
import org.eximeebpms.bpm.engine.filter.Filter;
import org.eximeebpms.bpm.engine.impl.persistence.entity.FilterEntity;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class FilterPropertiesTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected FilterService filterService;
    protected Filter filter;
    protected String nestedJsonObject = "{\"id\":\"nested\"}";
    protected String nestedJsonArray = "[\"a\",\"b\"]";

    @Before
    public void setUp() {
        this.filterService = this.engineRule.getFilterService();
        this.filter = this.filterService.newTaskFilter("name").setOwner("owner").setProperties(new HashMap());
    }

    @After
    public void tearDown() throws Exception {
        for (Filter filter : this.filterService.createFilterQuery().list()) {
            this.filterService.deleteFilter(filter.getId());
        }
    }

    @Test
    public void testPropertiesFromNull() {
        this.filter.setProperties(null);
        Assert.assertNull((Object)this.filter.getProperties());
    }

    @Test
    public void testPropertiesInternalFromNull() {
        Filter noPropsFilter = this.filterService.newTaskFilter("no props filter").setOwner("demo").setProperties(null);
        this.filterService.saveFilter(noPropsFilter);
        FilterEntity noPropsFilterEntity = (FilterEntity)this.filterService.createTaskFilterQuery().filterOwner("demo").singleResult();
        MatcherAssert.assertThat((Object)noPropsFilterEntity.getPropertiesInternal(), (Matcher)CoreMatchers.is((Object)"{}"));
    }

    @Test
    public void testPropertiesFromMap() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("color", "#123456");
        properties.put("priority", 42);
        properties.put("userDefined", true);
        properties.put("object", this.nestedJsonObject);
        properties.put("array", this.nestedJsonArray);
        this.filter.setProperties(properties);
        this.assertTestProperties();
    }

    @Test
    public void testNullProperty() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("null", null);
        this.filter.setProperties(properties);
        this.filterService.saveFilter(this.filter);
        this.filter = this.filterService.getFilter(this.filter.getId());
        Map persistentProperties = this.filter.getProperties();
        Assert.assertEquals((long)1L, (long)persistentProperties.size());
        Assert.assertTrue((boolean)persistentProperties.containsKey("null"));
        Assert.assertNull(persistentProperties.get("null"));
    }

    @Test
    public void testMapContainingListProperty() {
        Map<String, List<String>> properties = Collections.singletonMap("foo", Collections.singletonList("bar"));
        this.filter.setProperties(properties);
        this.filterService.saveFilter(this.filter);
        this.filter = this.filterService.getFilter(this.filter.getId());
        Map deserialisedProperties = this.filter.getProperties();
        List list = (List)deserialisedProperties.get("foo");
        Object string = list.get(0);
        MatcherAssert.assertThat((Object)deserialisedProperties.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(string, (Matcher)CoreMatchers.instanceOf(String.class));
        MatcherAssert.assertThat((Object)string.toString(), (Matcher)CoreMatchers.is((Object)"bar"));
    }

    @Test
    public void testMapContainingMapProperty() {
        Map<String, Map<String, String>> properties = Collections.singletonMap("foo", Collections.singletonMap("bar", "foo"));
        this.filter.setProperties(properties);
        this.filterService.saveFilter(this.filter);
        this.filter = this.filterService.getFilter(this.filter.getId());
        Map deserialisedProperties = this.filter.getProperties();
        Map map = (Map)deserialisedProperties.get("foo");
        Object string = map.get("bar");
        MatcherAssert.assertThat((Object)deserialisedProperties.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)string.toString(), (Matcher)CoreMatchers.is((Object)"foo"));
    }

    @Test
    public void testMapContainingMapContainingListProperty() {
        Map<String, Map<String, List<String>>> properties = Collections.singletonMap("foo", Collections.singletonMap("bar", Collections.singletonList("foo")));
        this.filter.setProperties(properties);
        this.filterService.saveFilter(this.filter);
        this.filter = this.filterService.getFilter(this.filter.getId());
        Map deserialisedProperties = this.filter.getProperties();
        Map map = (Map)deserialisedProperties.get("foo");
        List list = (List)map.get("bar");
        Object string = list.get(0);
        MatcherAssert.assertThat((Object)deserialisedProperties.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)string.toString(), (Matcher)CoreMatchers.is((Object)"foo"));
    }

    @Test
    public void testMapContainingListContainingMapProperty_DeserializePrimitives() {
        HashMap<String, Object> primitives = new HashMap<String, Object>();
        primitives.put("string", "aStringValue");
        primitives.put("int", 47);
        primitives.put("intOutOfRange", 0x80000000L);
        primitives.put("long", Long.MAX_VALUE);
        primitives.put("double", 3.14159265359);
        primitives.put("boolean", true);
        primitives.put("null", null);
        Map properties = Collections.singletonMap("foo", Collections.singletonList(primitives));
        this.filter.setProperties(properties);
        this.filterService.saveFilter(this.filter);
        this.filter = this.filterService.getFilter(this.filter.getId());
        Map deserialisedProperties = this.filter.getProperties();
        List list = (List)deserialisedProperties.get("foo");
        Map map = (Map)list.get(0);
        MatcherAssert.assertThat((Object)deserialisedProperties.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(map.get("string"), (Matcher)CoreMatchers.is((Object)"aStringValue"));
        MatcherAssert.assertThat(map.get("int"), (Matcher)CoreMatchers.is((Object)47));
        MatcherAssert.assertThat(map.get("intOutOfRange"), (Matcher)CoreMatchers.is((Object)0x80000000L));
        MatcherAssert.assertThat(map.get("long"), (Matcher)CoreMatchers.is((Object)Long.MAX_VALUE));
        MatcherAssert.assertThat(map.get("double"), (Matcher)CoreMatchers.is((Object)3.14159265359));
        MatcherAssert.assertThat(map.get("boolean"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(map.get("null"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testMapContainingMapContainingListProperty_DeserializePrimitives() {
        ArrayList<Object> primitives = new ArrayList<Object>();
        primitives.add("aStringValue");
        primitives.add(47);
        primitives.add(0x80000000L);
        primitives.add(Long.MAX_VALUE);
        primitives.add(3.14159265359);
        primitives.add(true);
        primitives.add(null);
        Map properties = Collections.singletonMap("foo", Collections.singletonMap("bar", primitives));
        this.filter.setProperties(properties);
        this.filterService.saveFilter(this.filter);
        this.filter = this.filterService.getFilter(this.filter.getId());
        Map deserialisedProperties = this.filter.getProperties();
        List list = (List)((Map)deserialisedProperties.get("foo")).get("bar");
        MatcherAssert.assertThat((Object)deserialisedProperties.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(list.get(0), (Matcher)CoreMatchers.is((Object)"aStringValue"));
        MatcherAssert.assertThat(list.get(1), (Matcher)CoreMatchers.is((Object)47));
        MatcherAssert.assertThat(list.get(2), (Matcher)CoreMatchers.is((Object)0x80000000L));
        MatcherAssert.assertThat(list.get(3), (Matcher)CoreMatchers.is((Object)Long.MAX_VALUE));
        MatcherAssert.assertThat(list.get(4), (Matcher)CoreMatchers.is((Object)3.14159265359));
        MatcherAssert.assertThat(list.get(5), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(list.get(6), (Matcher)CoreMatchers.nullValue());
    }

    protected void assertTestProperties() {
        this.filterService.saveFilter(this.filter);
        this.filter = this.filterService.getFilter(this.filter.getId());
        Map properties = this.filter.getProperties();
        Assert.assertEquals((long)5L, (long)properties.size());
        Assert.assertEquals((Object)"#123456", properties.get("color"));
        Assert.assertEquals((Object)42, properties.get("priority"));
        Assert.assertEquals((Object)true, properties.get("userDefined"));
        Assert.assertEquals((Object)this.nestedJsonObject, properties.get("object"));
        Assert.assertEquals((Object)this.nestedJsonArray, properties.get("array"));
    }
}

