/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.history;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstance;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstance;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.repository.DecisionDefinition;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="activity")
public class BulkHistoryDeleteCmmnDisabledTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setCmmnEnabled(false));
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    private RuntimeService runtimeService;
    private HistoryService historyService;

    @Before
    public void createProcessEngine() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @After
    public void clearDatabase() {
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = BulkHistoryDeleteCmmnDisabledTest.this.engineRule.getManagementService().createJobQuery().list();
                if (jobs.size() > 0) {
                    Assert.assertEquals((long)1L, (long)jobs.size());
                    String jobId = ((Job)jobs.get(0)).getId();
                    commandContext.getJobManager().deleteJob((JobEntity)jobs.get(0));
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                }
                commandContext.getMeterLogManager().deleteAll();
                return null;
            }
        });
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
        }
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        for (HistoricDecisionInstance historicDecisionInstance : historicDecisionInstances) {
            this.historyService.deleteHistoricDecisionInstanceByInstanceId(historicDecisionInstance.getId());
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn"})
    public void historyCleanUpWithDisabledCmmn() {
        this.prepareHistoricProcesses(5);
        this.prepareHistoricDecisions(5);
        ClockUtil.setCurrentTime((Date)new Date());
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.engineRule.getManagementService().executeJob(jobId);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
    }

    private void prepareHistoricProcesses(int instanceCount) {
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)-6));
        for (int i = 0; i < instanceCount; ++i) {
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            processInstanceIds.add(processInstance.getId());
        }
        List processDefinitions = this.engineRule.getRepositoryService().createProcessDefinitionQuery().list();
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        this.engineRule.getRepositoryService().updateProcessDefinitionHistoryTimeToLive(((ProcessDefinition)processDefinitions.get(0)).getId(), Integer.valueOf(5));
        this.runtimeService.deleteProcessInstances(processInstanceIds, null, true, true);
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }

    private void prepareHistoricDecisions(int instanceCount) {
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        List decisionDefinitions = this.engineRule.getRepositoryService().createDecisionDefinitionQuery().decisionDefinitionKey("decision").list();
        Assert.assertEquals((long)1L, (long)decisionDefinitions.size());
        this.engineRule.getRepositoryService().updateDecisionDefinitionHistoryTimeToLive(((DecisionDefinition)decisionDefinitions.get(0)).getId(), Integer.valueOf(5));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)-6));
        for (int i = 0; i < instanceCount; ++i) {
            this.engineRule.getDecisionService().evaluateDecisionByKey("decision").variables((Map)Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723)).evaluate();
        }
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }
}

