/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.DecisionService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@RequiredHistoryLevel(value="full")
public class BulkHistoryDeleteDecisionInstancesAuthorizationTest {
    public static final String DECISION = "decision";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    private HistoryService historyService;
    private DecisionService decisionService;
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Before
    public void init() {
        this.historyService = this.engineRule.getHistoryService();
        this.decisionService = this.engineRule.getDecisionService();
        this.authRule.createUserAndGroup("demo", "groupId");
    }

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.DECISION_DEFINITION, "*", "demo", new Permission[]{Permissions.DELETE_HISTORY})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.DECISION_DEFINITION, "someId", "demo", new Permission[]{Permissions.DELETE_HISTORY})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.DECISION_DEFINITION, "*", "demo", new Permission[]{Permissions.DELETE_HISTORY})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.DECISION_DEFINITION, "*", "demo", new Permission[]{Permissions.DELETE_HISTORY})).succeeds());
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn"})
    public void testCleanupHistory() {
        List<String> ids = this.prepareHistoricDecisions();
        this.authRule.init(this.scenario).withUser("demo").start();
        this.historyService.deleteHistoricDecisionInstancesBulk(ids);
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION).count());
        }
    }

    private List<String> prepareHistoricDecisions() {
        for (int i = 0; i < 5; ++i) {
            this.decisionService.evaluateDecisionByKey(DECISION).variables((Map)this.createVariables()).evaluate();
        }
        List decisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        ArrayList<String> decisionInstanceIds = new ArrayList<String>();
        for (HistoricDecisionInstance decisionInstance : decisionInstances) {
            decisionInstanceIds.add(decisionInstance.getId());
        }
        return decisionInstanceIds;
    }

    protected VariableMap createVariables() {
        return Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723);
    }
}

