/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.history;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class HistoryCleanupDisabledOnBootstrapTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
        configuration.setJdbcUrl("jdbc:h2:mem:" + HistoryCleanupDisabledOnBootstrapTest.class.getSimpleName());
        configuration.setHistoryCleanupEnabled(false);
        configuration.setHistoryCleanupBatchWindowStartTime("12:00");
        configuration.setDatabaseSchemaUpdate("create-drop");
    });
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public HistoryService historyService;
    public static ProcessEngineConfigurationImpl engineConfiguration;

    @Before
    public void assignServices() {
        this.historyService = this.engineRule.getHistoryService();
        engineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @After
    public void resetConfig() {
        engineConfiguration.setHistoryCleanupEnabled(true);
    }

    @Test
    public void shouldNotCreateJobs() {
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        Assertions.assertThat((List)historyCleanupJobs).isEmpty();
    }
}

