/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.history.removaltime;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.authorization.Authorization;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.externaltask.ExternalTask;
import org.eximeebpms.bpm.engine.externaltask.LockedExternalTask;
import org.eximeebpms.bpm.engine.history.HistoricActivityInstance;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInputInstance;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstance;
import org.eximeebpms.bpm.engine.history.HistoricDecisionOutputInstance;
import org.eximeebpms.bpm.engine.history.HistoricDetail;
import org.eximeebpms.bpm.engine.history.HistoricExternalTaskLog;
import org.eximeebpms.bpm.engine.history.HistoricIdentityLinkLog;
import org.eximeebpms.bpm.engine.history.HistoricIncident;
import org.eximeebpms.bpm.engine.history.HistoricJobLog;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstance;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstance;
import org.eximeebpms.bpm.engine.history.HistoricVariableInstance;
import org.eximeebpms.bpm.engine.history.UserOperationLogEntry;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricDecisionInputInstanceEntity;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricDecisionOutputInstanceEntity;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricExternalTaskLogEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.eximeebpms.bpm.engine.repository.DeploymentWithDefinitions;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Attachment;
import org.eximeebpms.bpm.engine.task.Comment;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.api.history.removaltime.AbstractRemovalTimeTest;
import org.eximeebpms.bpm.engine.test.bpmn.async.FailingDelegate;
import org.eximeebpms.bpm.engine.test.dmn.businessruletask.TestPojo;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.CallActivityBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ProcessBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Test;

public class HistoricRootProcessInstanceTest
extends AbstractRemovalTimeTest {
    protected final String CALLED_PROCESS_KEY = "calledProcess";
    protected final BpmnModelInstance CALLED_PROCESS = ((ServiceTaskBuilder)((ServiceTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"calledProcess").camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().userTask("userTask").name("userTask")).camundaAssignee("foo")).serviceTask().camundaAsyncBefore()).camundaClass(FailingDelegate.class.getName())).endEvent().done();
    protected final String CALLING_PROCESS_KEY = "callingProcess";
    protected final BpmnModelInstance CALLING_PROCESS = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("calledProcess")).endEvent().done();

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldResolveHistoricDecisionInstance() {
        this.testRule.deploy(((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().businessRuleTask().camundaDecisionRef("dish-decision")).endEvent().done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicDecisionInstances.size(), (Matcher)Is.is((Object)3));
        MatcherAssert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
        MatcherAssert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
        MatcherAssert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldResolveHistoricDecisionInputInstance() {
        this.testRule.deploy(((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().businessRuleTask().camundaDecisionRef("dish-decision")).endEvent().done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        List historicDecisionInputInstances = historicDecisionInstance.getInputs();
        MatcherAssert.assertThat((Object)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
        MatcherAssert.assertThat((Object)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(1)).getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldNotResolveHistoricDecisionInputInstance() {
        this.decisionService.evaluateDecisionTableByKey("dish-decision", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        List historicDecisionInputInstances = historicDecisionInstance.getInputs();
        MatcherAssert.assertThat((Object)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRootProcessInstanceId(), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(1)).getRootProcessInstanceId(), (Matcher)IsNull.nullValue());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldResolveHistoricDecisionOutputInstance() {
        this.testRule.deploy(((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().businessRuleTask().camundaDecisionRef("dish-decision")).endEvent().done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        List historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        MatcherAssert.assertThat((Object)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldNotResolveHistoricDecisionOutputInstance() {
        this.decisionService.evaluateDecisionTableByKey("dish-decision", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        List historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        MatcherAssert.assertThat((Object)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRootProcessInstanceId(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldResolveHistoricProcessInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().activeActivityIdIn(new String[]{"userTask"}).singleResult();
        MatcherAssert.assertThat((Object)historicProcessInstance, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)historicProcessInstance.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldResolveHistoricActivityInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("userTask").singleResult();
        MatcherAssert.assertThat((Object)historicActivityInstance, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)historicActivityInstance.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldResolveHistoricTaskInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskName("userTask").singleResult();
        MatcherAssert.assertThat((Object)historicTaskInstance, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)historicTaskInstance.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldNotResolveHistoricTaskInstance() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        MatcherAssert.assertThat((Object)historicTaskInstance, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)historicTaskInstance.getRootProcessInstanceId(), (Matcher)IsNull.nullValue());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    public void shouldResolveHistoricVariableInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("aVariableName", (Object)Variables.stringValue((String)"aVariableValue")));
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        MatcherAssert.assertThat((Object)historicVariableInstance, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)historicVariableInstance.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldResolveHistoricDetailByVariableInstanceUpdate() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("aVariableName", (Object)Variables.stringValue((String)"aVariableValue")));
        this.runtimeService.setVariable(processInstance.getId(), "aVariableName", (Object)Variables.stringValue((String)"anotherVariableValue"));
        List historicDetails = this.historyService.createHistoricDetailQuery().variableUpdates().list();
        MatcherAssert.assertThat((Object)historicDetails.size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)((HistoricDetail)historicDetails.get(0)).getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
        MatcherAssert.assertThat((Object)((HistoricDetail)historicDetails.get(1)).getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldResolveHistoricDetailByFormProperty() {
        this.testRule.deploy(this.CALLING_PROCESS);
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.CALLED_PROCESS);
        String processDefinitionId = ((ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0)).getId();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("aFormProperty", "aFormPropertyValue");
        ProcessInstance processInstance = this.formService.submitStartForm(processDefinitionId, properties);
        HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().formFields().singleResult();
        MatcherAssert.assertThat((Object)historicDetail, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)historicDetail.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldResolveIncident() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List historicIncidents = this.historyService.createHistoricIncidentQuery().list();
        MatcherAssert.assertThat((Object)historicIncidents.size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)((HistoricIncident)historicIncidents.get(0)).getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
        MatcherAssert.assertThat((Object)((HistoricIncident)historicIncidents.get(1)).getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldNotResolveStandaloneIncident() {
        this.testRule.deploy(this.CALLED_PROCESS);
        this.repositoryService.suspendProcessDefinitionByKey("calledProcess", true, new Date());
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        MatcherAssert.assertThat((Object)historicIncident, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)historicIncident.getRootProcessInstanceId(), (Matcher)IsNull.nullValue());
        this.clearJobLog(jobId);
        this.clearHistoricIncident(historicIncident);
    }

    @Test
    public void shouldResolveExternalTaskLog() {
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().serviceTask().camundaExternalTask("anExternalTaskTopic")).endEvent().done());
        this.testRule.deploy(((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("calledProcess")).endEvent().done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        HistoricExternalTaskLog ExternalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().singleResult();
        MatcherAssert.assertThat((Object)ExternalTaskLog, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)ExternalTaskLog.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getRootProcessInstanceId()));
    }

    @Test
    public void shouldResolveJobLog() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List jobLog = this.historyService.createHistoricJobLogQuery().list();
        MatcherAssert.assertThat((Object)jobLog.size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)((HistoricJobLog)jobLog.get(0)).getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
        MatcherAssert.assertThat((Object)((HistoricJobLog)jobLog.get(1)).getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldNotResolveJobLog() {
        this.testRule.deploy(this.CALLED_PROCESS);
        this.repositoryService.suspendProcessDefinitionByKey("calledProcess", true, new Date());
        HistoricJobLog jobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().singleResult();
        MatcherAssert.assertThat((Object)jobLog, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)jobLog.getRootProcessInstanceId(), (Matcher)IsNull.nullValue());
        this.managementService.deleteJob(jobLog.getJobId());
        this.clearJobLog(jobLog.getJobId());
    }

    @Test
    public void shouldResolveUserOperationLog_SetJobRetries() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aUserId");
        this.managementService.setJobRetries(jobId, 65);
        this.identityService.clearAuthentication();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        MatcherAssert.assertThat((Object)userOperationLog, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)userOperationLog.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldResolveUserOperationLog_SetExternalTaskRetries() {
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().serviceTask().camundaExternalTask("anExternalTaskTopic")).endEvent().done());
        this.testRule.deploy(((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("calledProcess")).endEvent().done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.identityService.setAuthenticatedUserId("aUserId");
        this.externalTaskService.setRetries(((ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult()).getId(), 65);
        this.identityService.clearAuthentication();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        MatcherAssert.assertThat((Object)userOperationLog, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)userOperationLog.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldResolveUserOperationLog_ClaimTask() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aUserId");
        this.taskService.setAssignee(taskId, "aUserId");
        this.identityService.clearAuthentication();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        MatcherAssert.assertThat((Object)userOperationLog, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)userOperationLog.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldResolveUserOperationLog_CreateAttachment() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.identityService.setAuthenticatedUserId("aUserId");
        this.taskService.createAttachment(null, null, ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId(), null, null, "http://eximeebpms.com");
        this.identityService.clearAuthentication();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        MatcherAssert.assertThat((Object)userOperationLog, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)userOperationLog.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldResolveIdentityLink_AddCandidateUser() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.addCandidateUser(taskId, "aUserId");
        HistoricIdentityLinkLog historicIdentityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().userId("aUserId").singleResult();
        MatcherAssert.assertThat((Object)historicIdentityLinkLog, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)historicIdentityLinkLog.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldNotResolveIdentityLink_AddCandidateUser() {
        Task aTask = this.taskService.newTask();
        this.taskService.saveTask(aTask);
        this.taskService.addCandidateUser(aTask.getId(), "aUserId");
        HistoricIdentityLinkLog historicIdentityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        MatcherAssert.assertThat((Object)historicIdentityLinkLog, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)historicIdentityLinkLog.getRootProcessInstanceId(), (Matcher)IsNull.nullValue());
        this.taskService.complete(aTask.getId());
        this.clearHistoricTaskInst(aTask.getId());
    }

    @Test
    public void shouldResolveCommentByProcessInstanceId() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        this.taskService.createComment(null, processInstanceId, "aMessage");
        Comment comment = (Comment)this.taskService.getProcessInstanceComments(processInstanceId).get(0);
        MatcherAssert.assertThat((Object)comment, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)comment.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getRootProcessInstanceId()));
    }

    @Test
    public void shouldResolveCommentByTaskId() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.createComment(taskId, null, "aMessage");
        Comment comment = (Comment)this.taskService.getTaskComments(taskId).get(0);
        MatcherAssert.assertThat((Object)comment, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)comment.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getRootProcessInstanceId()));
    }

    @Test
    public void shouldNotResolveCommentByWrongTaskIdAndProcessInstanceId() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        this.taskService.createComment("aNonExistentTaskId", processInstanceId, "aMessage");
        Comment comment = (Comment)this.taskService.getProcessInstanceComments(processInstanceId).get(0);
        MatcherAssert.assertThat((Object)comment, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)comment.getRootProcessInstanceId(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldResolveCommentByTaskIdAndWrongProcessInstanceId() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.createComment(taskId, "aNonExistentProcessInstanceId", "aMessage");
        Comment comment = (Comment)this.taskService.getTaskComments(taskId).get(0);
        MatcherAssert.assertThat((Object)comment, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)comment.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getRootProcessInstanceId()));
    }

    @Test
    public void shouldNotResolveCommentByWrongProcessInstanceId() {
        this.taskService.createComment(null, "aNonExistentProcessInstanceId", "aMessage");
        Comment comment = (Comment)this.taskService.getProcessInstanceComments("aNonExistentProcessInstanceId").get(0);
        MatcherAssert.assertThat((Object)comment, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)comment.getRootProcessInstanceId(), (Matcher)IsNull.nullValue());
        this.clearCommentByProcessInstanceId("aNonExistentProcessInstanceId");
    }

    @Test
    public void shouldNotResolveCommentByWrongTaskId() {
        this.taskService.createComment("aNonExistentTaskId", null, "aMessage");
        Comment comment = (Comment)this.taskService.getTaskComments("aNonExistentTaskId").get(0);
        MatcherAssert.assertThat((Object)comment, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)comment.getRootProcessInstanceId(), (Matcher)IsNull.nullValue());
        this.clearCommentByTaskId("aNonExistentTaskId");
    }

    @Test
    public void shouldResolveAttachmentByProcessInstanceId() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        String attachmentId = this.taskService.createAttachment(null, null, processInstanceId, null, null, "http://eximeebpms.com").getId();
        Attachment attachment = this.taskService.getAttachment(attachmentId);
        MatcherAssert.assertThat((Object)attachment, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)attachment.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getRootProcessInstanceId()));
    }

    @Test
    public void shouldResolveAttachmentByTaskId() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        String attachmentId = this.taskService.createAttachment(null, taskId, null, null, null, "http://eximeebpms.com").getId();
        Attachment attachment = this.taskService.getAttachment(attachmentId);
        MatcherAssert.assertThat((Object)attachment, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)attachment.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getRootProcessInstanceId()));
    }

    @Test
    public void shouldNotResolveAttachmentByWrongTaskIdAndProcessInstanceId() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        String attachmentId = this.taskService.createAttachment(null, "aWrongTaskId", processInstanceId, null, null, "http://eximeebpms.com").getId();
        Attachment attachment = this.taskService.getAttachment(attachmentId);
        MatcherAssert.assertThat((Object)attachment, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)attachment.getRootProcessInstanceId(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldResolveAttachmentByTaskIdAndWrongProcessInstanceId() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        String attachmentId = this.taskService.createAttachment(null, taskId, "aWrongProcessInstanceId", null, null, "http://eximeebpms.com").getId();
        Attachment attachment = this.taskService.getAttachment(attachmentId);
        MatcherAssert.assertThat((Object)attachment, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)attachment.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getRootProcessInstanceId()));
    }

    @Test
    public void shouldNotResolveAttachmentByWrongTaskId() {
        String attachmentId = this.taskService.createAttachment(null, "aWrongTaskId", null, null, null, "http://eximeebpms.com").getId();
        Attachment attachment = this.taskService.getAttachment(attachmentId);
        MatcherAssert.assertThat((Object)attachment, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)attachment.getRootProcessInstanceId(), (Matcher)IsNull.nullValue());
        this.clearAttachment(attachment);
    }

    @Test
    public void shouldResolveByteArray_CreateAttachmentByTask() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        AttachmentEntity attachment = (AttachmentEntity)this.taskService.createAttachment(null, taskId, null, null, null, (InputStream)new ByteArrayInputStream("hello world".getBytes()));
        ByteArrayEntity byteArray = this.findByteArrayById(attachment.getContentId());
        MatcherAssert.assertThat((Object)byteArray, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)byteArray.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldResolveByteArray_CreateAttachmentByProcessInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        String calledProcessInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        AttachmentEntity attachment = (AttachmentEntity)this.taskService.createAttachment(null, null, calledProcessInstanceId, null, null, (InputStream)new ByteArrayInputStream("hello world".getBytes()));
        ByteArrayEntity byteArray = this.findByteArrayById(attachment.getContentId());
        MatcherAssert.assertThat((Object)byteArray, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)byteArray.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldResolveByteArray_SetVariable() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.runtimeService.setVariable(processInstance.getId(), "aVariableName", (Object)new ByteArrayInputStream("hello world".getBytes()));
        HistoricVariableInstanceEntity historicVariableInstance = (HistoricVariableInstanceEntity)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        ByteArrayEntity byteArray = this.findByteArrayById(historicVariableInstance.getByteArrayId());
        MatcherAssert.assertThat((Object)byteArray, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)byteArray.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldResolveByteArray_UpdateVariable() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("aVariableName", (Object)Variables.stringValue((String)"aVariableValue")));
        this.runtimeService.setVariable(processInstance.getId(), "aVariableName", (Object)new ByteArrayInputStream("hello world".getBytes()));
        HistoricDetailVariableInstanceUpdateEntity historicDetails = (HistoricDetailVariableInstanceUpdateEntity)this.historyService.createHistoricDetailQuery().variableUpdates().variableTypeIn(new String[]{"Bytes"}).singleResult();
        ByteArrayEntity byteArray = this.findByteArrayById(historicDetails.getByteArrayValueId());
        MatcherAssert.assertThat((Object)byteArray.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldResolveByteArray_JobLog() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricJobLogEventEntity jobLog = (HistoricJobLogEventEntity)this.historyService.createHistoricJobLogQuery().jobExceptionMessage("I'm supposed to fail!").singleResult();
        MatcherAssert.assertThat((Object)jobLog, (Matcher)IsNull.notNullValue());
        ByteArrayEntity byteArray = this.findByteArrayById(jobLog.getExceptionByteArrayId());
        MatcherAssert.assertThat((Object)byteArray.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldResolveByteArray_ExternalTaskLog() {
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().serviceTask().camundaExternalTask("aTopicName")).endEvent().done());
        this.testRule.deploy(((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("calledProcess")).endEvent().done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, "aWorkerId").topic("aTopicName", Integer.MAX_VALUE).execute();
        this.externalTaskService.handleFailure(((LockedExternalTask)tasks.get(0)).getId(), "aWorkerId", null, "errorDetails", 5, 3000L);
        HistoricExternalTaskLogEntity externalTaskLog = (HistoricExternalTaskLogEntity)this.historyService.createHistoricExternalTaskLogQuery().failureLog().singleResult();
        MatcherAssert.assertThat((Object)externalTaskLog, (Matcher)IsNull.notNullValue());
        ByteArrayEntity byteArrayEntity = this.findByteArrayById(externalTaskLog.getErrorDetailsByteArrayId());
        MatcherAssert.assertThat((Object)byteArrayEntity.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void shouldResolveByteArray_DecisionInput() {
        this.testRule.deploy(((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().businessRuleTask().camundaDecisionRef("testDecision")).endEvent().done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        HistoricDecisionInputInstanceEntity historicDecisionInputInstanceEntity = (HistoricDecisionInputInstanceEntity)historicDecisionInstance.getInputs().get(0);
        ByteArrayEntity byteArrayEntity = this.findByteArrayById(historicDecisionInputInstanceEntity.getByteArrayValueId());
        MatcherAssert.assertThat((Object)byteArrayEntity.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void shouldResolveByteArray_DecisionOutput() {
        this.testRule.deploy(((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().businessRuleTask().camundaDecisionRef("testDecision")).endEvent().done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        HistoricDecisionOutputInstanceEntity historicDecisionOutputInstanceEntity = (HistoricDecisionOutputInstanceEntity)historicDecisionInstance.getOutputs().get(0);
        ByteArrayEntity byteArrayEntity = this.findByteArrayById(historicDecisionOutputInstanceEntity.getByteArrayValueId());
        MatcherAssert.assertThat((Object)byteArrayEntity.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    @Deployment
    public void shouldResolveByteArray_DecisionOutputLiteralExpression() {
        this.testRule.deploy(((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().businessRuleTask().camundaDecisionRef("testDecision")).endEvent().done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        MatcherAssert.assertThat((Object)historicDecisionInstance, (Matcher)IsNull.notNullValue());
        HistoricDecisionOutputInstanceEntity historicDecisionOutputInstanceEntity = (HistoricDecisionOutputInstanceEntity)historicDecisionInstance.getOutputs().get(0);
        ByteArrayEntity byteArrayEntity = this.findByteArrayById(historicDecisionOutputInstanceEntity.getByteArrayValueId());
        MatcherAssert.assertThat((Object)byteArrayEntity.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldResolveAuthorization() {
        processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        this.enabledAuth();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.disableAuth();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        MatcherAssert.assertThat((Object)authorization, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)authorization.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
        this.clearAuthorization();
    }
}

