/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.history.removaltime;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.history.HistoryRemovalTimeProvider;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

public class RemovalTimeStrategyConfigurationTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected static ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        processEngineConfiguration.setHistoryRemovalTimeStrategy(null).setHistoryRemovalTimeProvider(null).initHistoryRemovalTime();
    }

    @AfterClass
    public static void tearDown() {
        processEngineConfiguration.setHistoryRemovalTimeStrategy(null).setHistoryRemovalTimeProvider(null).initHistoryRemovalTime();
    }

    @Test
    public void shouldAutomaticallyConfigure() {
        processEngineConfiguration.setHistoryRemovalTimeProvider(null).setHistoryRemovalTimeStrategy(null);
        processEngineConfiguration.initHistoryRemovalTime();
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeStrategy(), (Matcher)Is.is((Object)"end"));
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeProvider(), (Matcher)Is.isA(HistoryRemovalTimeProvider.class));
    }

    @Test
    public void shouldConfigureToStart() {
        processEngineConfiguration.setHistoryRemovalTimeProvider((HistoryRemovalTimeProvider)Mockito.mock(HistoryRemovalTimeProvider.class)).setHistoryRemovalTimeStrategy("start");
        processEngineConfiguration.initHistoryRemovalTime();
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeStrategy(), (Matcher)Is.is((Object)"start"));
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeProvider(), (Matcher)Is.isA(HistoryRemovalTimeProvider.class));
    }

    @Test
    public void shouldConfigureToEnd() {
        processEngineConfiguration.setHistoryRemovalTimeProvider((HistoryRemovalTimeProvider)Mockito.mock(HistoryRemovalTimeProvider.class)).setHistoryRemovalTimeStrategy("end");
        processEngineConfiguration.initHistoryRemovalTime();
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeStrategy(), (Matcher)Is.is((Object)"end"));
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeProvider(), (Matcher)Is.isA(HistoryRemovalTimeProvider.class));
    }

    @Test
    public void shouldConfigureToNone() {
        processEngineConfiguration.setHistoryRemovalTimeProvider((HistoryRemovalTimeProvider)Mockito.mock(HistoryRemovalTimeProvider.class)).setHistoryRemovalTimeStrategy("none");
        processEngineConfiguration.initHistoryRemovalTime();
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeStrategy(), (Matcher)Is.is((Object)"none"));
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeProvider(), (Matcher)Is.isA(HistoryRemovalTimeProvider.class));
    }

    @Test
    public void shouldConfigureWithoutProvider() {
        processEngineConfiguration.setHistoryRemovalTimeProvider(null).setHistoryRemovalTimeStrategy("end");
        processEngineConfiguration.initHistoryRemovalTime();
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeStrategy(), (Matcher)Is.is((Object)"end"));
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeProvider(), (Matcher)Is.isA(HistoryRemovalTimeProvider.class));
    }

    @Test
    public void shouldConfigureWithNotExistentStrategy() {
        processEngineConfiguration.setHistoryRemovalTimeStrategy("notExistentStrategy");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> processEngineConfiguration.initHistoryRemovalTime()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("history removal time strategy must be set to 'start', 'end' or 'none'");
        MatcherAssert.assertThat((Object)processEngineConfiguration.getHistoryRemovalTimeProvider(), (Matcher)Is.isA(HistoryRemovalTimeProvider.class));
    }
}

