/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.history.removaltime.batch.helper;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import org.eximeebpms.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.history.DefaultHistoryRemovalTimeProvider;
import org.eximeebpms.bpm.engine.impl.history.HistoryRemovalTimeProvider;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.repository.DecisionDefinition;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.resources.GetByteArrayCommand;
import org.eximeebpms.bpm.engine.test.bpmn.async.FailingExecutionListener;
import org.eximeebpms.bpm.engine.test.util.BatchRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ResetDmnConfigUtil;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.CallActivityBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ProcessBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.StartEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.runner.Description;

public class BatchSetRemovalTimeRule
extends BatchRule {
    public final Date CURRENT_DATE = new GregorianCalendar(2013, 2, 18, 13, 0, 0).getTime();
    public final Date REMOVAL_TIME = new Date(1363609000000L);

    public BatchSetRemovalTimeRule(ProcessEngineRule engineRule, ProcessEngineTestRule engineTestRule) {
        super(engineRule, engineTestRule);
    }

    protected void starting(Description description) {
        this.getProcessEngineConfiguration().setHistoryRemovalTimeProvider((HistoryRemovalTimeProvider)new DefaultHistoryRemovalTimeProvider()).setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.getProcessEngineConfiguration().getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
        ClockUtil.setCurrentTime((Date)this.CURRENT_DATE);
        super.starting(description);
    }

    @Override
    protected void finished(Description description) {
        super.finished(description);
        this.getProcessEngineConfiguration().setHistoryRemovalTimeProvider(null).setHistoryRemovalTimeStrategy(null).initHistoryRemovalTime();
        this.getProcessEngineConfiguration().setBatchOperationHistoryTimeToLive(null);
        this.getProcessEngineConfiguration().setBatchOperationsForHistoryCleanup(null);
        this.getProcessEngineConfiguration().setBatchOperationHistoryTimeToLive(null);
        this.getProcessEngineConfiguration().setHistoryCleanupStrategy(null);
        this.getProcessEngineConfiguration().initHistoryCleanup();
        this.getProcessEngineConfiguration().setInvocationsPerBatchJob(1);
        this.getProcessEngineConfiguration().setDmnEnabled(true);
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.getProcessEngineConfiguration().getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
        this.getProcessEngineConfiguration().setEnableHistoricInstancePermissions(false);
        this.getProcessEngineConfiguration().setAuthorizationEnabled(false);
    }

    @Override
    public void clearDatabase() {
        super.clearDatabase();
        this.clearAuthorization();
    }

    public TestProcessBuilder process() {
        return new TestProcessBuilder();
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.engineRule.getProcessEngineConfiguration();
    }

    public void updateHistoryTimeToLive(String key, int ttl) {
        this.updateHistoryTimeToLive(ttl, key);
    }

    public void updateHistoryTimeToLive(int ttl, String ... keys) {
        for (String key : keys) {
            String processDefinitionId = ((ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(key).singleResult()).getId();
            this.engineRule.getRepositoryService().updateProcessDefinitionHistoryTimeToLive(processDefinitionId, Integer.valueOf(ttl));
        }
    }

    public void updateHistoryTimeToLiveDmn(String key, int ttl) {
        this.updateHistoryTimeToLiveDmn(ttl, key);
    }

    public void updateHistoryTimeToLiveDmn(int ttl, String ... keys) {
        for (String key : keys) {
            String decisionDefinitionId = ((DecisionDefinition)this.engineRule.getRepositoryService().createDecisionDefinitionQuery().decisionDefinitionKey(key).singleResult()).getId();
            this.engineRule.getRepositoryService().updateDecisionDefinitionHistoryTimeToLive(decisionDefinitionId, Integer.valueOf(ttl));
        }
    }

    public void enableAuth() {
        this.getProcessEngineConfiguration().setAuthorizationEnabled(true);
    }

    public void disableAuth() {
        this.getProcessEngineConfiguration().setAuthorizationEnabled(false);
    }

    public void clearAuthorization() {
        this.engineRule.getAuthorizationService().createAuthorizationQuery().list().forEach(authorization -> this.engineRule.getAuthorizationService().deleteAuthorization(authorization.getId()));
    }

    public static Date addDays(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, amount);
        return c.getTime();
    }

    public ByteArrayEntity findByteArrayById(String byteArrayId) {
        CommandExecutor commandExecutor = this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        return (ByteArrayEntity)commandExecutor.execute((Command)new GetByteArrayCommand(byteArrayId));
    }

    public class TestProcessBuilder {
        protected static final String PROCESS_KEY = "process";
        protected static final String ROOT_PROCESS_KEY = "rootProcess";
        ProcessBuilder builder = (ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLiveString(null);
        StartEventBuilder startEventBuilder = this.builder.startEvent();
        ProcessBuilder rootProcessBuilder = null;
        Integer ttl;
        CallActivityBuilder callActivityBuilder;

        public TestProcessBuilder ttl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public TestProcessBuilder async() {
            this.startEventBuilder.camundaAsyncBefore();
            return this;
        }

        public TestProcessBuilder ruleTask(String ref) {
            this.startEventBuilder.businessRuleTask().camundaDecisionRef(ref);
            return this;
        }

        public TestProcessBuilder call() {
            this.rootProcessBuilder = (ProcessBuilder)Bpmn.createExecutableProcess((String)ROOT_PROCESS_KEY).camundaHistoryTimeToLiveString(null);
            this.callActivityBuilder = (CallActivityBuilder)this.rootProcessBuilder.startEvent().callActivity().calledElement(PROCESS_KEY);
            return this;
        }

        public TestProcessBuilder passVars(String ... vars) {
            for (String variable : vars) {
                this.callActivityBuilder.camundaIn(variable, variable);
            }
            this.callActivityBuilder.endEvent();
            return this;
        }

        public TestProcessBuilder userTask() {
            ((UserTaskBuilder)this.startEventBuilder.userTask("userTask").name("userTask")).camundaAssignee("anAssignee");
            return this;
        }

        public TestProcessBuilder scriptTask() {
            ((ScriptTaskBuilder)this.startEventBuilder.scriptTask().scriptFormat("groovy")).scriptText("throw new RuntimeException()");
            return this;
        }

        public TestProcessBuilder externalTask() {
            this.startEventBuilder.serviceTask().camundaExternalTask("aTopicName");
            return this;
        }

        public TestProcessBuilder serviceTask() {
            this.startEventBuilder.serviceTask().camundaExpression("${true}");
            return this;
        }

        public TestProcessBuilder failingCustomListener() {
            this.startEventBuilder.userTask().camundaExecutionListenerClass("end", FailingExecutionListener.class);
            return this;
        }

        public TestProcessBuilder deploy() {
            if (this.ttl != null) {
                if (this.rootProcessBuilder != null) {
                    this.rootProcessBuilder.camundaHistoryTimeToLive(this.ttl);
                } else {
                    this.builder.camundaHistoryTimeToLive(this.ttl);
                }
            }
            BpmnModelInstance process = this.startEventBuilder.endEvent().done();
            BatchSetRemovalTimeRule.this.engineTestRule.deploy(process);
            if (this.rootProcessBuilder != null) {
                BatchSetRemovalTimeRule.this.engineTestRule.deploy(this.rootProcessBuilder.done());
            }
            return this;
        }

        public String start() {
            return this.startWithVariables(null);
        }

        public String startWithVariables(Map<String, Object> variables) {
            String key = null;
            key = this.rootProcessBuilder != null ? ROOT_PROCESS_KEY : PROCESS_KEY;
            return BatchSetRemovalTimeRule.this.engineRule.getRuntimeService().startProcessInstanceByKey(key, variables).getId();
        }
    }
}

