/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.identity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.authorization.Authorization;
import org.eximeebpms.bpm.engine.authorization.BatchPermissions;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.eximeebpms.bpm.engine.authorization.ProcessInstancePermissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.eximeebpms.bpm.engine.test.api.identity.TestPermissions;
import org.eximeebpms.bpm.engine.test.api.identity.TestResource;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class AuthorizationServiceTest
extends PluggableProcessEngineTest {
    protected String userId = "test";
    protected String groupId = "accounting";

    @After
    public void tearDown() throws Exception {
        this.cleanupAfterTest();
    }

    @Test
    public void testGlobalAuthorizationType() {
        Authorization globalAuthorization = this.authorizationService.createNewAuthorization(0);
        globalAuthorization.setUserId(null);
        globalAuthorization.setUserId("*");
        try {
            globalAuthorization.setUserId("something");
            Assert.fail((String)"exception expected");
        }
        catch (Exception e) {
            this.testRule.assertTextPresent("ENGINE-03028 Illegal value 'something' for userId for GLOBAL authorization. Must be '*'", e.getMessage());
        }
        globalAuthorization.setGroupId(null);
        try {
            globalAuthorization.setGroupId("something");
            Assert.fail((String)"exception expected");
        }
        catch (Exception e) {
            this.testRule.assertTextPresent("ENGINE-03027 Cannot use 'groupId' for GLOBAL authorization", e.getMessage());
        }
    }

    @Test
    public void testGrantAuthorizationType() {
        Authorization grantAuthorization = this.authorizationService.createNewAuthorization(1);
        grantAuthorization.setUserId(null);
        grantAuthorization.setUserId("*");
        grantAuthorization.setUserId("something");
        grantAuthorization.setGroupId(null);
        grantAuthorization.setGroupId("something");
    }

    @Test
    public void testRevokeAuthorizationType() {
        Authorization revokeAuthorization = this.authorizationService.createNewAuthorization(2);
        revokeAuthorization.setUserId(null);
        revokeAuthorization.setUserId("*");
        revokeAuthorization.setUserId("something");
        revokeAuthorization.setGroupId(null);
        revokeAuthorization.setGroupId("something");
    }

    @Test
    public void testDeleteNonExistingAuthorization() {
        try {
            this.authorizationService.deleteAuthorization("nonExisiting");
            Assert.fail();
        }
        catch (Exception e) {
            this.testRule.assertTextPresent("Authorization for Id 'nonExisiting' does not exist: authorization is null", e.getMessage());
        }
    }

    @Test
    public void testCreateAuthorizationWithUserId() {
        TestResource resource1 = TestResource.RESOURCE1;
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().count());
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("aUserId");
        authorization.setResource((Resource)resource1);
        this.authorizationService.saveAuthorization(authorization);
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().count());
        this.authorizationService.deleteAuthorization(authorization.getId());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().count());
    }

    @Test
    public void testCreateAuthorizationWithGroupId() {
        TestResource resource1 = TestResource.RESOURCE1;
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().count());
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setGroupId("aGroupId");
        authorization.setResource((Resource)resource1);
        this.authorizationService.saveAuthorization(authorization);
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().count());
        this.authorizationService.deleteAuthorization(authorization.getId());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().count());
    }

    @Test
    public void testInvalidCreateAuthorization() {
        TestResource resource1 = TestResource.RESOURCE1;
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setResource((Resource)resource1);
        try {
            this.authorizationService.saveAuthorization(authorization);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Authorization must either have a 'userId' or a 'groupId'."));
        }
        authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setGroupId("someId");
        authorization.setUserId("someOtherId");
        authorization.setResource((Resource)resource1);
        try {
            this.authorizationService.saveAuthorization(authorization);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Authorization must either have a 'userId' or a 'groupId'.", e.getMessage());
        }
        authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("someId");
        try {
            this.authorizationService.saveAuthorization(authorization);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Authorization 'resourceType' cannot be null."));
        }
        authorization = this.authorizationService.createNewAuthorization(2);
        authorization.setUserId("someId");
        try {
            this.authorizationService.saveAuthorization(authorization);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Authorization 'resourceType' cannot be null."));
        }
    }

    @Test
    public void testUniqueUserConstraints() {
        TestResource resource1 = TestResource.RESOURCE1;
        Authorization authorization1 = this.authorizationService.createNewAuthorization(1);
        Authorization authorization2 = this.authorizationService.createNewAuthorization(1);
        authorization1.setResource((Resource)resource1);
        authorization1.setResourceId("someId");
        authorization1.setUserId("someUser");
        authorization2.setResource((Resource)resource1);
        authorization2.setResourceId("someId");
        authorization2.setUserId("someUser");
        this.authorizationService.saveAuthorization(authorization1);
        try {
            this.authorizationService.saveAuthorization(authorization2);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        Authorization authorization3 = this.authorizationService.createNewAuthorization(2);
        authorization3.setResource((Resource)resource1);
        authorization3.setResourceId("someId");
        authorization3.setUserId("someUser");
        this.authorizationService.saveAuthorization(authorization3);
        Authorization authorization4 = this.authorizationService.createNewAuthorization(2);
        authorization4.setResource((Resource)resource1);
        authorization4.setResourceId("someId");
        authorization4.setUserId("someUser");
        try {
            this.authorizationService.saveAuthorization(authorization4);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testUniqueGroupConstraints() {
        TestResource resource1 = TestResource.RESOURCE1;
        Authorization authorization1 = this.authorizationService.createNewAuthorization(1);
        Authorization authorization2 = this.authorizationService.createNewAuthorization(1);
        authorization1.setResource((Resource)resource1);
        authorization1.setResourceId("someId");
        authorization1.setGroupId("someGroup");
        authorization2.setResource((Resource)resource1);
        authorization2.setResourceId("someId");
        authorization2.setGroupId("someGroup");
        this.authorizationService.saveAuthorization(authorization1);
        try {
            this.authorizationService.saveAuthorization(authorization2);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Authorization authorization3 = this.authorizationService.createNewAuthorization(2);
        authorization3.setResource((Resource)resource1);
        authorization3.setResourceId("someId");
        authorization3.setGroupId("someGroup");
        this.authorizationService.saveAuthorization(authorization3);
        Authorization authorization4 = this.authorizationService.createNewAuthorization(2);
        authorization4.setResource((Resource)resource1);
        authorization4.setResourceId("someId");
        authorization4.setGroupId("someGroup");
        try {
            this.authorizationService.saveAuthorization(authorization4);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGlobalUniqueConstraints() {
        TestResource resource1 = TestResource.RESOURCE1;
        Authorization authorization1 = this.authorizationService.createNewAuthorization(0);
        Authorization authorization2 = this.authorizationService.createNewAuthorization(0);
        authorization1.setResource((Resource)resource1);
        authorization1.setResourceId("someId");
        authorization2.setResource((Resource)resource1);
        authorization2.setResourceId("someId");
        this.authorizationService.saveAuthorization(authorization1);
        try {
            this.authorizationService.saveAuthorization(authorization2);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateNewAuthorization() {
        TestResource resource1 = TestResource.RESOURCE1;
        TestResource resource2 = TestResource.RESOURCE2;
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("aUserId");
        authorization.setResource((Resource)resource1);
        authorization.setResourceId("aResourceId");
        authorization.addPermission((Permission)TestPermissions.ACCESS);
        this.authorizationService.saveAuthorization(authorization);
        Authorization savedAuthorization = (Authorization)this.authorizationService.createAuthorizationQuery().singleResult();
        Assert.assertEquals((Object)"aUserId", (Object)savedAuthorization.getUserId());
        Assert.assertEquals((long)resource1.resourceType(), (long)savedAuthorization.getResourceType());
        Assert.assertEquals((Object)"aResourceId", (Object)savedAuthorization.getResourceId());
        Assert.assertTrue((boolean)savedAuthorization.isPermissionGranted((Permission)TestPermissions.ACCESS));
        authorization.setUserId("anotherUserId");
        authorization.setResource((Resource)resource2);
        authorization.setResourceId("anotherResourceId");
        authorization.addPermission((Permission)TestPermissions.DELETE);
        this.authorizationService.saveAuthorization(authorization);
        savedAuthorization = (Authorization)this.authorizationService.createAuthorizationQuery().singleResult();
        Assert.assertEquals((Object)"anotherUserId", (Object)savedAuthorization.getUserId());
        Assert.assertEquals((long)resource2.resourceType(), (long)savedAuthorization.getResourceType());
        Assert.assertEquals((Object)"anotherResourceId", (Object)savedAuthorization.getResourceId());
        Assert.assertTrue((boolean)savedAuthorization.isPermissionGranted((Permission)TestPermissions.ACCESS));
        Assert.assertTrue((boolean)savedAuthorization.isPermissionGranted((Permission)TestPermissions.DELETE));
    }

    @Test
    public void testUpdatePersistentAuthorization() {
        TestResource resource1 = TestResource.RESOURCE1;
        TestResource resource2 = TestResource.RESOURCE2;
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("aUserId");
        authorization.setResource((Resource)resource1);
        authorization.setResourceId("aResourceId");
        authorization.addPermission((Permission)TestPermissions.ACCESS);
        this.authorizationService.saveAuthorization(authorization);
        Authorization savedAuthorization = (Authorization)this.authorizationService.createAuthorizationQuery().singleResult();
        Assert.assertEquals((Object)"aUserId", (Object)savedAuthorization.getUserId());
        Assert.assertEquals((long)resource1.resourceType(), (long)savedAuthorization.getResourceType());
        Assert.assertEquals((Object)"aResourceId", (Object)savedAuthorization.getResourceId());
        Assert.assertTrue((boolean)savedAuthorization.isPermissionGranted((Permission)TestPermissions.ACCESS));
        savedAuthorization.setUserId("anotherUserId");
        savedAuthorization.setResource((Resource)resource2);
        savedAuthorization.setResourceId("anotherResourceId");
        savedAuthorization.addPermission((Permission)TestPermissions.DELETE);
        this.authorizationService.saveAuthorization(savedAuthorization);
        savedAuthorization = (Authorization)this.authorizationService.createAuthorizationQuery().singleResult();
        Assert.assertEquals((Object)"anotherUserId", (Object)savedAuthorization.getUserId());
        Assert.assertEquals((long)resource2.resourceType(), (long)savedAuthorization.getResourceType());
        Assert.assertEquals((Object)"anotherResourceId", (Object)savedAuthorization.getResourceId());
        Assert.assertTrue((boolean)savedAuthorization.isPermissionGranted((Permission)TestPermissions.ACCESS));
        Assert.assertTrue((boolean)savedAuthorization.isPermissionGranted((Permission)TestPermissions.DELETE));
    }

    @Test
    public void testPermissions() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setResource((Resource)Resources.USER);
        Assert.assertEquals((long)1L, (long)authorization.getPermissions((Permission[])Permissions.values()).length);
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.CREATE));
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        authorization.addPermission((Permission)Permissions.CREATE);
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.CREATE));
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        authorization.addPermission((Permission)Permissions.DELETE);
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.CREATE));
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        authorization.addPermission((Permission)Permissions.READ);
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.CREATE));
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        authorization.addPermission((Permission)Permissions.UPDATE);
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.CREATE));
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        authorization.removePermission((Permission)Permissions.CREATE);
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.CREATE));
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        authorization.removePermission((Permission)Permissions.DELETE);
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.CREATE));
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        authorization.removePermission((Permission)Permissions.READ);
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.CREATE));
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        authorization.removePermission((Permission)Permissions.UPDATE);
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.CREATE));
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
    }

    @Test
    public void testGrantAuthPermissions() {
        AuthorizationEntity authorization = new AuthorizationEntity(1);
        authorization.setResource((Resource)Resources.DEPLOYMENT);
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.ALL));
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.NONE));
        List<Permission> perms = Arrays.asList(authorization.getPermissions((Permission[])Permissions.values()));
        Assert.assertTrue((boolean)perms.contains(Permissions.NONE));
        Assert.assertEquals((long)1L, (long)perms.size());
        authorization.addPermission((Permission)Permissions.READ);
        perms = Arrays.asList(authorization.getPermissions((Permission[])Permissions.values()));
        Assert.assertTrue((boolean)perms.contains(Permissions.NONE));
        Assert.assertTrue((boolean)perms.contains(Permissions.READ));
        Assert.assertEquals((long)2L, (long)perms.size());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.NONE));
        try {
            authorization.isPermissionRevoked((Permission)Permissions.READ);
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalStateException e) {
            this.testRule.assertTextPresent("ENGINE-03026 Method 'isPermissionRevoked' cannot be used for authorization with type 'GRANT'.", e.getMessage());
        }
    }

    @Test
    public void testGlobalAuthPermissions() {
        AuthorizationEntity authorization = new AuthorizationEntity(1);
        authorization.setResource((Resource)Resources.DEPLOYMENT);
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.ALL));
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.NONE));
        List<Permission> perms = Arrays.asList(authorization.getPermissions((Permission[])Permissions.values()));
        Assert.assertTrue((boolean)perms.contains(Permissions.NONE));
        Assert.assertEquals((long)1L, (long)perms.size());
        authorization.addPermission((Permission)Permissions.READ);
        perms = Arrays.asList(authorization.getPermissions((Permission[])Permissions.values()));
        Assert.assertTrue((boolean)perms.contains(Permissions.NONE));
        Assert.assertTrue((boolean)perms.contains(Permissions.READ));
        Assert.assertEquals((long)2L, (long)perms.size());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.NONE));
        try {
            authorization.isPermissionRevoked((Permission)Permissions.READ);
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalStateException e) {
            this.testRule.assertTextPresent("ENGINE-03026 Method 'isPermissionRevoked' cannot be used for authorization with type 'GRANT'.", e.getMessage());
        }
    }

    @Test
    public void testRevokeAuthPermissions() {
        AuthorizationEntity authorization = new AuthorizationEntity(2);
        authorization.setResource((Resource)Resources.DEPLOYMENT);
        Assert.assertFalse((boolean)authorization.isPermissionRevoked((Permission)Permissions.ALL));
        List<Permission> perms = Arrays.asList(authorization.getPermissions((Permission[])Permissions.values()));
        Assert.assertEquals((long)0L, (long)perms.size());
        authorization.removePermission((Permission)Permissions.READ);
        perms = Arrays.asList(authorization.getPermissions((Permission[])Permissions.values()));
        Assert.assertTrue((boolean)perms.contains(Permissions.READ));
        Assert.assertTrue((boolean)perms.contains(Permissions.ALL));
        Assert.assertEquals((long)2L, (long)perms.size());
        try {
            authorization.isPermissionGranted((Permission)Permissions.READ);
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalStateException e) {
            this.testRule.assertTextPresent("ENGINE-03026 Method 'isPermissionGranted' cannot be used for authorization with type 'REVOKE'.", e.getMessage());
        }
    }

    @Test
    public void testGlobalGrantAuthorizationCheck() {
        TestResource resource1 = TestResource.RESOURCE1;
        Authorization globalAuth = this.authorizationService.createNewAuthorization(0);
        globalAuth.setResource((Resource)resource1);
        globalAuth.setResourceId("*");
        globalAuth.addPermission((Permission)TestPermissions.ALL);
        this.authorizationService.saveAuthorization(globalAuth);
        List<String> jonnysGroups = Arrays.asList("sales", "marketing");
        List<String> someOneElsesGroups = Arrays.asList("marketing");
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.ALL, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.ALL, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone", null, (Permission)TestPermissions.ACCESS, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone", someOneElsesGroups, (Permission)TestPermissions.ACCESS, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.DELETE, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.ALL, (Resource)resource1, "someId"));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.ALL, (Resource)resource1, "someId"));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone", null, (Permission)TestPermissions.ACCESS, (Resource)resource1, "someId"));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.DELETE, (Resource)resource1, "someOtherId"));
        this.processEngineConfiguration.setAuthorizationEnabled(true);
    }

    @Test
    public void testDisabledAuthorizationCheck() {
        TestResource resource1 = TestResource.RESOURCE1;
        boolean isAuthorized = this.authorizationService.isUserAuthorized("jonny", null, (Permission)Permissions.UPDATE, (Resource)resource1);
        Assert.assertTrue((boolean)isAuthorized);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentIsUserAuthorized() throws Exception {
        int threadCount = 2;
        int invocationCount = 500;
        ExecutorService executorService = Executors.newFixedThreadPool(threadCount);
        try {
            ArrayList<1> callables = new ArrayList<1>();
            for (int i = 0; i < invocationCount; ++i) {
                callables.add(new Callable<Exception>(){

                    @Override
                    public Exception call() throws Exception {
                        try {
                            AuthorizationServiceTest.this.authorizationService.isUserAuthorized("jonny", null, (Permission)Permissions.UPDATE, (Resource)TestResource.RESOURCE1, "*");
                        }
                        catch (Exception e) {
                            return e;
                        }
                        return null;
                    }
                });
            }
            List futures = executorService.invokeAll(callables);
            for (Future future : futures) {
                Exception exception = (Exception)future.get();
                if (exception == null) continue;
                Assert.fail((String)("No exception expected: " + exception.getMessage()));
            }
        }
        finally {
            executorService.shutdownNow();
            executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testReportResourceAuthorization() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId(this.userId);
        authorization.addPermission((Permission)Permissions.ALL);
        authorization.setResource((Resource)Resources.REPORT);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId, Arrays.asList(this.groupId), (Permission)Permissions.ALL, (Resource)Resources.REPORT));
        this.processEngineConfiguration.setAuthorizationEnabled(false);
    }

    @Test
    public void testReportResourcePermissions() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId(this.userId);
        authorization.addPermission((Permission)Permissions.CREATE);
        authorization.addPermission((Permission)Permissions.READ);
        authorization.addPermission((Permission)Permissions.UPDATE);
        authorization.addPermission((Permission)Permissions.DELETE);
        authorization.setResource((Resource)Resources.REPORT);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)Permissions.CREATE, (Resource)Resources.REPORT));
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)Permissions.READ, (Resource)Resources.REPORT));
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)Permissions.UPDATE, (Resource)Resources.REPORT));
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)Permissions.DELETE, (Resource)Resources.REPORT));
        this.processEngineConfiguration.setAuthorizationEnabled(false);
    }

    @Test
    public void testDashboardResourceAuthorization() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId(this.userId);
        authorization.addPermission((Permission)Permissions.ALL);
        authorization.setResource((Resource)Resources.DASHBOARD);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId, Arrays.asList(this.groupId), (Permission)Permissions.ALL, (Resource)Resources.DASHBOARD));
        this.processEngineConfiguration.setAuthorizationEnabled(false);
    }

    @Test
    public void testDashboardResourcePermission() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId(this.userId);
        authorization.addPermission((Permission)Permissions.CREATE);
        authorization.addPermission((Permission)Permissions.READ);
        authorization.addPermission((Permission)Permissions.UPDATE);
        authorization.addPermission((Permission)Permissions.DELETE);
        authorization.setResource((Resource)Resources.DASHBOARD);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)Permissions.CREATE, (Resource)Resources.DASHBOARD));
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)Permissions.READ, (Resource)Resources.DASHBOARD));
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)Permissions.UPDATE, (Resource)Resources.DASHBOARD));
        Assert.assertEquals((Object)true, (Object)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)Permissions.DELETE, (Resource)Resources.DASHBOARD));
        this.processEngineConfiguration.setAuthorizationEnabled(false);
    }

    @Test
    public void testIsPermissionGrantedAccess() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        String userId = "userId";
        authorization.setUserId(userId);
        authorization.addPermission((Permission)Permissions.ACCESS);
        authorization.setResource((Resource)Resources.APPLICATION);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        Authorization authorizationResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{userId}).singleResult();
        Assert.assertTrue((boolean)authorizationResult.isPermissionGranted((Permission)Permissions.ACCESS));
        Assert.assertFalse((boolean)authorizationResult.isPermissionGranted((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES));
        Assert.assertFalse((boolean)authorizationResult.isPermissionGranted((Permission)ProcessInstancePermissions.RETRY_JOB));
        Assert.assertFalse((boolean)authorizationResult.isPermissionGranted((Permission)ProcessDefinitionPermissions.RETRY_JOB));
    }

    @Test
    public void testIsPermissionGrantedRetryJob() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        String userId = "userId";
        authorization.setUserId(userId);
        authorization.addPermission((Permission)ProcessInstancePermissions.RETRY_JOB);
        authorization.setResource((Resource)Resources.PROCESS_INSTANCE);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        Authorization authorizationResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{userId}).singleResult();
        Assert.assertTrue((boolean)authorizationResult.isPermissionGranted((Permission)ProcessInstancePermissions.RETRY_JOB));
        Assert.assertFalse((boolean)authorizationResult.isPermissionGranted((Permission)Permissions.ACCESS));
        Assert.assertFalse((boolean)authorizationResult.isPermissionGranted((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES));
        Assert.assertFalse((boolean)authorizationResult.isPermissionGranted((Permission)ProcessDefinitionPermissions.RETRY_JOB));
    }

    @Test
    public void testIsPermissionGrantedBatchResource() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        String userId = "userId";
        authorization.setUserId(userId);
        authorization.addPermission((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES);
        authorization.addPermission((Permission)BatchPermissions.CREATE_BATCH_DELETE_FINISHED_PROCESS_INSTANCES);
        authorization.addPermission((Permission)BatchPermissions.CREATE_BATCH_DELETE_RUNNING_PROCESS_INSTANCES);
        authorization.setResource((Resource)Resources.BATCH);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        Authorization authorizationResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{userId}).singleResult();
        Assert.assertTrue((boolean)authorizationResult.isPermissionGranted((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES));
        Assert.assertTrue((boolean)authorizationResult.isPermissionGranted((Permission)BatchPermissions.CREATE_BATCH_DELETE_FINISHED_PROCESS_INSTANCES));
        Assert.assertTrue((boolean)authorizationResult.isPermissionGranted((Permission)BatchPermissions.CREATE_BATCH_DELETE_RUNNING_PROCESS_INSTANCES));
        Assert.assertFalse((boolean)authorizationResult.isPermissionGranted((Permission)BatchPermissions.CREATE_BATCH_MODIFY_PROCESS_INSTANCES));
        Assert.assertFalse((boolean)authorizationResult.isPermissionGranted((Permission)Permissions.ACCESS));
        Assert.assertFalse((boolean)authorizationResult.isPermissionGranted((Permission)Permissions.CREATE));
    }

    @Test
    public void testIsPermissionRevokedAccess() {
        Authorization authorization = this.authorizationService.createNewAuthorization(2);
        String userId = "userId";
        authorization.setUserId(userId);
        authorization.removePermission((Permission)Permissions.ACCESS);
        authorization.setResource((Resource)Resources.APPLICATION);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        Authorization authorizationResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{userId}).singleResult();
        Assert.assertTrue((boolean)authorizationResult.isPermissionRevoked((Permission)Permissions.ACCESS));
        Assert.assertFalse((boolean)authorizationResult.isPermissionRevoked((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES));
        Assert.assertFalse((boolean)authorizationResult.isPermissionRevoked((Permission)ProcessInstancePermissions.RETRY_JOB));
        Assert.assertFalse((boolean)authorizationResult.isPermissionRevoked((Permission)ProcessDefinitionPermissions.RETRY_JOB));
    }

    @Test
    public void testIsPermissionRevokedRetryJob() {
        Authorization authorization = this.authorizationService.createNewAuthorization(2);
        String userId = "userId";
        authorization.setUserId(userId);
        authorization.removePermission((Permission)ProcessInstancePermissions.RETRY_JOB);
        authorization.setResource((Resource)Resources.PROCESS_INSTANCE);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        Authorization authorizationResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{userId}).singleResult();
        Assert.assertTrue((boolean)authorizationResult.isPermissionRevoked((Permission)ProcessInstancePermissions.RETRY_JOB));
        Assert.assertFalse((boolean)authorizationResult.isPermissionRevoked((Permission)Permissions.ACCESS));
        Assert.assertFalse((boolean)authorizationResult.isPermissionRevoked((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES));
        Assert.assertFalse((boolean)authorizationResult.isPermissionRevoked((Permission)ProcessDefinitionPermissions.RETRY_JOB));
    }

    @Test
    public void testIsPermissionRevokedBatchResource() {
        Authorization authorization = this.authorizationService.createNewAuthorization(2);
        String userId = "userId";
        authorization.setUserId(userId);
        authorization.removePermission((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES);
        authorization.removePermission((Permission)BatchPermissions.CREATE_BATCH_DELETE_FINISHED_PROCESS_INSTANCES);
        authorization.removePermission((Permission)BatchPermissions.CREATE_BATCH_DELETE_RUNNING_PROCESS_INSTANCES);
        authorization.setResource((Resource)Resources.BATCH);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        Authorization authorizationResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{userId}).singleResult();
        Assert.assertTrue((boolean)authorizationResult.isPermissionRevoked((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES));
        Assert.assertTrue((boolean)authorizationResult.isPermissionRevoked((Permission)BatchPermissions.CREATE_BATCH_DELETE_FINISHED_PROCESS_INSTANCES));
        Assert.assertTrue((boolean)authorizationResult.isPermissionRevoked((Permission)BatchPermissions.CREATE_BATCH_DELETE_RUNNING_PROCESS_INSTANCES));
        Assert.assertFalse((boolean)authorizationResult.isPermissionRevoked((Permission)BatchPermissions.CREATE_BATCH_MODIFY_PROCESS_INSTANCES));
        Assert.assertFalse((boolean)authorizationResult.isPermissionRevoked((Permission)Permissions.ACCESS));
        Assert.assertFalse((boolean)authorizationResult.isPermissionRevoked((Permission)Permissions.CREATE));
    }

    @Test
    public void shouldFailSaveAuthorizationWithIncompatibleResourceAndPermission() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("testUser");
        authorization.addPermission((Permission)TestPermissions.RANDOM);
        authorization.setResource((Resource)Resources.TASK);
        authorization.setResourceId("*");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.authorizationService.saveAuthorization(authorization)).isInstanceOf(BadUserRequestException.class)).hasMessage("ENGINE-03087 The resource type with id:'" + Resources.TASK.resourceType() + "' is not valid for '" + TestPermissions.RANDOM.getName() + "' permission.");
    }

    protected void cleanupAfterTest() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }
}

