/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.identity;

import org.eximeebpms.bpm.engine.impl.digest.DatabasePrefixHandler;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class DatabasePrefixHandlerTest {
    DatabasePrefixHandler prefixHandler;

    @Before
    public void inti() {
        this.prefixHandler = new DatabasePrefixHandler();
    }

    @Test
    public void testGeneratePrefix() {
        String algorithmName = "test";
        String prefix = this.prefixHandler.generatePrefix(algorithmName);
        MatcherAssert.assertThat((Object)prefix, (Matcher)CoreMatchers.is((Object)"{test}"));
    }

    @Test
    public void testRetrieveAlgorithmName() {
        String encryptedPasswordWithPrefix = "{SHA}n3fE9/7XOmgD3BkeJlC+JLyb/Qg=";
        String algorithmName = this.prefixHandler.retrieveAlgorithmName(encryptedPasswordWithPrefix);
        MatcherAssert.assertThat((Object)algorithmName, (Matcher)CoreMatchers.is((Object)"SHA"));
    }

    @Test
    public void retrieveAlgorithmForInvalidInput() {
        String encryptedPasswordWithPrefix = "xxx{SHA}n3fE9/7XOmgD3BkeJlC+JLyb/Qg=";
        String algorithmName = this.prefixHandler.retrieveAlgorithmName(encryptedPasswordWithPrefix);
        MatcherAssert.assertThat((Object)algorithmName, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void retrieveAlgorithmWithMissingAlgorithmPrefix() {
        String encryptedPasswordWithPrefix = "n3fE9/7XOmgD3BkeJlC+JLyb/Qg=";
        String algorithmName = this.prefixHandler.retrieveAlgorithmName(encryptedPasswordWithPrefix);
        MatcherAssert.assertThat((Object)algorithmName, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void retrieveAlgorithmWithErroneousAlgorithmPrefix() {
        String encryptedPasswordWithPrefix = "{SHAn3fE9/7XOmgD3BkeJlC+JLyb/Qg=";
        String algorithmName = this.prefixHandler.retrieveAlgorithmName(encryptedPasswordWithPrefix);
        MatcherAssert.assertThat((Object)algorithmName, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void removePrefix() {
        String encryptedPasswordWithPrefix = "{SHA}n3fE9/7XOmgD3BkeJlC+JLyb/Qg=";
        String encryptedPassword = this.prefixHandler.removePrefix(encryptedPasswordWithPrefix);
        MatcherAssert.assertThat((Object)encryptedPassword, (Matcher)CoreMatchers.is((Object)"n3fE9/7XOmgD3BkeJlC+JLyb/Qg="));
    }

    @Test
    public void removePrefixForInvalidInput() {
        String encryptedPasswordWithPrefix = "xxx{SHA}n3fE9/7XOmgD3BkeJlC+JLyb/Qg=";
        String encryptedPassword = this.prefixHandler.removePrefix(encryptedPasswordWithPrefix);
        MatcherAssert.assertThat((Object)encryptedPassword, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void removePrefixWithMissingAlgorithmPrefix() {
        String encryptedPasswordWithPrefix = "n3fE9/7XOmgD3BkeJlC+JLyb/Qg=";
        String encryptedPassword = this.prefixHandler.removePrefix(encryptedPasswordWithPrefix);
        MatcherAssert.assertThat((Object)encryptedPassword, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void removePrefixWithErroneousAlgorithmPrefix() {
        String encryptedPasswordWithPrefix = "SHAn3fE9}/7XOmgD3BkeJlC+JLyb/Qg=";
        String encryptedPassword = this.prefixHandler.removePrefix(encryptedPasswordWithPrefix);
        MatcherAssert.assertThat((Object)encryptedPassword, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

