/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.identity;

import java.util.List;
import org.eximeebpms.bpm.engine.authorization.Authorization;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultAuthorizationProviderTest
extends PluggableProcessEngineTest {
    @Before
    public void setUp() throws Exception {
        this.identityService.setAuthenticatedUserId("jonny");
        Authorization jonnyIsGod = this.authorizationService.createNewAuthorization(1);
        jonnyIsGod.setUserId("jonny");
        jonnyIsGod.setResource((Resource)Resources.USER);
        jonnyIsGod.setResourceId("*");
        jonnyIsGod.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(jonnyIsGod);
        jonnyIsGod = this.authorizationService.createNewAuthorization(1);
        jonnyIsGod.setUserId("jonny");
        jonnyIsGod.setResource((Resource)Resources.GROUP);
        jonnyIsGod.setResourceId("*");
        jonnyIsGod.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(jonnyIsGod);
        jonnyIsGod = this.authorizationService.createNewAuthorization(1);
        jonnyIsGod.setUserId("jonny");
        jonnyIsGod.setResource((Resource)Resources.AUTHORIZATION);
        jonnyIsGod.setResourceId("*");
        jonnyIsGod.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(jonnyIsGod);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
    }

    @After
    public void tearDown() throws Exception {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        List jonnysAuths = this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"jonny"}).list();
        for (Authorization authorization : jonnysAuths) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }

    @Test
    public void testCreateUser() {
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"jonny2"}).count());
        this.identityService.saveUser(this.identityService.newUser("jonny2"));
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"jonny2"}).singleResult();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)1L, (long)authorization.getAuthorizationType());
        Assert.assertEquals((long)Resources.USER.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)"jonny2", (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.ALL));
        this.identityService.deleteUser("jonny2");
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"jonny2"}).count());
    }

    @Test
    public void testCreateGroup() {
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"sales"}).count());
        this.identityService.saveGroup(this.identityService.newGroup("sales"));
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"sales"}).singleResult();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)1L, (long)authorization.getAuthorizationType());
        Assert.assertEquals((long)Resources.GROUP.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)"sales", (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        this.identityService.deleteGroup("sales");
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"sales"}).count());
    }
}

