/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.identity;

import java.util.List;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class WriteMultipleEntitiesInOneTransactionTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/eximeebpms/bpm/engine/test/api/identity/WriteMultipleEntitiesInOneTransactionTest.eximeebpms.cfg.xml");
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected IdentityService identityService;

    @Before
    public void setUp() {
        this.identityService = this.engineRule.getIdentityService();
    }

    @Test
    public void testWriteMultipleEntitiesInOneTransaction() {
        Assert.assertTrue((boolean)this.identityService.checkPassword("multipleEntities", "inOneStep"));
        User user = (User)this.identityService.createUserQuery().userId("multipleEntities").singleResult();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"multipleEntities", (Object)user.getId());
        Assert.assertEquals((Object)"{SHA}pfdzmt+49nwknTy7xhZd7ZW5suI=", (Object)user.getPassword());
        List groups = this.identityService.createGroupQuery().groupMember("multipleEntities").list();
        Assert.assertEquals((long)1L, (long)groups.size());
        Group group = (Group)groups.get(0);
        Assert.assertEquals((Object)"multipleEntities_group", (Object)group.getId());
        this.identityService.deleteMembership("multipleEntities", "multipleEntities_group");
        this.identityService.deleteGroup("multipleEntities_group");
        this.identityService.deleteUser("multipleEntities");
    }
}

