/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.mgmt;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.batch.BatchQuery;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class BatchQueryTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper helper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.migrationRule);
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
        ClockUtil.reset();
    }

    @Test
    public void testBatchQuery() {
        Batch batch1 = this.helper.migrateProcessInstancesAsync(1);
        Batch batch2 = this.helper.migrateProcessInstancesAsync(1);
        List list = this.managementService.createBatchQuery().list();
        Assert.assertEquals((long)2L, (long)list.size());
        ArrayList<String> batchIds = new ArrayList<String>();
        for (Batch resultBatch : list) {
            batchIds.add(resultBatch.getId());
        }
        Assert.assertTrue((boolean)batchIds.contains(batch1.getId()));
        Assert.assertTrue((boolean)batchIds.contains(batch2.getId()));
    }

    @Test
    public void testBatchQueryResult() {
        ClockUtil.setCurrentTime((Date)new Date());
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        Batch resultBatch = (Batch)this.managementService.createBatchQuery().singleResult();
        Assert.assertNotNull((Object)batch);
        Assert.assertEquals((Object)batch.getId(), (Object)resultBatch.getId());
        Assert.assertEquals((Object)batch.getBatchJobDefinitionId(), (Object)resultBatch.getBatchJobDefinitionId());
        Assert.assertEquals((Object)batch.getMonitorJobDefinitionId(), (Object)resultBatch.getMonitorJobDefinitionId());
        Assert.assertEquals((Object)batch.getSeedJobDefinitionId(), (Object)resultBatch.getSeedJobDefinitionId());
        Assert.assertEquals((Object)batch.getTenantId(), (Object)resultBatch.getTenantId());
        Assert.assertEquals((Object)batch.getType(), (Object)resultBatch.getType());
        Assert.assertEquals((long)batch.getBatchJobsPerSeed(), (long)resultBatch.getBatchJobsPerSeed());
        Assert.assertEquals((long)batch.getInvocationsPerBatchJob(), (long)resultBatch.getInvocationsPerBatchJob());
        Assert.assertEquals((long)batch.getTotalJobs(), (long)resultBatch.getTotalJobs());
        Assert.assertEquals((long)batch.getJobsCreated(), (long)resultBatch.getJobsCreated());
        Assert.assertEquals((Object)batch.isSuspended(), (Object)resultBatch.isSuspended());
        Assertions.assertThat((Date)batch.getStartTime()).isEqualToIgnoringMillis(resultBatch.getStartTime());
        Assertions.assertThat((Date)batch.getStartTime()).isEqualToIgnoringMillis(ClockUtil.getCurrentTime());
    }

    @Test
    public void testBatchQueryById() {
        Batch batch1 = this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        Batch resultBatch = (Batch)this.managementService.createBatchQuery().batchId(batch1.getId()).singleResult();
        Assert.assertNotNull((Object)resultBatch);
        Assert.assertEquals((Object)batch1.getId(), (Object)resultBatch.getId());
    }

    @Test
    public void testBatchQueryByIdNull() {
        try {
            this.managementService.createBatchQuery().batchId(null).singleResult();
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Batch id is null"});
        }
    }

    @Test
    public void testBatchQueryByType() {
        Batch batch1 = this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        long count = this.managementService.createBatchQuery().type(batch1.getType()).count();
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testBatchQueryByNonExistingType() {
        this.helper.migrateProcessInstancesAsync(1);
        long count = this.managementService.createBatchQuery().type("foo").count();
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testBatchQueryByTypeNull() {
        try {
            this.managementService.createBatchQuery().type(null).singleResult();
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Type is null"});
        }
    }

    @Test
    public void testBatchQueryCount() {
        this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        long count = this.managementService.createBatchQuery().count();
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testBatchQueryOrderByIdAsc() {
        this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        List orderedBatches = ((BatchQuery)this.managementService.createBatchQuery().orderById().asc()).list();
        TestOrderingUtil.verifySorting(orderedBatches, TestOrderingUtil.batchById());
    }

    @Test
    public void testBatchQueryOrderByIdDec() {
        this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        List orderedBatches = ((BatchQuery)this.managementService.createBatchQuery().orderById().desc()).list();
        TestOrderingUtil.verifySorting(orderedBatches, TestOrderingUtil.inverted(TestOrderingUtil.batchById()));
    }

    @Test
    public void testBatchQueryOrderingPropertyWithoutOrder() {
        try {
            this.managementService.createBatchQuery().orderById().singleResult();
            Assert.fail((String)"exception expected");
        }
        catch (NotValidException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Invalid query: call asc() or desc() after using orderByXX()"});
        }
    }

    @Test
    public void testBatchQueryOrderWithoutOrderingProperty() {
        try {
            ((BatchQuery)this.managementService.createBatchQuery().asc()).singleResult();
            Assert.fail((String)"exception expected");
        }
        catch (NotValidException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"You should call any of the orderBy methods first before specifying a direction"});
        }
    }

    @Test
    public void testBatchQueryBySuspendedBatches() {
        Batch batch1 = this.helper.migrateProcessInstancesAsync(1);
        Batch batch2 = this.helper.migrateProcessInstancesAsync(1);
        this.helper.migrateProcessInstancesAsync(1);
        this.managementService.suspendBatchById(batch1.getId());
        this.managementService.suspendBatchById(batch2.getId());
        this.managementService.activateBatchById(batch1.getId());
        BatchQuery query = this.managementService.createBatchQuery().suspended();
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((Object)batch2.getId(), (Object)((Batch)query.singleResult()).getId());
    }

    @Test
    public void testBatchQueryByActiveBatches() {
        Batch batch1 = this.helper.migrateProcessInstancesAsync(1);
        Batch batch2 = this.helper.migrateProcessInstancesAsync(1);
        Batch batch3 = this.helper.migrateProcessInstancesAsync(1);
        this.managementService.suspendBatchById(batch1.getId());
        this.managementService.suspendBatchById(batch2.getId());
        this.managementService.activateBatchById(batch1.getId());
        BatchQuery query = this.managementService.createBatchQuery().active();
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)2L, (long)query.list().size());
        ArrayList<String> foundIds = new ArrayList<String>();
        for (Batch batch : query.list()) {
            foundIds.add(batch.getId());
        }
        Assertions.assertThat(foundIds).contains((Object[])new String[]{batch1.getId(), batch3.getId()});
    }
}

