/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.mgmt;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.eximeebpms.bpm.engine.management.DeploymentStatistics;
import org.eximeebpms.bpm.engine.management.IncidentStatistics;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class DeploymentStatisticsQueryTest
extends PluggableProcessEngineTest {
    @Test
    public void testDeploymentStatisticsQuery() {
        String deploymentName = "my deployment";
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml").addClasspathResource("org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testParallelGatewayStatisticsQuery.bpmn20.xml").name(deploymentName).deploy();
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ParGatewayExampleProcess");
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        Assert.assertEquals((long)2L, (long)result.getInstances());
        Assert.assertEquals((long)0L, (long)result.getFailedJobs());
        Assert.assertEquals((Object)deployment.getId(), (Object)result.getId());
        Assert.assertEquals((Object)deploymentName, (Object)result.getName());
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(deployment.getDeploymentTime());
        cal1.set(14, 0);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(result.getDeploymentTime());
        cal2.set(14, 0);
        Assert.assertTrue((boolean)cal1.equals(cal2));
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    public void testDeploymentStatisticsQueryCountAndPaging() {
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml").addClasspathResource("org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testParallelGatewayStatisticsQuery.bpmn20.xml").deploy();
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ParGatewayExampleProcess");
        org.eximeebpms.bpm.engine.repository.Deployment anotherDeployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml").addClasspathResource("org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testParallelGatewayStatisticsQuery.bpmn20.xml").deploy();
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ParGatewayExampleProcess");
        long count = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs().count();
        Assert.assertEquals((long)2L, (long)count);
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs().listPage(0, 1);
        Assert.assertEquals((long)1L, (long)statistics.size());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        this.repositoryService.deleteDeployment(anotherDeployment.getId(), true);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testDeploymentStatisticsQueryWithFailedJobs() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs().list();
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)result.getFailedJobs());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testDeploymentStatisticsQueryWithIncidents() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeIncidents().list();
        Assert.assertFalse((boolean)statistics.isEmpty());
        Assert.assertEquals((long)1L, (long)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        List incidentStatistics = result.getIncidentStatistics();
        Assert.assertFalse((boolean)incidentStatistics.isEmpty());
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incident = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incident.getIncidentType());
        Assert.assertEquals((long)1L, (long)incident.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testDeploymentStatisticsQueryWithIncidentType() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeIncidentsForType("failedJob").list();
        Assert.assertFalse((boolean)statistics.isEmpty());
        Assert.assertEquals((long)1L, (long)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        List incidentStatistics = result.getIncidentStatistics();
        Assert.assertFalse((boolean)incidentStatistics.isEmpty());
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incident = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incident.getIncidentType());
        Assert.assertEquals((long)1L, (long)incident.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testDeploymentStatisticsQueryWithInvalidIncidentType() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeIncidentsForType("invalid").list();
        Assert.assertFalse((boolean)statistics.isEmpty());
        Assert.assertEquals((long)1L, (long)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        List incidentStatistics = result.getIncidentStatistics();
        Assert.assertTrue((boolean)incidentStatistics.isEmpty());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testDeploymentStatisticsQueryWithIncidentsAndFailedJobs() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeIncidents().includeFailedJobs().list();
        Assert.assertFalse((boolean)statistics.isEmpty());
        Assert.assertEquals((long)1L, (long)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)result.getFailedJobs());
        List incidentStatistics = result.getIncidentStatistics();
        Assert.assertFalse((boolean)incidentStatistics.isEmpty());
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incident = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incident.getIncidentType());
        Assert.assertEquals((long)1L, (long)incident.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testCallActivityWithIncidentsWithoutFailedJobs.bpmn20.xml"})
    public void testDeploymentStatisticsQueryWithTwoIncidentsAndOneFailedJobs() {
        this.runtimeService.startProcessInstanceByKey("callExampleSubProcess");
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeIncidents().includeFailedJobs().list();
        Assert.assertFalse((boolean)statistics.isEmpty());
        Assert.assertEquals((long)1L, (long)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)result.getFailedJobs());
        List incidentStatistics = result.getIncidentStatistics();
        Assert.assertFalse((boolean)incidentStatistics.isEmpty());
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incident = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incident.getIncidentType());
        Assert.assertEquals((long)2L, (long)incident.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testParallelGatewayStatisticsQuery.bpmn20.xml"})
    public void testDeploymentStatisticsQueryWithoutRunningInstances() {
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)result.getInstances());
        Assert.assertEquals((long)0L, (long)result.getFailedJobs());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    @Test
    public void testQueryByIncidentsWithFailedTimerStartEvent() {
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)result.getInstances());
        List incidentStatistics = result.getIncidentStatistics();
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incidentStatistic = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((long)1L, (long)incidentStatistic.getIncidentCount());
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistic.getIncidentType());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    @Test
    public void testQueryByIncidentTypeWithFailedTimerStartEvent() {
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeIncidentsForType("failedJob").list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)result.getInstances());
        List incidentStatistics = result.getIncidentStatistics();
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incidentStatistic = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((long)1L, (long)incidentStatistic.getIncidentCount());
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistic.getIncidentType());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    @Test
    public void testQueryByFailedJobsWithFailedTimerStartEvent() {
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)result.getInstances());
        Assert.assertEquals((long)1L, (long)result.getFailedJobs());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    @Test
    public void testQueryByFailedJobsAndIncidentsWithFailedTimerStartEvent() {
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createDeploymentStatisticsQuery().includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        DeploymentStatistics result = (DeploymentStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)result.getInstances());
        Assert.assertEquals((long)1L, (long)result.getFailedJobs());
        List incidentStatistics = result.getIncidentStatistics();
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incidentStatistic = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((long)1L, (long)incidentStatistic.getIncidentCount());
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistic.getIncidentType());
    }
}

