/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.mgmt;

import java.util.List;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.exception.NotFoundException;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.management.JobDefinition;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.eximeebpms.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class JobDefinitionPriorityTest
extends PluggableProcessEngineTest {
    protected static final long EXPECTED_DEFAULT_PRIORITY = 0L;

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testSetJobDefinitionPriority() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("asyncTaskProcess").startBeforeActivity("task")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(job.getJobDefinitionId()).singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L);
        JobDefinition updatedDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult();
        Assert.assertEquals((long)42L, (long)updatedDefinition.getOverridingJobPriority());
        Job updatedExistingJob = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)job.getPriority(), (long)updatedExistingJob.getPriority());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startBeforeActivity("task")).execute();
        Job newJob = this.getJobThatIsNot(updatedExistingJob);
        Assert.assertEquals((long)42L, (long)newJob.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testSetJobDefinitionPriorityWithCascade() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("asyncTaskProcess").startBeforeActivity("task")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(job.getJobDefinitionId()).singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 52L, true);
        JobDefinition updatedDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult();
        Assert.assertEquals((long)52L, (long)updatedDefinition.getOverridingJobPriority());
        Job updatedExistingJob = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)52L, (long)updatedExistingJob.getPriority());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startBeforeActivity("task")).execute();
        Job newJob = this.getJobThatIsNot(updatedExistingJob);
        Assert.assertEquals((long)52L, (long)newJob.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/jobPrioProcess.bpmn20.xml"})
    @Test
    public void testSetJobDefinitionPriorityOverridesBpmnPriority() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioProcess").startBeforeActivity("task2")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(job.getJobDefinitionId()).singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 62L);
        JobDefinition updatedDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult();
        Assert.assertEquals((long)62L, (long)updatedDefinition.getOverridingJobPriority());
        Job updatedExistingJob = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)5L, (long)updatedExistingJob.getPriority());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startBeforeActivity("task2")).execute();
        Job newJob = this.getJobThatIsNot(updatedExistingJob);
        Assert.assertEquals((long)62L, (long)newJob.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/jobPrioProcess.bpmn20.xml"})
    @Test
    public void testSetJobDefinitionPriorityWithCascadeOverridesBpmnPriority() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioProcess").startBeforeActivity("task2")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(job.getJobDefinitionId()).singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 72L, true);
        JobDefinition updatedDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult();
        Assert.assertEquals((long)72L, (long)updatedDefinition.getOverridingJobPriority());
        Job updatedExistingJob = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)72L, (long)updatedExistingJob.getPriority());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instance.getId()).startBeforeActivity("task2")).execute();
        Job newJob = this.getJobThatIsNot(updatedExistingJob);
        Assert.assertEquals((long)72L, (long)newJob.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/jobPrioProcess.bpmn20.xml"})
    @Test
    public void testRedeployOverridesSetJobDefinitionPriority() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioProcess").startBeforeActivity("task2")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(job.getJobDefinitionId()).singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 72L, true);
        JobDefinition updatedDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult();
        Assert.assertEquals((long)72L, (long)updatedDefinition.getOverridingJobPriority());
        Job updatedExistingJob = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)72L, (long)updatedExistingJob.getPriority());
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/mgmt/jobPrioProcess.bpmn20.xml").deploy().getId();
        ProcessInstance secondInstance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioProcess").startBeforeActivity("task2")).execute();
        Job newJob = (Job)this.managementService.createJobQuery().processInstanceId(secondInstance.getId()).singleResult();
        Assert.assertEquals((long)5L, (long)newJob.getPriority());
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testResetJobDefinitionPriority() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 1701L);
        this.managementService.clearOverridingJobPriorityForJobDefinition(jobDefinition.getId());
        JobDefinition updatedDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult();
        Assert.assertNull((Object)updatedDefinition.getOverridingJobPriority());
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("asyncTaskProcess").startBeforeActivity("task")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)0L, (long)job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testResetJobDefinitionPriorityWhenPriorityIsNull() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        Assert.assertNull((Object)jobDefinition.getOverridingJobPriority());
        this.managementService.clearOverridingJobPriorityForJobDefinition(jobDefinition.getId());
        JobDefinition updatedDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobDefinitionId(jobDefinition.getId()).singleResult();
        Assert.assertNull((Object)updatedDefinition.getOverridingJobPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/jobPrioProcess.bpmn20.xml"})
    @Test
    public void testGetJobDefinitionDefaultPriority() {
        List jobDefinitions = this.managementService.createJobDefinitionQuery().list();
        Assert.assertEquals((long)4L, (long)jobDefinitions.size());
        Assert.assertNull((Object)((JobDefinition)jobDefinitions.get(0)).getOverridingJobPriority());
        Assert.assertNull((Object)((JobDefinition)jobDefinitions.get(1)).getOverridingJobPriority());
        Assert.assertNull((Object)((JobDefinition)jobDefinitions.get(2)).getOverridingJobPriority());
        Assert.assertNull((Object)((JobDefinition)jobDefinitions.get(3)).getOverridingJobPriority());
    }

    @Test
    public void testSetNonExistingJobDefinitionPriority() {
        try {
            this.managementService.setOverridingJobPriorityForJobDefinition("someNonExistingJobDefinitionId", 42L);
            Assert.fail((String)"should not succeed");
        }
        catch (NotFoundException e) {
            this.testRule.assertTextPresentIgnoreCase("job definition with id 'someNonExistingJobDefinitionId' does not exist", e.getMessage());
        }
        try {
            this.managementService.setOverridingJobPriorityForJobDefinition("someNonExistingJobDefinitionId", 42L, true);
            Assert.fail((String)"should not succeed");
        }
        catch (NotFoundException e) {
            this.testRule.assertTextPresentIgnoreCase("job definition with id 'someNonExistingJobDefinitionId' does not exist", e.getMessage());
        }
    }

    @Test
    public void testResetNonExistingJobDefinitionPriority() {
        try {
            this.managementService.clearOverridingJobPriorityForJobDefinition("someNonExistingJobDefinitionId");
            Assert.fail((String)"should not succeed");
        }
        catch (NotFoundException e) {
            this.testRule.assertTextPresentIgnoreCase("job definition with id 'someNonExistingJobDefinitionId' does not exist", e.getMessage());
        }
    }

    @Test
    public void testSetNullJobDefinitionPriority() {
        try {
            this.managementService.setOverridingJobPriorityForJobDefinition(null, 42L);
            Assert.fail((String)"should not succeed");
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresentIgnoreCase("jobDefinitionId is null", e.getMessage());
        }
        try {
            this.managementService.setOverridingJobPriorityForJobDefinition(null, 42L, true);
            Assert.fail((String)"should not succeed");
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresentIgnoreCase("jobDefinitionId is null", e.getMessage());
        }
    }

    @Test
    public void testResetNullJobDefinitionPriority() {
        try {
            this.managementService.clearOverridingJobPriorityForJobDefinition(null);
            Assert.fail((String)"should not succeed");
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresentIgnoreCase("jobDefinitionId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testSetJobDefinitionPriorityToExtremeValues() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), Long.MAX_VALUE);
        jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        Assert.assertEquals((long)Long.MAX_VALUE, (long)jobDefinition.getOverridingJobPriority());
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), -9223372036854775807L);
        jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        Assert.assertEquals((long)-9223372036854775807L, (long)jobDefinition.getOverridingJobPriority());
    }

    protected Job getJobThatIsNot(Job other) {
        List jobs = this.managementService.createJobQuery().list();
        Assert.assertEquals((long)2L, (long)jobs.size());
        if (((Job)jobs.get(0)).getId().equals(other.getId())) {
            return (Job)jobs.get(1);
        }
        if (((Job)jobs.get(1)).getId().equals(other.getId())) {
            return (Job)jobs.get(0);
        }
        throw new ProcessEngineException("Job with id " + other.getId() + " does not exist anymore");
    }
}

