/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.mgmt;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.ManagementServiceImpl;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.metrics.MetricsRegistry;
import org.eximeebpms.bpm.engine.impl.telemetry.dto.LicenseKeyDataImpl;
import org.eximeebpms.bpm.engine.impl.telemetry.dto.TelemetryDataImpl;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.impl.util.ParseUtil;
import org.eximeebpms.bpm.engine.telemetry.ApplicationServer;
import org.eximeebpms.bpm.engine.telemetry.Command;
import org.eximeebpms.bpm.engine.telemetry.Metric;
import org.eximeebpms.bpm.engine.telemetry.TelemetryData;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ManagementServiceGetTelemetryDataTest {
    protected static final String IS_TELEMETRY_ENABLED_CMD_NAME = "IsTelemetryEnabledCmd";
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineConfigurationImpl configuration;
    protected ManagementServiceImpl managementService;
    protected MetricsRegistry metricsRegistry;
    protected TelemetryDataImpl defaultTelemetryData;

    @Before
    public void setup() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.managementService = (ManagementServiceImpl)this.engineRule.getManagementService();
        this.metricsRegistry = this.configuration.getMetricsRegistry();
        this.defaultTelemetryData = new TelemetryDataImpl(this.configuration.getTelemetryData());
        this.clearTelemetry();
    }

    @After
    public void tearDown() {
        this.clearTelemetry();
        this.configuration.setTelemetryData(this.defaultTelemetryData);
    }

    protected void clearTelemetry() {
        this.metricsRegistry.clearDiagnosticsMetrics();
        this.managementService.deleteMetrics(null);
        this.configuration.getDiagnosticsRegistry().clear();
    }

    @Test
    public void shouldReturnTelemetryData_TelemetryDisabled() {
        this.managementService.toggleTelemetry(false);
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((Object)telemetryData).isNotNull();
        Assertions.assertThat((String)telemetryData.getInstallation()).isNotEmpty();
    }

    @Test
    public void shouldReturnLicenseKey() {
        this.managementService.setLicenseKeyForDiagnostics(new LicenseKeyDataImpl("customer a", "UNIFIED", "2029-09-01", Boolean.valueOf(false), Collections.singletonMap("camundaBPM", "true"), "raw license"));
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((String)telemetryData.getProduct().getInternals().getLicenseKey().getCustomer()).isEqualTo((Object)"customer a");
        Assertions.assertThat((String)telemetryData.getProduct().getInternals().getLicenseKey().getType()).isEqualTo((Object)"UNIFIED");
        Assertions.assertThat((String)telemetryData.getProduct().getInternals().getLicenseKey().getValidUntil()).isEqualTo((Object)"2029-09-01");
        Assertions.assertThat((Map)telemetryData.getProduct().getInternals().getLicenseKey().getFeatures()).isEqualTo(Collections.singletonMap("camundaBPM", "true"));
        Assertions.assertThat((String)telemetryData.getProduct().getInternals().getLicenseKey().getRaw()).isEqualTo((Object)"raw license");
        Assertions.assertThat((Boolean)telemetryData.getProduct().getInternals().getLicenseKey().isUnlimited()).isFalse();
    }

    @Test
    public void shouldReturnLicenseKeyRaw() {
        this.managementService.setLicenseKeyForDiagnostics(new LicenseKeyDataImpl(null, null, null, null, null, "test license"));
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((String)telemetryData.getProduct().getInternals().getLicenseKey().getRaw()).isEqualTo((Object)"test license");
    }

    @Test
    public void shouldReturnProductInfo() {
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((String)telemetryData.getProduct().getName()).isEqualTo((Object)"Camunda BPM Runtime");
        Assertions.assertThat((String)telemetryData.getProduct().getEdition()).isEqualTo((Object)"community");
        Assertions.assertThat((String)telemetryData.getProduct().getVersion()).isEqualTo((Object)ParseUtil.parseProcessEngineVersion((boolean)true).getVersion());
    }

    @Test
    public void shouldReturnDatabaseInfo() {
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((String)telemetryData.getProduct().getInternals().getDatabase().getVendor()).isEqualTo((Object)this.engineRule.getProcessEngineConfiguration().getDatabaseVendor());
        Assertions.assertThat((String)telemetryData.getProduct().getInternals().getDatabase().getVersion()).isEqualTo((Object)this.engineRule.getProcessEngineConfiguration().getDatabaseVersion());
    }

    @Test
    public void shouldReturnJDKInfo() {
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((String)telemetryData.getProduct().getInternals().getJdk().getVendor()).isEqualTo((Object)ParseUtil.parseJdkDetails().getVendor());
        Assertions.assertThat((String)telemetryData.getProduct().getInternals().getJdk().getVersion()).isEqualTo((Object)ParseUtil.parseJdkDetails().getVersion());
    }

    @Test
    public void shouldReturnWebapps() {
        this.managementService.addWebappToTelemetry("cockpit");
        this.managementService.addWebappToTelemetry("admin");
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((Iterable)telemetryData.getProduct().getInternals().getWebapps()).containsExactlyInAnyOrder((Object[])new String[]{"cockpit", "admin"});
    }

    @Test
    public void shouldReturnApplicationServerInfo() {
        this.managementService.addApplicationServerInfoToTelemetry("Apache Tomcat/10.0.1");
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        ApplicationServer applicationServer = telemetryData.getProduct().getInternals().getApplicationServer();
        Assertions.assertThat((String)applicationServer.getVendor()).isEqualTo((Object)"Apache Tomcat");
        Assertions.assertThat((String)applicationServer.getVersion()).isEqualTo((Object)"Apache Tomcat/10.0.1");
    }

    @Test
    public void shouldStartWithCommandCountZero() {
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((Map)telemetryData.getProduct().getInternals().getCommands()).isEmpty();
    }

    @Test
    public void shouldNotResetCommandCount() {
        this.managementService.isTelemetryEnabled();
        this.managementService.getTelemetryData();
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((long)((Command)telemetryData.getProduct().getInternals().getCommands().get(IS_TELEMETRY_ENABLED_CMD_NAME)).getCount()).isEqualTo(1L);
    }

    @Test
    public void shouldStartWithMetricsCountZero() {
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Map metrics = telemetryData.getProduct().getInternals().getMetrics();
        Assertions.assertThat((Map)metrics).containsOnlyKeys((Object[])new String[]{"flow-node-instances", "process-instances", "executed-decision-elements", "decision-instances"});
        Assertions.assertThat((long)((Metric)metrics.get("flow-node-instances")).getCount()).isZero();
        Assertions.assertThat((long)((Metric)metrics.get("process-instances")).getCount()).isZero();
        Assertions.assertThat((long)((Metric)metrics.get("executed-decision-elements")).getCount()).isZero();
        Assertions.assertThat((long)((Metric)metrics.get("decision-instances")).getCount()).isZero();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldNotResetMetricsCount() {
        this.engineRule.getRuntimeService().startProcessInstanceByKey("oneTaskProcess");
        this.managementService.getTelemetryData();
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((long)((Metric)telemetryData.getProduct().getInternals().getMetrics().get("flow-node-instances")).getCount()).isEqualTo(2L);
        Assertions.assertThat((long)((Metric)telemetryData.getProduct().getInternals().getMetrics().get("process-instances")).getCount()).isEqualTo(1L);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldCollectMetrics_TelemetryDisabled() {
        this.engineRule.getRuntimeService().startProcessInstanceByKey("oneTaskProcess");
        TelemetryData telemetryDataAfterPiStart = this.managementService.getTelemetryData();
        Assertions.assertThat((long)((Metric)telemetryDataAfterPiStart.getProduct().getInternals().getMetrics().get("process-instances")).getCount()).isEqualTo(1L);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldCollectCommands_TelemetryDisabled() {
        this.managementService.isTelemetryEnabled();
        TelemetryData telemetryDataAfterPiStart = this.managementService.getTelemetryData();
        Assertions.assertThat((long)((Command)telemetryDataAfterPiStart.getProduct().getInternals().getCommands().get(IS_TELEMETRY_ENABLED_CMD_NAME)).getCount()).isEqualTo(1L);
    }

    @Test
    public void shouldSetDataCollectionTimeFrameToEngineStartTimeWhenTelemetryDisabled() {
        Date beforeGetTelemetry = ClockUtil.getCurrentTime();
        ClockUtil.offset((Long)1000L);
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((Date)telemetryData.getProduct().getInternals().getDataCollectionStartDate()).isBefore(beforeGetTelemetry);
    }

    @Test
    public void shouldNotResetCollectionTimeFrameAfterGetTelemetryWhenTelemetryDisabled() {
        TelemetryData initialTelemetryData = this.managementService.getTelemetryData();
        TelemetryData secondTelemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((Date)initialTelemetryData.getProduct().getInternals().getDataCollectionStartDate()).isEqualTo((Object)secondTelemetryData.getProduct().getInternals().getDataCollectionStartDate());
    }

    @Test
    public void shouldNotResetCollectionTimeFrameAfterGetTelemetry() {
        TelemetryData initialTelemetryData = this.managementService.getTelemetryData();
        TelemetryData secondTelemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((Date)initialTelemetryData.getProduct().getInternals().getDataCollectionStartDate()).isEqualTo((Object)secondTelemetryData.getProduct().getInternals().getDataCollectionStartDate());
    }

    @Test
    public void shouldNotResetCollectionTimeFrameAfterToggleTelemetry() {
        Date beforeToggleTelemetry = this.managementService.getTelemetryData().getProduct().getInternals().getDataCollectionStartDate();
        this.managementService.toggleTelemetry(false);
        Date afterToggleTelemetry = this.managementService.getTelemetryData().getProduct().getInternals().getDataCollectionStartDate();
        Assertions.assertThat((Date)beforeToggleTelemetry).isNotNull();
        Assertions.assertThat((Date)beforeToggleTelemetry).isEqualTo((Object)afterToggleTelemetry);
    }
}

