/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.mgmt;

import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.management.IncidentStatistics;
import org.eximeebpms.bpm.engine.management.ProcessDefinitionStatistics;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class ProcessDefinitionStatisticsQueryTest
extends PluggableProcessEngineTest {
    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithFailedJobs() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)2L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)1L, (long)definitionResult.getFailedJobs());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithIncidents() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)2L, (long)definitionResult.getInstances());
        Assert.assertFalse((boolean)definitionResult.getIncidentStatistics().isEmpty());
        Assert.assertEquals((long)1L, (long)definitionResult.getIncidentStatistics().size());
        IncidentStatistics incidentStatistics = (IncidentStatistics)definitionResult.getIncidentStatistics().get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistics.getIncidentType());
        Assert.assertEquals((long)1L, (long)incidentStatistics.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithIncidentType() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidentsForType("failedJob").list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)2L, (long)definitionResult.getInstances());
        Assert.assertFalse((boolean)definitionResult.getIncidentStatistics().isEmpty());
        Assert.assertEquals((long)1L, (long)definitionResult.getIncidentStatistics().size());
        IncidentStatistics incidentStatistics = (IncidentStatistics)definitionResult.getIncidentStatistics().get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistics.getIncidentType());
        Assert.assertEquals((long)1L, (long)incidentStatistics.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithInvalidIncidentType() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidentsForType("invalid").list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)2L, (long)definitionResult.getInstances());
        Assert.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithIncidentsAndFailedJobs() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        this.runtimeService.startProcessInstanceByKey("ExampleProcess", parameters);
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)2L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)1L, (long)definitionResult.getFailedJobs());
        Assert.assertFalse((boolean)definitionResult.getIncidentStatistics().isEmpty());
        Assert.assertEquals((long)1L, (long)definitionResult.getIncidentStatistics().size());
        IncidentStatistics incidentStatistics = (IncidentStatistics)definitionResult.getIncidentStatistics().get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistics.getIncidentType());
        Assert.assertEquals((long)1L, (long)incidentStatistics.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithoutRunningInstances() {
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)0L, (long)definitionResult.getFailedJobs());
        statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().list();
        Assert.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryCount() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        this.testRule.executeAvailableJobs();
        long count = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().includeIncidents().count();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testMultiInstanceStatisticsQuery.bpmn20.xml"})
    public void testMultiInstanceProcessDefinitionStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("MIExampleProcess");
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics result = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)result.getInstances());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testSubprocessStatisticsQuery.bpmn20.xml"})
    public void testSubprocessProcessDefinitionStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("ExampleProcess");
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics result = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)result.getInstances());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testCallActivityWithIncidentsWithoutFailedJobs.bpmn20.xml"})
    public void testCallActivityProcessDefinitionStatisticsQuery() {
        this.runtimeService.startProcessInstanceByKey("callExampleSubProcess");
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        for (ProcessDefinitionStatistics result : statistics) {
            if (result.getKey().equals("ExampleProcess")) {
                Assert.assertEquals((long)1L, (long)result.getInstances());
                Assert.assertEquals((long)1L, (long)result.getFailedJobs());
                continue;
            }
            if (result.getKey().equals("callExampleSubProcess")) {
                Assert.assertEquals((long)1L, (long)result.getInstances());
                Assert.assertEquals((long)0L, (long)result.getFailedJobs());
                continue;
            }
            Assert.fail((String)(result + " was not expected."));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryForMultipleVersions() {
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml").deploy();
        List definitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").list();
        for (ProcessDefinition definition : definitions) {
            this.runtimeService.startProcessInstanceById(definition.getId());
        }
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)0L, (long)definitionResult.getFailedJobs());
        Assert.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
        definitionResult = (ProcessDefinitionStatistics)statistics.get(1);
        Assert.assertEquals((long)1L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)0L, (long)definitionResult.getFailedJobs());
        Assert.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryForMultipleVersionsWithFailedJobsAndIncidents() {
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml").deploy();
        List definitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").list();
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        for (ProcessDefinition definition : definitions) {
            this.runtimeService.startProcessInstanceById(definition.getId(), parameters);
        }
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)1L, (long)definitionResult.getFailedJobs());
        List incidentStatistics = definitionResult.getIncidentStatistics();
        Assert.assertFalse((boolean)incidentStatistics.isEmpty());
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incident = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incident.getIncidentType());
        Assert.assertEquals((long)1L, (long)incident.getIncidentCount());
        definitionResult = (ProcessDefinitionStatistics)statistics.get(1);
        Assert.assertEquals((long)1L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)1L, (long)definitionResult.getFailedJobs());
        incidentStatistics = definitionResult.getIncidentStatistics();
        Assert.assertFalse((boolean)incidentStatistics.isEmpty());
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        incident = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incident.getIncidentType());
        Assert.assertEquals((long)1L, (long)incident.getIncidentCount());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryForMultipleVersionsWithIncidentType() {
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml").deploy();
        List definitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").list();
        for (ProcessDefinition definition : definitions) {
            this.runtimeService.startProcessInstanceById(definition.getId());
        }
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().includeIncidentsForType("failedJob").list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        ProcessDefinitionStatistics definitionResult = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)1L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)0L, (long)definitionResult.getFailedJobs());
        Assert.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
        definitionResult = (ProcessDefinitionStatistics)statistics.get(1);
        Assert.assertEquals((long)1L, (long)definitionResult.getInstances());
        Assert.assertEquals((long)0L, (long)definitionResult.getFailedJobs());
        Assert.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQueryWithFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryPagination() {
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testStatisticsQuery.bpmn20.xml").deploy();
        List definitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ExampleProcess").list();
        for (ProcessDefinition definition : definitions) {
            this.runtimeService.startProcessInstanceById(definition.getId());
        }
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().listPage(0, 1);
        Assert.assertEquals((long)1L, (long)statistics.size());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testCallActivityWithIncidentsWithoutFailedJobs.bpmn20.xml"})
    public void testProcessDefinitionStatisticsQueryWithIncidentsWithoutFailedJobs() {
        this.runtimeService.startProcessInstanceByKey("callExampleSubProcess");
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().includeFailedJobs().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        ProcessDefinitionStatistics callExampleSubProcessStaticstics = null;
        ProcessDefinitionStatistics exampleSubProcessStaticstics = null;
        for (ProcessDefinitionStatistics current : statistics) {
            if (current.getKey().equals("callExampleSubProcess")) {
                callExampleSubProcessStaticstics = current;
                continue;
            }
            if (current.getKey().equals("ExampleProcess")) {
                exampleSubProcessStaticstics = current;
                continue;
            }
            Assert.fail((String)(current.getKey() + " was not expected."));
        }
        Assert.assertNotNull(callExampleSubProcessStaticstics);
        Assert.assertNotNull(exampleSubProcessStaticstics);
        Assert.assertEquals((long)1L, (long)callExampleSubProcessStaticstics.getInstances());
        Assert.assertEquals((long)0L, (long)callExampleSubProcessStaticstics.getFailedJobs());
        Assert.assertFalse((boolean)callExampleSubProcessStaticstics.getIncidentStatistics().isEmpty());
        Assert.assertEquals((long)1L, (long)callExampleSubProcessStaticstics.getIncidentStatistics().size());
        IncidentStatistics incidentStatistics = (IncidentStatistics)callExampleSubProcessStaticstics.getIncidentStatistics().get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistics.getIncidentType());
        Assert.assertEquals((long)1L, (long)incidentStatistics.getIncidentCount());
        Assert.assertEquals((long)1L, (long)exampleSubProcessStaticstics.getInstances());
        Assert.assertEquals((long)1L, (long)exampleSubProcessStaticstics.getFailedJobs());
        Assert.assertFalse((boolean)exampleSubProcessStaticstics.getIncidentStatistics().isEmpty());
        Assert.assertEquals((long)1L, (long)exampleSubProcessStaticstics.getIncidentStatistics().size());
        incidentStatistics = (IncidentStatistics)exampleSubProcessStaticstics.getIncidentStatistics().get(0);
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistics.getIncidentType());
        Assert.assertEquals((long)1L, (long)incidentStatistics.getIncidentCount());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    public void testQueryByIncidentsWithFailedTimerStartEvent() {
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics result = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)result.getInstances());
        List incidentStatistics = result.getIncidentStatistics();
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incidentStatistic = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((long)1L, (long)incidentStatistic.getIncidentCount());
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistic.getIncidentType());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    public void testQueryByIncidentTypeWithFailedTimerStartEvent() {
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidentsForType("failedJob").list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics result = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)result.getInstances());
        List incidentStatistics = result.getIncidentStatistics();
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incidentStatistic = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((long)1L, (long)incidentStatistic.getIncidentCount());
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistic.getIncidentType());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    public void testQueryByFailedJobsWithFailedTimerStartEvent() {
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics result = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)result.getInstances());
        Assert.assertEquals((long)1L, (long)result.getFailedJobs());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testFailedTimerStartEvent.bpmn20.xml"})
    public void testQueryByFailedJobsAndIncidentsWithFailedTimerStartEvent() {
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().includeIncidents().list();
        Assert.assertEquals((long)1L, (long)statistics.size());
        ProcessDefinitionStatistics result = (ProcessDefinitionStatistics)statistics.get(0);
        Assert.assertEquals((long)0L, (long)result.getInstances());
        Assert.assertEquals((long)1L, (long)result.getFailedJobs());
        List incidentStatistics = result.getIncidentStatistics();
        Assert.assertEquals((long)1L, (long)incidentStatistics.size());
        IncidentStatistics incidentStatistic = (IncidentStatistics)incidentStatistics.get(0);
        Assert.assertEquals((long)1L, (long)incidentStatistic.getIncidentCount());
        Assert.assertEquals((Object)"failedJob", (Object)incidentStatistic.getIncidentType());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testCallActivityWithIncidentsWithoutFailedJobs.bpmn20.xml"})
    public void testIncludeRootIncidentsOnly() {
        this.runtimeService.startProcessInstanceByKey("callExampleSubProcess");
        this.testRule.executeAvailableJobs();
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeRootIncidents().list();
        Assert.assertEquals((long)2L, (long)statistics.size());
        for (ProcessDefinitionStatistics definitionResult : statistics) {
            if (definitionResult.getKey().equals("callExampleSubProcess")) {
                Assert.assertTrue((boolean)definitionResult.getIncidentStatistics().isEmpty());
                continue;
            }
            if (definitionResult.getKey().equals("ExampleProcess")) {
                Assert.assertFalse((boolean)definitionResult.getIncidentStatistics().isEmpty());
                Assert.assertEquals((long)1L, (long)definitionResult.getIncidentStatistics().size());
                Assert.assertEquals((long)1L, (long)((IncidentStatistics)definitionResult.getIncidentStatistics().get(0)).getIncidentCount());
                continue;
            }
            Assert.fail();
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/mgmt/StatisticsTest.testCallActivityWithIncidentsWithoutFailedJobs.bpmn20.xml"})
    public void testIncludeRootIncidentsFails() {
        this.runtimeService.startProcessInstanceByKey("callExampleSubProcess");
        this.testRule.executeAvailableJobs();
        try {
            this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().includeRootIncidents().list();
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"It is not possible to use includeIncident() and includeRootIncidents() to execute one query"});
        }
    }

    @Test
    public void testProcessDefinitionStatisticsProperties() {
        String resourceName = "org/eximeebpms/bpm/engine/test/api/mgmt/ProcessDefinitionStatisticsQueryTest.testProcessDefinitionStatisticsProperties.bpmn20.xml";
        String deploymentId = this.testRule.deployForTenant("tenant1", resourceName).getId();
        ProcessDefinitionStatistics processDefinitionStatistics = (ProcessDefinitionStatistics)this.managementService.createProcessDefinitionStatisticsQuery().singleResult();
        Assertions.assertThat((String)processDefinitionStatistics.getKey()).isEqualTo((Object)"testProcess");
        Assertions.assertThat((String)processDefinitionStatistics.getName()).isEqualTo((Object)"process name");
        Assertions.assertThat((String)processDefinitionStatistics.getCategory()).isEqualTo((Object)"Examples");
        Assertions.assertThat((String)processDefinitionStatistics.getDescription()).isNull();
        Assertions.assertThat((String)processDefinitionStatistics.getTenantId()).isEqualTo((Object)"tenant1");
        Assertions.assertThat((String)processDefinitionStatistics.getVersionTag()).isEqualTo((Object)"v0.1.0");
        Assertions.assertThat((String)processDefinitionStatistics.getDeploymentId()).isEqualTo((Object)deploymentId);
        Assertions.assertThat((String)processDefinitionStatistics.getResourceName()).isEqualTo((Object)resourceName);
        Assertions.assertThat((String)processDefinitionStatistics.getDiagramResourceName()).isNull();
        Assertions.assertThat((int)processDefinitionStatistics.getVersion()).isEqualTo(1);
        Assertions.assertThat((int)processDefinitionStatistics.getInstances()).isEqualTo(0);
        Assertions.assertThat((int)processDefinitionStatistics.getFailedJobs()).isEqualTo(0);
        Assertions.assertThat((List)processDefinitionStatistics.getIncidentStatistics()).isEmpty();
        Assertions.assertThat((boolean)processDefinitionStatistics.isStartableInTasklist()).isTrue();
    }
}

